# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------


# load modules
import mspy


# DEFAULT LIBS
# ------------

presets = {
    'operator':{},
    'processing':{
        'ESI-ICR Peptides':{
            'crop':{
                'lowMass': 200,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.05,
                'cycles': 1,
            },
            'peakpicking':{
                'snThreshold': 4,
                'absIntThreshold': 0,
                'relIntThreshold': 0.001,
                'adaptiveNoise': 0,
                'pickingHeight': 0.9,
                'smoothing': 0,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 1,
            },
            'deisotoping':{
                'maxCharge': 5,
                'massTolerance': 0.02,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
        'MALDI-TOF Peptides':{
            'crop':{
                'lowMass': 750,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.2,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 3.5,
                'absIntThreshold': 0,
                'relIntThreshold': 0.005,
                'adaptiveNoise': 0,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.15,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
        'MALDI-TOF Proteins 5-20 kDa':{
            'crop':{
                'lowMass': 5000,
                'highMass': 20000,
            },
            'baseline':{
                'segments': 20,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'MA',
                'windowSize': 5,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 2,
                'absIntThreshold': 0,
                'relIntThreshold': 0.01,
                'adaptiveNoise': 1,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 0,
                'monoisotopic': 0,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.1,
                'intTolerance': 0.5,
                'removeIsotopes': 0,
                'removeUnknown': 0,
            },
        },
        'MALDI-TOF PSD':{
            'crop':{
                'lowMass': 0,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 100,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.5,
                'cycles': 2,
            },
            'peakpicking':{
                'snThreshold': 3,
                'absIntThreshold': 0,
                'relIntThreshold': 0.005,
                'adaptiveNoise': 1,
                'pickingHeight': 0.75,
                'smoothing': 1,
                'deisotoping': 1,
                'monoisotopic': 0,
                'removeShoulders': 0,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.2,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 0,
            },
        },
        'MALDI-ICR Peptides':{
            'crop':{
                'lowMass': 750,
                'highMass': 4000,
            },
            'baseline':{
                'segments': 15,
                'offset': 0,
                'smooth': 1,
            },
            'smoothing':{
                'method': 'SG',
                'windowSize': 0.05,
                'cycles': 1,
            },
            'peakpicking':{
                'snThreshold': 4,
                'absIntThreshold': 0,
                'relIntThreshold': 0.001,
                'adaptiveNoise': 0,
                'pickingHeight': 0.9,
                'smoothing': 0,
                'deisotoping': 1,
                'monoisotopic': 1,
                'removeShoulders': 1,
            },
            'deisotoping':{
                'maxCharge': 1,
                'massTolerance': 0.02,
                'intTolerance': 0.5,
                'removeIsotopes': 1,
                'removeUnknown': 1,
            },
        },
    },
    'modifications':{
        '-None-':[],
        'Carbamidomethyl (C) Oxidation (MW)':[
            ['Carbamidomethyl', 'C', 'f'],
            ['Oxidation', 'M', 'v'],
            ['Oxidation', 'W', 'v'],
        ],
        'Oxidation (MW)':[
            ['Oxidation', 'M', 'v'],
            ['Oxidation', 'W', 'v'],
        ],
    },
    'fragments':{
        '-None-':[],
        'CID':['b','y','-NH3','-H2O'],
        'ECD/ETD':['c','y'],
        'ISD':['a','c','y'],
        'PSD':['a','b','y','-NH3','-H2O','im'],
        'Ladder-N':['n-ladder'],
        'Ladder-C':['c-ladder'],
    },
}

mascot = {
    'Matrix Science':{
            'host': 'www.matrixscience.com',
            'path': '/',
            'search': 'cgi/nph-mascot.exe',
            'results': 'cgi/master_results.pl',
            'export': 'cgi/export_dat_2.pl',
            'params': 'cgi/get_params.pl',
    },
}

references = {
    'PepMix Bruker - MALDI Pos Mo':[
        ('Bradykinin (1-7) [M+H]+', 757.399150),
        ('Angiotensin II [M+H]+', 1046.541792),
        ('Angiotensin I [M+H]+', 1296.684768),
        ('Substance P [M+H]+', 1347.735423),
        ('Bombesin [M+H]+', 1619.822341),
        ('ACTH clip (1-17) [M+H]+', 2093.086160),
        ('ACTH clip (18-39) [M+H]+', 2465.198332),
        ('Somatostatin 28 [M+H]+', 3147.470975),
    ],
    'PepMix Bruker - MALDI Neg Mo':[
        ('Angiotensin II [M-H]-', 1044.527247),
        ('Angiotensin I [M-H]-', 1294.670247),
        ('Substance P [M-H]-', 1345.720847),
        ('Bombesin [M-H]-', 1617.807747),
        ('ACTH clip (1-17) [M-H]-', 2091.071647),
        ('ACTH clip (18-39) [M-H]-', 2463.183747),
        ('Somatostatin 28 [M-H]-', 3145.456447),
    ],
    'PepMix Bruker PAC - MALDI Pos Mo':[
        ('Bradykinin (1-7) [M+H]+', 757.399160),
        ('Angiotensin III [M+H]+', 931.514849),
        ('Angiotensin II [M+H]+', 1046.541792),
        ('Angiotensin I [M+H]+', 1296.684768),
        ('Substance P [M+H]+', 1347.735423),
        ('Bombesin [M+H]+', 1619.822341),
        ('Neurotensin [M+H]+', 1672.917000),
        ('Renin Substrate [M+H]+', 1758.932610),
        ('ACTH clip (1-17) [M+H]+', 2093.086160),
        ('ACTH clip (18-39) [M+H]+', 2465.198332),
        ('ACTH clip (1-24) [M+H]+', 2932.587870),
        ('Somatostatin 28 [M+H]+', 3147.470975),
        ('ACTH clip (7-38) [M+H]+', 3657.928900),
    ],
    'ProtMix I Bruker - MALDI Pos Av':[
        ('Insulin [M+H]+', 5735),
        ('Cytochrome C [M+2H]2+', 6181),
        ('Myoglobin [M+2H]2+', 8477),
        ('Ubiquitin I [M+H]+', 8566),
        ('Cytochrom C [M+H]+', 12361),
        ('Myoglobin [M+H]+', 16953),
    ],
    'ProtMix I Bruker - MALDI Neg Av':[
        ('Insulin [M-H]-', 5733),
        ('Cytochrome C [M-2H]2-', 6179),
        ('Myoglobin [M-2H]2-', 8475),
        ('Ubiquitin I [M-H]-', 8564),
        ('Cytochrom C [M-H]-', 12359),
        ('Myoglobin [M-H]-', 16951),
    ],
    'ProtMix II Bruker - MALDI Pos Av':[
        ('Trypsinogen [M+H]+', 23982),
        ('Protein A [M+2H]2+', 22306),
        ('Albumin Bovine [M+2H]2+', 33216),
        ('Protein A [M+H]+', 44613),
        ('Albumin Bovine [M+H]+', 66431),
    ],
    'ProtMix II Bruker - MALDI Neg Av':[
        ('Trypsinogen [M+H]+', 23980),
        ('Protein A [M+2H]2+', 22304),
        ('Albumin Bovine [M+2H]2+', 33214),
        ('Protein A [M+H]+', 44611),
        ('Albumin Bovine [M+H]+', 66429),
    ],
    'Trypsin Promega (Porcine) - MALDI Pos Mo':[
        ('Trypsin (108-115) [M+H]+', 842.5094),
        ('Trypsin (209-216) [M+H]+', 906.5044),
        ('Trypsin (1-8) [M+H]+', 952.3894),
        ('Trypsin (148-157) [M+H]+', 1006.4874),
        ('Trypsin (98-107) [M+H]+', 1045.5637),
        ('Trypsin (134-147) [M+H]+', 1469.7305),
        ('Trypsin (58-72) [M+H]+', 1713.8084),
        ('Trypsin (217-231) [M+H]+', 1736.8425),
        ('Trypsin (116-133) [M+H]+', 1768.7993),
        ('Trypsin (62-77) [M+H]+', 1774.8975),
        ('Trypsin (58-76) [M+H]+', 2083.0096),
        ('Trypsin (158-178) [M+H]+', 2158.0307),
        ('Trypsin (58-77) [M+H]+', 2211.1040),
        ('Trypsin (78-97) [M+H]+', 2283.1802),
        ('Trypsin (179-208) [M+H]+', 3013.3237),
    ],
    'Trypsin Roche (Bovine) - MALDI Pos Mo':[
        ('Trypsin (112-119) [M+H]+', 805.4163),
        ('Trypsin (160-169) [M+H]+', 1020.503),
        ('Trypsin (229-237) [M+H]+', 1111.5605),
        ('Trypsin (207-220) [M+H]+', 1433.7206),
        ('Trypsin (70-89) [M+H]+', 2163.0564),
        ('Trypsin (90-109) [M+H]+', 2273.1595),
    ],
    'Trypsin Roche (Porcine) - MALDI Pos Mo':[
        ('Trypsin (108-115) [M+H]+', 842.5094),
        ('Trypsin (134-147) [M+H]+', 1469.7305),
        ('Trypsin (58-74) [M+H]+', 1940.9354),
        ('Trypsin (116-133) [M+H]+', 1768.7993),
        ('Trypsin (98-107) [M+H]+', 1045.5637),
        ('Trypsin (58-77) [M+H]+', 2211.104),
        ('Trypsin (148-157) [M+H]+', 1006.4874),
    ],
    'HCCA Clusters - MALDI Pos Mo':[
        ('HCCA [M+H-H2O]+', 172.039304),
        ('HCCA [M+H]+', 190.049869),
        ('HCCA [M+Na-H2O]+', 194.021249),
        ('HCCA [M+Na]+', 212.031814),
        ('HCCA [M+K-H2O]+', 209.995186),
        ('HCCA [M+K]+', 228.005751),
        ('HCCA [2M+H-H2O]+', 361.081897),
        ('HCCA [2M+H]+', 379.092462),
        ('HCCA [2M+Na-H2O]+', 383.063842),
        ('HCCA [2M+Na]+', 401.074407),
        ('HCCA [2M+K-H2O]+', 399.037779),
        ('HCCA [2M+K]+', 417.048344),
        ('HCCA [2M+K+Na-H2O]+', 422.027),
        ('HCCA [3M+H-H2O]+', 550.12449),
        ('HCCA [3M+H]+', 568.135055),
        ('HCCA [3M+Na-H2O]+', 572.106435),
        ('HCCA [3M+Na]+', 590.117),
        ('HCCA [3M+K-H2O]+', 588.080372),
        ('HCCA [3M+K]+', 606.090937),
        ('HCCA [3M+K+Na-H2O]+', 611.069593),
        ('HCCA [4M+H-H2O]+', 739.167083),
        ('HCCA [4M+H]+', 757.177648),
        ('HCCA [4M+Na-H2O]+', 761.149028),
        ('HCCA [4M+Na]+', 779.159593),
        ('HCCA [4M+K-H2O]+', 777.122965),
        ('HCCA [4M+K]+', 795.13353),
        ('HCCA [4M+K+Na-H2O]+', 800.112186),
        ('HCCA [5M+H-H2O]+', 928.209676),
        ('HCCA [5M+H]+', 946.220241),
        ('HCCA [5M+Na-H2O]+', 950.191621),
        ('HCCA [5M+Na]+', 968.202186),
        ('HCCA [5M+K-H2O]+', 966.165558),
        ('HCCA [5M+K]+', 984.176123),
        ('HCCA [5M+K+Na-H2O]+', 989.154779),
        ('HCCA [6M+H-H2O]+', 1117.252269),
        ('HCCA [6M+H]+', 1135.262834),
        ('HCCA [6M+Na-H2O]+', 1139.234214),
        ('HCCA [6M+Na]+', 1157.244779),
        ('HCCA [6M+K-H2O]+', 1155.208151),
        ('HCCA [6M+K]+', 1173.218716),
        ('HCCA [6M+K+Na-H2O]+', 1178.197372),
        ('HCCA [7M+H-H2O]+', 1306.294862),
        ('HCCA [7M+H]+', 1324.305427),
        ('HCCA [7M+Na-H2O]+', 1328.276807),
        ('HCCA [7M+Na]+', 1346.287372),
        ('HCCA [7M+K-H2O]+', 1344.250744),
        ('HCCA [7M+K]+', 1362.261309),
        ('HCCA [7M+K+Na-H2O]+', 1367.239965),
    ],
    'DHB Clusters - MALDI Pos Mo':[
        ('DHB [M+H-H2O]+', 137.02332),
        ('DHB [M+H]+', 155.033885),
        ('DHB [M+Na-H2O]+', 159.005265),
        ('DHB [M+Na]+', 177.01583),
        ('DHB [M+K-H2O]+', 174.979202),
        ('DHB [M+K]+', 192.989767),
        ('DHB [2M+H-2H2O]+', 273.039364),
        ('DHB [2M+H-H2O]+', 291.049929),
        ('DHB [2M+H]+', 309.060494),
        ('DHB [2M+Na-2H2O]+', 295.021309),
        ('DHB [2M+Na-H2O]+', 313.031874),
        ('DHB [2M+Na]+', 331.042439),
        ('DHB [2M+K-H2O]+', 329.005811),
        ('DHB [2M+K]+', 347.016376),
        ('DHB [2M+K+Na-H2O]+', 351.995032),
        ('DHB [3M+H-3H2O]+', 409.055408),
        ('DHB [3M+H-H2O]+', 445.076538),
        ('DHB [3M+H]+', 463.087103),
        ('DHB [3M+Na-3H2O]+', 431.037353),
        ('DHB [3M+Na-H2O]+', 467.058483),
        ('DHB [3M+Na]+', 485.069048),
        ('DHB [3M+K-H2O]+', 483.03242),
        ('DHB [3M+K]+', 501.042985),
        ('DHB [3M+K+Na-H2O]+', 506.021641),
        ('DHB [4M+H-4H2O]+', 545.071452),
        ('DHB [4M+H-H2O]+', 599.103147),
        ('DHB [4M+H]+', 617.113712),
        ('DHB [4M+Na-4H2O]+', 567.053397),
        ('DHB [4M+Na-H2O]+', 621.085092),
        ('DHB [4M+Na]+', 639.095657),
        ('DHB [4M+K-H2O]+', 637.059029),
        ('DHB [4M+K]+', 655.069594),
        ('DHB [4M+K+Na-H2O]+', 660.04825),
        ('DHB [5M+H-5H2O]+', 681.087496),
        ('DHB [5M+H-H2O]+', 753.129756),
        ('DHB [5M+H]+', 771.140321),
        ('DHB [5M+Na-H2O]+', 775.111701),
        ('DHB [5M+Na]+', 793.122266),
        ('DHB [5M+K-H2O]+', 791.085638),
        ('DHB [5M+K]+', 809.096203),
        ('DHB [5M+K+Na-H2O]+', 814.074859),
        ('DHB [6M+H-6H2O]+', 817.103540),
        ('DHB [6M+H-H2O]+', 907.156365),
        ('DHB [6M+H]+', 925.16693),
        ('DHB [6M+Na-H2O]+', 929.13831),
        ('DHB [6M+Na]+', 947.148875),
        ('DHB [6M+K-H2O]+', 945.112247),
        ('DHB [6M+K]+', 963.122812),
        ('DHB [6M+K+Na-H2O]+', 968.101468),
        ('DHB [7M+H-7H2O]+', 953.119584),
        ('DHB [7M+H-H2O]+', 1061.182974),
        ('DHB [7M+H]+', 1079.193539),
        ('DHB [7M+Na-H2O]+', 1083.164919),
        ('DHB [7M+Na]+', 1101.175484),
        ('DHB [7M+K-H2O]+', 1099.138856),
        ('DHB [7M+K]+', 1117.149421),
        ('DHB [7M+K+Na-H2O]+', 1122.128077),
    ],
    'PEG - MALDI Pos':[
        ('C6H15O4 [M+H]+', 151.096485),
        ('C6H14O4 [M+Na]+', 173.078430),
        ('C8H19O5 [M+H]+', 195.122700),
        ('C8H18O5 [M+Na]+', 217.104645),
        ('C10H23O6 [M+H]+', 239.148915),
        ('C10H22O6 [M+Na]+', 261.130860),
        ('C12H27O7 [M+H]+', 283.175130),
        ('C12H26O7 [M+Na]+', 305.157074),
        ('C14H31O8 [M+H]+', 327.201344),
        ('C14H30O8 [M+Na]+', 349.183289),
        ('C16H35O9 [M+H]+', 371.227559),
        ('C16H34O9 [M+Na]+', 393.209504),
        ('C18H39O10 [M+H]+', 415.253774),
        ('C18H38O10 [M+Na]+', 437.235719),
        ('C20H43O11 [M+H]+', 459.279989),
        ('C20H42O11 [M+Na]+', 481.261933),
        ('C22H47O12 [M+H]+', 503.306203),
        ('C22H46O12 [M+Na]+', 525.288148),
        ('C24H51O13 [M+H]+', 547.332418),
        ('C24H50O13 [M+Na]+', 569.314363),
        ('C26H55O14 [M+H]+', 591.358633),
        ('C26H54O14 [M+Na]+', 613.340578),
        ('C28H59O15 [M+H]+', 635.384848),
        ('C28H58O15 [M+Na]+', 657.366792),
        ('C30H62O16 [M+Na]+', 701.393007),
        ('C32H66O17 [M+Na]+', 745.419222),
        ('C34H70O18 [M+Na]+', 789.445437),
        ('C36H74O19 [M+Na]+', 833.471651),
        ('C38H78O20 [M+Na]+', 877.497866),
        ('C40H82O21 [M+Na]+', 921.524081),
        ('C42H86O22 [M+Na]+', 965.550296),
        ('C44H90O23 [M+Na]+', 1009.576510),
        ('C46H94O24 [M+Na]+', 1053.602725),
        ('C48H98O25 [M+Na]+', 1097.628940),
        ('C50H102O26 [M+Na]+', 1141.655155),
        ('C52H106O27 [M+Na]+', 1185.681369),
        ('C54H110O28 [M+Na]+', 1229.707584),
        ('C56H114O29 [M+Na]+', 1273.733799),
        ('C58H118O30 [M+Na]+', 1317.760014),
        ('C60H122O31 [M+Na]+', 1361.786228),
        ('C62H126O32 [M+Na]+', 1405.812443),
        ('C64H130O33 [M+Na]+', 1449.838658),
        ('C66H134O34 [M+Na]+', 1493.864873),
        ('C68H138O35 [M+Na]+', 1537.891087),
        ('C70H142O36 [M+Na]+', 1581.917302),
        ('C72H146O37 [M+Na]+', 1625.943517),
        ('C74H150O38 [M+Na]+', 1669.969732),
        ('C76H154O39 [M+Na]+', 1713.995946),
        ('C78H158O40 [M+Na]+', 1758.022161),
        ('C80H162O41 [M+Na]+', 1802.048376),
        ('C82H166O42 [M+Na]+', 1846.074591),
        ('C84H170O43 [M+Na]+', 1890.100805),
        ('C86H174O44 [M+Na]+', 1934.127020),
        ('C88H178O45 [M+Na]+', 1978.153235),
        ('C90H182O46 [M+Na]+', 2022.179450),
        ('C92H186O47 [M+Na]+', 2066.205664),
        ('C94H190O48 [M+Na]+', 2110.231879),
        ('C96H194O49 [M+Na]+', 2154.258094),
        ('C98H198O50 [M+Na]+', 2198.284309),
        ('C100H2O2O51 [M+Na]+', 2242.310523),
        ('C104H210O53 [M+Na]+', 2330.362953),
        ('C108H218O55 [M+Na]+', 2418.415382),
        ('C112H226O57 [M+Na]+', 2506.467812),
        ('C116H234O59 [M+Na]+', 2594.520241),
        ('C120H242O61 [M+Na]+', 2682.572671),
        ('C124H250O63 [M+Na]+', 2770.652100),
        ('C128H258O65 [M+Na]+', 2858.677530),
        ('C132H266O67 [M+Na]+', 2946.729959),
        ('C136H274O69 [M+Na]+', 3034.782389),
        ('C140H282O71 [M+Na]+', 3122.834828),
    ],
    'Contaminants - Trypsin In-Gel - MALDI Pos Mo':[
        ('Keratin 10 [M+H]+', 1165.5853),
        ('Keratin 1/II [M+H]+', 1179.6010),
        ('Keratin 1/II [M+H]+', 1300.5302),
        ('Keratin 1/II [M+H]+', 1716.8517),
        ('Keratin 1/II [M+H]+', 1993.9767),
        ('Keratin 1 [M+H]+', 2383.9520),
        ('Keratin 10 [M+H]+', 2825.4056),
        ('Trypsin (108-115) [M+H]+', 842.5094),
        ('Trypsin (209-216) [M+H]+', 906.5044),
        ('Trypsin (1-8) [M+H]+', 952.3894),
        ('Trypsin (148-157) [M+H]+', 1006.4874),
        ('Trypsin (98-107) [M+H]+', 1045.5637),
        ('Trypsin (134-147) [M+H]+', 1469.7305),
        ('Trypsin (58-72) [M+H]+', 1713.8084),
        ('Trypsin (217-231) [M+H]+', 1736.8425),
        ('Trypsin (116-133) [M+H]+', 1768.7993),
        ('Trypsin (62-77) [M+H]+', 1774.8975),
        ('Trypsin (58-76) [M+H]+', 2083.0096),
        ('Trypsin (158-178) [M+H]+', 2158.0307),
        ('Trypsin (58-77) [M+H]+', 2211.1040),
        ('Trypsin (78-97) [M+H]+', 2283.1802),
        ('Trypsin (179-208) [M+H]+', 3013.3237),
    ],
}

compounds = {}


# finalize compounds
try:
    for group in compounds:
        for name in compounds[group]:
            compound = mspy.compound(compounds[group][name][0])
            compound.description = compounds[group][name][1]
            compounds[group][name] = compound
except:
    compounds = {}