# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load libs
import wx

# common
ID_quit = wx.ID_EXIT
ID_about = wx.ID_ABOUT
ID_preferences = wx.ID_PREFERENCES

HK_quit = '\tCtrl+Q'
HK_preferences = ''
if wx.Platform == '__WXMAC__':
    HK_preferences = '\tCtrl+,'

# tools
ID_toolsBatch = wx.NewId()
ID_toolsProcessing = wx.NewId()
ID_toolsCalibration = wx.NewId()
ID_toolsSequence = wx.NewId()
ID_toolsPeriodicTable = wx.NewId()
ID_toolsMasscalc = wx.NewId()
ID_toolsMassfilter = wx.NewId()
ID_toolsCompounds = wx.NewId()
ID_toolsDifferences = wx.NewId()
ID_toolsCompare = wx.NewId()
ID_toolsMascot = wx.NewId()
ID_toolsProfound = wx.NewId()
ID_toolsProspector = wx.NewId()
ID_toolsInfo = wx.NewId()
ID_toolsReport = wx.NewId()
ID_toolsExport = wx.NewId()

HK_toolsCalibration = '\tCtrl+R'
HK_toolsPeriodicTable = '\tShift+Ctrl+T'
HK_toolsMasscalc = '\tShift+Ctrl+M'
HK_toolsMassfilter = '\tShift+Ctrl+F'
HK_toolsCompounds = '\tShift+Ctrl+U'
HK_toolsDifferences = '\tShift+Ctrl+D'
HK_toolsCompare = '\tShift+Ctrl+C'

# file
ID_documentNew = wx.NewId()
ID_documentDuplicate = wx.NewId()
ID_documentOpen = wx.NewId()
ID_documentRecent = wx.NewId()
ID_documentClose = wx.NewId()
ID_documentCloseAll = wx.NewId()
ID_documentSave = wx.NewId()
ID_documentSaveAs = wx.NewId()
ID_documentExport = wx.NewId()
ID_documentInfo = wx.NewId()
ID_documentPrintSpectrum = wx.NewId()
ID_documentReport = wx.NewId()
ID_documentFlip = wx.NewId()
ID_documentOffset = wx.NewId()
ID_documentClearOffset = wx.NewId()
ID_documentClearOffsets = wx.NewId()
ID_documentColour = wx.NewId()
ID_documentCalibrateByAnnotations = wx.NewId()
ID_documentAnnotationEdit = wx.NewId()
ID_documentAnnotationPattern = wx.NewId()
ID_documentDeleteAnnotations = wx.NewId()
ID_documentDeleteAnnotation = wx.NewId()
ID_documentDeleteNotations = wx.NewId()

HK_documentFlip = '\tAlt+Ctrl+F'

ID_documentRecent0 = wx.NewId()
ID_documentRecent1 = wx.NewId()
ID_documentRecent2 = wx.NewId()
ID_documentRecent3 = wx.NewId()
ID_documentRecent4 = wx.NewId()
ID_documentRecent5 = wx.NewId()
ID_documentRecent6 = wx.NewId()
ID_documentRecent7 = wx.NewId()
ID_documentRecent8 = wx.NewId()
ID_documentRecent9 = wx.NewId()
ID_documentRecentClear = wx.NewId()

HK_documentNew = '\tCtrl+N'
HK_documentOpen = '\tCtrl+O'
HK_documentClose = '\tCtrl+W'
HK_documentCloseAll = '\tShift+Ctrl+W'
HK_documentSave = '\tCtrl+S'
HK_documentSaveAs = '\tShift+Ctrl+S'
HK_documentExport = '\tCtrl+E'
HK_documentInfo = '\tCtrl+I'
HK_documentPrintSpectrum = '\tCtrl+P'
HK_documentReport = '\tShift+Ctrl+R'

# spectrum
ID_spectrumLabelPeak = wx.NewId()
ID_spectrumLabelPoint = wx.NewId()
ID_spectrumDeleteLabel = wx.NewId()
ID_spectrumMeasure = wx.NewId()
ID_spectrumOffset = wx.NewId()

HK_spectrumLabelPeak = '\tShift+Ctrl+P'
HK_spectrumLabelPoint = '\tShift+Ctrl+I'
HK_spectrumDeleteLabel = '\tShift+Ctrl+X'
HK_spectrumMeasure = '\tShift+Ctrl+H'

# processing
ID_processingUndo = wx.NewId()
ID_processingPeakpicking = wx.NewId()
ID_processingDeisotoping = wx.NewId()
ID_processingBaseline = wx.NewId()
ID_processingSmoothing = wx.NewId()
ID_processingCrop = wx.NewId()
ID_processingMath = wx.NewId()
ID_processingSwap = wx.NewId()

HK_processingUndo = '\tCtrl+Z'
HK_processingPeakpicking = '\tCtrl+F'
HK_processingDeisotoping = '\tCtrl+D'
HK_processingSmoothing = '\tCtrl+G'
HK_processingBaseline = '\tCtrl+B'

# calibration
ID_calibrationReferences = wx.NewId()
ID_calibrationErrors = wx.NewId()

# sequence
ID_sequenceNew = wx.NewId()
ID_sequenceImport = wx.NewId()
ID_sequenceEditor = wx.NewId()
ID_sequenceModifications = wx.NewId()
ID_sequenceDigest = wx.NewId()
ID_sequenceFragment = wx.NewId()
ID_sequenceSearch = wx.NewId()
ID_sequenceCalibrateByMatches = wx.NewId()
ID_sequenceMatchEdit = wx.NewId()
ID_sequenceMatchPattern = wx.NewId()
ID_sequenceDeleteMatch = wx.NewId()
ID_sequenceDeleteMatches = wx.NewId()
ID_sequenceDelete = wx.NewId()
ID_sequenceSort = wx.NewId()

HK_sequenceNew = '\tShift+Ctrl+N'

# view
ID_viewGrid = wx.NewId()
ID_viewLegend = wx.NewId()
ID_viewPosBar = wx.NewId()
ID_viewIntBar = wx.NewId()
ID_viewGel = wx.NewId()
ID_viewGelLegend = wx.NewId()
ID_viewTracker = wx.NewId()
ID_viewDataPoints = wx.NewId()
ID_viewNotationMarks = wx.NewId()
ID_viewLabels = wx.NewId()
ID_viewTicks = wx.NewId()
ID_viewLabelCharge = wx.NewId()
ID_viewLabelAngle = wx.NewId()
ID_viewAllLabels = wx.NewId()
ID_viewLabelBgr = wx.NewId()
ID_viewOverlapLabels = wx.NewId()
ID_viewAutoscale = wx.NewId()
ID_viewNormalize = wx.NewId()
ID_viewRange = wx.NewId()
ID_viewCanvasProperties = wx.NewId()

HK_viewPosBar = '\tAlt+Ctrl+P'
HK_viewIntBar = '\tAlt+Ctrl+I'
HK_viewGel = '\tAlt+Ctrl+G'
HK_viewLabels = '\tAlt+Ctrl+L'
HK_viewTicks = '\tAlt+Ctrl+T'
HK_viewLabelAngle = '\tAlt+Ctrl+H'
HK_viewAllLabels = '\tAlt+Ctrl+Shift+L'
HK_viewOverlapLabels = '\tAlt+Ctrl+O'
HK_viewAutoscale = '\tAlt+Ctrl+A'
HK_viewNormalize = '\tAlt+Ctrl+N'
HK_viewRange = '\tAlt+Ctrl+R'
HK_viewCanvasProperties = '\tCtrl+J'

# match
ID_matchErrors = wx.NewId()
ID_matchSummary = wx.NewId()

# masscalc
ID_masscalcSummary = wx.NewId()
ID_masscalcIonSeries = wx.NewId()
ID_masscalcPattern = wx.NewId()
ID_masscalcCollapse = wx.NewId()

# periodic table
ID_ptableTable = wx.NewId()
ID_ptablePattern = wx.NewId()

# coumpounds search
ID_compoundsCompounds = wx.NewId()
ID_compoundsFormula = wx.NewId()

# mascot
ID_mascotPMF = wx.NewId()
ID_mascotMIS = wx.NewId()
ID_mascotSQ = wx.NewId()
ID_mascotQuery = wx.NewId()

# profound
ID_profoundPMF = wx.NewId()
ID_profoundQuery = wx.NewId()

# prospector
ID_prospectorMSFit = wx.NewId()
ID_prospectorMSTag = wx.NewId()
ID_prospectorQuery = wx.NewId()

# info
ID_infoSummary = wx.NewId()
ID_infoSpectrum = wx.NewId()
ID_infoNotes = wx.NewId()

# export
ID_exportImage = wx.NewId()
ID_exportPeaklist = wx.NewId()
ID_exportSpectrum = wx.NewId()

# library
ID_libraryModifications = wx.NewId()
ID_libraryEnzymes = wx.NewId()
ID_libraryCompounds = wx.NewId()
ID_libraryReferences = wx.NewId()
ID_libraryPresets = wx.NewId()
ID_libraryMascot = wx.NewId()

# links
ID_linksBiomedMSTools = wx.NewId()
ID_linksBLAST = wx.NewId()
ID_linksClustalW = wx.NewId()
ID_linksDeltaMass = wx.NewId()
ID_linksEMBLEBI = wx.NewId()
ID_linksExpasy = wx.NewId()
ID_linksFASTA = wx.NewId()
ID_linksMatrixScience = wx.NewId()
ID_linksMUSCLE = wx.NewId()
ID_linksNCBI = wx.NewId()
ID_linksPDB = wx.NewId()
ID_linksPIR = wx.NewId()
ID_linksProfound = wx.NewId()
ID_linksProspector = wx.NewId()
ID_linksUniMod = wx.NewId()
ID_linksUniProt = wx.NewId()

# help
ID_helpAbout = wx.ID_ABOUT
ID_helpHomepage = wx.NewId()
ID_helpForum = wx.NewId()
ID_helpUpdate = wx.NewId()
ID_helpCite = wx.NewId()
ID_helpDonate = wx.NewId()

# dialogues
ID_dlgDontSave = wx.NewId()
ID_dlgSave = wx.NewId()
ID_dlgCancel = wx.NewId()
ID_dlgDiscard = wx.NewId()
ID_dlgReview = wx.NewId()
ID_dlgReplace = wx.NewId()
ID_dlgReplaceAll = wx.NewId()
ID_dlgSkip = wx.NewId()

# common
ID_listViewAll = wx.NewId()
ID_listViewMatched = wx.NewId()
ID_listViewUnmatched = wx.NewId()
ID_listCopy = wx.NewId()
ID_listCopySequence = wx.NewId()
