# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load libs
import wx

# load modules
import config
import mwx


# CANVAS RANGE
# ------------

class dlgViewRange(wx.Dialog):
    """Set canvas view range."""
    
    def __init__(self, parent, data):
        
        # initialize document frame
        wx.Dialog.__init__(self, parent, -1, 'Mass Range', style=wx.DEFAULT_DIALOG_STYLE)
        
        self.parent = parent
        self.data = data
        
        # make GUI
        sizer = self.makeGUI()
        
        # fit layout
        self.Layout()
        sizer.Fit(self)
        self.SetSizer(sizer)
        self.Centre()
    # ----
    
    
    def makeGUI(self):
        """Make GUI elements."""
        
        xAxisBox = wx.StaticBoxSizer(wx.StaticBox(self, -1, ""), wx.HORIZONTAL)
        
        # make elements
        minX_label = wx.StaticText(self, -1, "Min:", style=wx.ALIGN_RIGHT)
        self.minX_value = wx.TextCtrl(self, -1, str(self.data[0]), size=(100,-1), style=wx.TE_PROCESS_ENTER, validator=mwx.validator('float'))
        self.minX_value.Bind(wx.EVT_TEXT_ENTER, self.onOK)
        
        maxX_label = wx.StaticText(self, -1, "Max:", style=wx.ALIGN_RIGHT)
        self.maxX_value = wx.TextCtrl(self, -1, str(self.data[1]), size=(100,-1), style=wx.TE_PROCESS_ENTER, validator=mwx.validator('float'))
        self.maxX_value.Bind(wx.EVT_TEXT_ENTER, self.onOK)
        
        buttons = self.makeButtons()
        
        # pack elements
        xAxisBox.Add(minX_label, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        xAxisBox.Add(self.minX_value, 1, wx.TOP|wx.RIGHT|wx.BOTTOM|wx.ALIGN_CENTER_VERTICAL, 5)
        xAxisBox.Add(maxX_label, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        xAxisBox.Add(self.maxX_value, 1, wx.TOP|wx.RIGHT|wx.BOTTOM|wx.ALIGN_CENTER_VERTICAL, 5)
        
        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainSizer.Add(xAxisBox, 0, wx.EXPAND|wx.CENTER|wx.ALL, mwx.PANEL_SPACE_MAIN)
        mainSizer.Add(buttons, 0, wx.CENTER|wx.LEFT|wx.RIGHT|wx.BOTTOM, mwx.PANEL_SPACE_MAIN)
        
        return mainSizer
    # ----
    
    
    def makeButtons(self):
        """Make buttons."""
        
        # make items
        cancel_butt = wx.Button(self, wx.ID_CANCEL, "Cancel")
        ok_butt = wx.Button(self, wx.ID_OK, "OK")
        ok_butt.Bind(wx.EVT_BUTTON, self.onOK)
        
        # pack items
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer.Add(cancel_butt, 0, wx.RIGHT, 15)
        sizer.Add(ok_butt, 0)
        
        return sizer
    # ----
    
    
    def onOK(self, evt=None):
        """Get values."""
        
        # get data
        try:
            minX = float(self.minX_value.GetValue())
            maxX = float(self.maxX_value.GetValue())
            if minX < maxX:
                self.data = (minX, maxX)
                self.EndModal(wx.ID_OK)
            else:
                wx.Bell()
        except:
            wx.Bell()
    # ----
    

