# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load libs
import wx

# load modules
import config
import mwx
import mspy


# BATCH PROCESSING
# ----------------

class dlgBatchProcessing(wx.Dialog):
    """Batch processing dialog."""
    
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, "Batch Processing", style=wx.DEFAULT_DIALOG_STYLE)
        
        # make GUI
        sizer = self.makeGUI()
        
        # fit layout
        self.Layout()
        sizer.Fit(self)
        self.SetSizer(sizer)
        self.SetMinSize(self.GetSize())
        self.Centre()
    # ----
    
    
    def makeGUI(self):
        """Make GUI elements."""
        
        # make GUI elements
        self.makeDocumentsList()
        options = self.makeOptions()
        buttons = self.makeButtons()
        
        # pack elements
        sizer = wx.BoxSizer(wx.VERTICAL)
        sizer.Add(self.documentsList, 1, wx.EXPAND|wx.TOP|wx.LEFT|wx.RIGHT, mwx.LISTCTRL_SPACE)
        sizer.Add(options, 0, wx.EXPAND|wx.TOP|wx.LEFT|wx.RIGHT, mwx.PANEL_SPACE_MAIN)
        sizer.Add(buttons, 0, wx.CENTER|wx.ALL, mwx.PANEL_SPACE_MAIN)
        
        return sizer
    # ----
    
    
    def makeDocumentsList(self):
        """Make list for documents."""
        
        # init list
        self.documentsList = mwx.sortListCtrl(self, -1, size=(421, 150), style=mwx.LISTCTRL_STYLE_MULTI)
        self.documentsList.SetFont(wx.SMALL_FONT)
        self.documentsList.setAltColour(mwx.LISTCTRL_ALTCOLOUR)
        self.documentsList.SetToolTip(wx.ToolTip("Double-click on the document's title to remove it from processing queue."))
        
        # set events
        self.documentsList.Bind(wx.EVT_LIST_ITEM_ACTIVATED, self.onDocumentActivated)
        
        # make columns
        self.documentsList.InsertColumn(0, "document title", wx.LIST_FORMAT_LEFT)
        self.documentsList.InsertColumn(1, "status", wx.LIST_FORMAT_CENTER)
        
        # set column widths
        for col, width in enumerate((300,100)):
            self.documentsList.SetColumnWidth(col, width)
    # ----
    
    
    def makeOptions(self):
        """Make processing options."""
        
        mainSizer = wx.StaticBoxSizer(wx.StaticBox(self, -1, ""), wx.VERTICAL)
        
        choices = ['None']
        for name in sorted(config.libs.presets['operator'].keys()):
            choices.append(name)
        
        operator_label = wx.StaticText(self, -1, "Operator's preset:")
        self.operatorPreset_combo = wx.ComboBox(self, -1, choices=choices, size=(250, mwx.COMBO_HEIGHT), style=wx.CB_READONLY)
        
        choices = ['None']
        for name in sorted(config.libs.presets['processing'].keys()):
            choices.append(name)
        
        processing_label = wx.StaticText(self, -1, "Processing preset:")
        self.processingPreset_combo = wx.ComboBox(self, -1, choices=choices, size=(250, mwx.COMBO_HEIGHT), style=wx.CB_READONLY)
        
        self.processingCrop_check = wx.CheckBox(self, -1, "Apply crop")
        self.processingBaseline_check = wx.CheckBox(self, -1, "Apply baseline correction")
        self.processingSmoothing_check = wx.CheckBox(self, -1, "Apply smoothing")
        self.processingPeakpicking_check = wx.CheckBox(self, -1, "Apply peak picking")
        self.processingDeisotoping_check = wx.CheckBox(self, -1, "Apply peak deisotoping")
        
        # pack elements
        grid = wx.GridBagSizer(mwx.GRIDBAG_VSPACE, mwx.GRIDBAG_HSPACE)
        
        grid.Add(operator_label, (0,0), flag=wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.operatorPreset_combo, (0,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(processing_label, (1,0), flag=wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingPreset_combo, (1,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingCrop_check, (2,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingBaseline_check, (3,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingSmoothing_check, (4,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingPeakpicking_check, (5,1), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.processingDeisotoping_check, (6,1), flag=wx.ALIGN_CENTER_VERTICAL)
        
        mainSizer.Add(grid, 0, wx.ALIGN_CENTER|wx.ALL, 10)
        
        return mainSizer
    # ----
    
    
    def makeButtons(self):
        """Make buttons."""
        
        # make items
        close_butt = wx.Button(self, wx.ID_CANCEL, "Close")
        start_butt = wx.Button(self, wx.ID_OK, "Start Processing")
        
        # pack items
        sizer = wx.BoxSizer(wx.HORIZONTAL)
        sizer.Add(close_butt, 0, wx.RIGHT, 15)
        sizer.Add(start_butt, 0)
        
        return sizer
    # ----
    
    
    def onDocumentActivated(self, evt):
        """Remove/add selected document from queue."""
        pass
    # ----
    
    
    
    
    