# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------


# load modules
import config


# DEFAULT MSPY BLOCKS
# -------------------

elements = """<?xml version="1.0" encoding="utf-8" ?>
<mspyElements version="1.0">
  <element symbol="Ac" name="Actinium" atomicNumber="89">
    <mass monoisotopic="227.027747" average="227.027747" />
    <isotopes>
      <isotope massNumber="227" mass="227.027747" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ag" name="Silver" atomicNumber="47">
    <mass monoisotopic="106.905093" average="107.868150697" />
    <isotopes>
      <isotope massNumber="107" mass="106.905093" abundance="0.51839" />
      <isotope massNumber="109" mass="108.904756" abundance="0.48161" />
    </isotopes>
  </element>
  <element symbol="Al" name="Aluminium" atomicNumber="13">
    <mass monoisotopic="26.98153844" average="26.98153844" />
    <isotopes>
      <isotope massNumber="27" mass="26.98153844" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Am" name="Americium" atomicNumber="95">
    <mass monoisotopic="243.0613727" average="243.0613727" />
    <isotopes>
      <isotope massNumber="241" mass="241.0568229" abundance="0.0" />
      <isotope massNumber="243" mass="243.0613727" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ar" name="Argon" atomicNumber="18">
    <mass monoisotopic="39.962383123" average="39.9476767176" />
    <isotopes>
      <isotope massNumber="36" mass="35.96754628" abundance="0.003365" />
      <isotope massNumber="38" mass="37.9627322" abundance="0.000632" />
      <isotope massNumber="40" mass="39.962383123" abundance="0.996003" />
    </isotopes>
  </element>
  <element symbol="As" name="Arsenic" atomicNumber="33">
    <mass monoisotopic="74.9215964" average="74.9215964" />
    <isotopes>
      <isotope massNumber="75" mass="74.9215964" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="At" name="Astatine" atomicNumber="85">
    <mass monoisotopic="210.987481" average="210.987481" />
    <isotopes>
      <isotope massNumber="210" mass="209.987131" abundance="0.0" />
      <isotope massNumber="211" mass="210.987481" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Au" name="Gold" atomicNumber="79">
    <mass monoisotopic="196.966552" average="196.966552" />
    <isotopes>
      <isotope massNumber="197" mass="196.966552" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="B" name="Boron" atomicNumber="5">
    <mass monoisotopic="11.0093055" average="10.8110281685" />
    <isotopes>
      <isotope massNumber="10" mass="10.012937" abundance="0.199" />
      <isotope massNumber="11" mass="11.0093055" abundance="0.801" />
    </isotopes>
  </element>
  <element symbol="Ba" name="Barium" atomicNumber="56">
    <mass monoisotopic="137.905241" average="137.326885691" />
    <isotopes>
      <isotope massNumber="130" mass="129.90631" abundance="0.00106" />
      <isotope massNumber="132" mass="131.905056" abundance="0.00101" />
      <isotope massNumber="134" mass="133.904503" abundance="0.02417" />
      <isotope massNumber="135" mass="134.905683" abundance="0.06592" />
      <isotope massNumber="136" mass="135.90457" abundance="0.07854" />
      <isotope massNumber="137" mass="136.905821" abundance="0.11232" />
      <isotope massNumber="138" mass="137.905241" abundance="0.71698" />
    </isotopes>
  </element>
  <element symbol="Be" name="Beryllium" atomicNumber="4">
    <mass monoisotopic="9.0121821" average="9.0121821" />
    <isotopes>
      <isotope massNumber="9" mass="9.0121821" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Bh" name="Bohrium" atomicNumber="107">
    <mass monoisotopic="264.12473" average="264.12473" />
    <isotopes>
      <isotope massNumber="264" mass="264.12473" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Bi" name="Bismuth" atomicNumber="83">
    <mass monoisotopic="208.980383" average="208.980383" />
    <isotopes>
      <isotope massNumber="209" mass="208.980383" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Bk" name="Berkelium" atomicNumber="97">
    <mass monoisotopic="247.070299" average="247.070299" />
    <isotopes>
      <isotope massNumber="247" mass="247.070299" abundance="1.0" />
      <isotope massNumber="249" mass="249.07498" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Br" name="Bromine" atomicNumber="35">
    <mass monoisotopic="78.9183376" average="79.9035284215" />
    <isotopes>
      <isotope massNumber="79" mass="78.9183376" abundance="0.5069" />
      <isotope massNumber="81" mass="80.916291" abundance="0.4931" />
    </isotopes>
  </element>
  <element symbol="C" name="Carbon" atomicNumber="6">
    <mass monoisotopic="12.0" average="12.0107358968" />
    <isotopes>
      <isotope massNumber="12" mass="12.0" abundance="0.9893" />
      <isotope massNumber="13" mass="13.0033548378" abundance="0.0107" />
      <isotope massNumber="14" mass="14.003241988" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Ca" name="Calcium" atomicNumber="20">
    <mass monoisotopic="39.9625912" average="40.0780228528" />
    <isotopes>
      <isotope massNumber="40" mass="39.9625912" abundance="0.96941" />
      <isotope massNumber="42" mass="41.9586183" abundance="0.00647" />
      <isotope massNumber="43" mass="42.9587668" abundance="0.00135" />
      <isotope massNumber="44" mass="43.9554811" abundance="0.02086" />
      <isotope massNumber="46" mass="45.9536928" abundance="4e-05" />
      <isotope massNumber="48" mass="47.952534" abundance="0.00187" />
    </isotopes>
  </element>
  <element symbol="Cd" name="Cadmium" atomicNumber="48">
    <mass monoisotopic="113.9033581" average="112.411552733" />
    <isotopes>
      <isotope massNumber="106" mass="105.906458" abundance="0.0125" />
      <isotope massNumber="108" mass="107.904183" abundance="0.0089" />
      <isotope massNumber="110" mass="109.903006" abundance="0.1249" />
      <isotope massNumber="111" mass="110.904182" abundance="0.128" />
      <isotope massNumber="112" mass="111.9027572" abundance="0.2413" />
      <isotope massNumber="113" mass="112.9044009" abundance="0.1222" />
      <isotope massNumber="114" mass="113.9033581" abundance="0.2873" />
      <isotope massNumber="116" mass="115.904755" abundance="0.0749" />
    </isotopes>
  </element>
  <element symbol="Ce" name="Cerium" atomicNumber="58">
    <mass monoisotopic="139.905434" average="140.11572154" />
    <isotopes>
      <isotope massNumber="136" mass="135.90714" abundance="0.00185" />
      <isotope massNumber="138" mass="137.905986" abundance="0.00251" />
      <isotope massNumber="140" mass="139.905434" abundance="0.8845" />
      <isotope massNumber="142" mass="141.90924" abundance="0.11114" />
    </isotopes>
  </element>
  <element symbol="Cf" name="Californium" atomicNumber="98">
    <mass monoisotopic="251.07958" average="251.07958" />
    <isotopes>
      <isotope massNumber="249" mass="249.074847" abundance="0.0" />
      <isotope massNumber="250" mass="250.0764" abundance="0.0" />
      <isotope massNumber="251" mass="251.07958" abundance="1.0" />
      <isotope massNumber="252" mass="252.08162" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Cl" name="Chlorine" atomicNumber="17">
    <mass monoisotopic="34.96885271" average="35.4525381934" />
    <isotopes>
      <isotope massNumber="35" mass="34.96885271" abundance="0.7578" />
      <isotope massNumber="37" mass="36.9659026" abundance="0.2422" />
    </isotopes>
  </element>
  <element symbol="Cm" name="Curium" atomicNumber="96">
    <mass monoisotopic="247.070347" average="247.070347" />
    <isotopes>
      <isotope massNumber="243" mass="243.0613822" abundance="0.0" />
      <isotope massNumber="244" mass="244.0627463" abundance="0.0" />
      <isotope massNumber="245" mass="245.0654856" abundance="0.0" />
      <isotope massNumber="246" mass="246.0672176" abundance="0.0" />
      <isotope massNumber="247" mass="247.070347" abundance="1.0" />
      <isotope massNumber="248" mass="248.072342" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Co" name="Cobalt" atomicNumber="27">
    <mass monoisotopic="58.9332002" average="58.9332002" />
    <isotopes>
      <isotope massNumber="59" mass="58.9332002" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Cr" name="Chromium" atomicNumber="24">
    <mass monoisotopic="51.9405119" average="51.9961375164" />
    <isotopes>
      <isotope massNumber="50" mass="49.9460496" abundance="0.04345" />
      <isotope massNumber="52" mass="51.9405119" abundance="0.83789" />
      <isotope massNumber="53" mass="52.9406538" abundance="0.09501" />
      <isotope massNumber="54" mass="53.9388849" abundance="0.02365" />
    </isotopes>
  </element>
  <element symbol="Cs" name="Caesium" atomicNumber="55">
    <mass monoisotopic="132.905447" average="132.905447" />
    <isotopes>
      <isotope massNumber="133" mass="132.905447" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Cu" name="Copper" atomicNumber="29">
    <mass monoisotopic="62.9296011" average="63.5456438786" />
    <isotopes>
      <isotope massNumber="63" mass="62.9296011" abundance="0.6917" />
      <isotope massNumber="65" mass="64.9277937" abundance="0.3083" />
    </isotopes>
  </element>
  <element symbol="Db" name="Dubnium" atomicNumber="105">
    <mass monoisotopic="262.11415" average="262.11415" />
    <isotopes>
      <isotope massNumber="262" mass="262.11415" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Dy" name="Dysprosium" atomicNumber="66">
    <mass monoisotopic="163.929171" average="162.497030039" />
    <isotopes>
      <isotope massNumber="156" mass="155.924278" abundance="0.0006" />
      <isotope massNumber="158" mass="157.924405" abundance="0.001" />
      <isotope massNumber="160" mass="159.925194" abundance="0.0234" />
      <isotope massNumber="161" mass="160.92693" abundance="0.1891" />
      <isotope massNumber="162" mass="161.926795" abundance="0.2551" />
      <isotope massNumber="163" mass="162.928728" abundance="0.249" />
      <isotope massNumber="164" mass="163.929171" abundance="0.2818" />
    </isotopes>
  </element>
  <element symbol="Er" name="Erbium" atomicNumber="68">
    <mass monoisotopic="165.93029" average="167.256301073" />
    <isotopes>
      <isotope massNumber="162" mass="161.928775" abundance="0.0014" />
      <isotope massNumber="164" mass="163.929197" abundance="0.0161" />
      <isotope massNumber="166" mass="165.93029" abundance="0.3361" />
      <isotope massNumber="167" mass="166.932045" abundance="0.2293" />
      <isotope massNumber="168" mass="167.932368" abundance="0.2678" />
      <isotope massNumber="170" mass="169.93546" abundance="0.1493" />
    </isotopes>
  </element>
  <element symbol="Es" name="Einsteinium" atomicNumber="99">
    <mass monoisotopic="252.08297" average="252.08297" />
    <isotopes>
      <isotope massNumber="252" mass="252.08297" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Eu" name="Europium" atomicNumber="63">
    <mass monoisotopic="152.921226" average="151.964366222" />
    <isotopes>
      <isotope massNumber="151" mass="150.919846" abundance="0.4781" />
      <isotope massNumber="153" mass="152.921226" abundance="0.5219" />
    </isotopes>
  </element>
  <element symbol="F" name="Fluorine" atomicNumber="9">
    <mass monoisotopic="18.9984032" average="18.9984032" />
    <isotopes>
      <isotope massNumber="19" mass="18.9984032" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Fe" name="Iron" atomicNumber="26">
    <mass monoisotopic="55.9349421" average="55.845150209" />
    <isotopes>
      <isotope massNumber="54" mass="53.9396148" abundance="0.05845" />
      <isotope massNumber="56" mass="55.9349421" abundance="0.91754" />
      <isotope massNumber="57" mass="56.9353987" abundance="0.02119" />
      <isotope massNumber="58" mass="57.9332805" abundance="0.00282" />
    </isotopes>
  </element>
  <element symbol="Fm" name="Fermium" atomicNumber="100">
    <mass monoisotopic="257.095099" average="257.095099" />
    <isotopes>
      <isotope massNumber="257" mass="257.095099" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Fr" name="Francium" atomicNumber="87">
    <mass monoisotopic="223.0197307" average="223.0197307" />
    <isotopes>
      <isotope massNumber="223" mass="223.0197307" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ga" name="Gallium" atomicNumber="31">
    <mass monoisotopic="68.925581" average="69.7230715461" />
    <isotopes>
      <isotope massNumber="69" mass="68.925581" abundance="0.60108" />
      <isotope massNumber="71" mass="70.924705" abundance="0.39892" />
    </isotopes>
  </element>
  <element symbol="Gd" name="Gadolinium" atomicNumber="64">
    <mass monoisotopic="157.924101" average="157.252119251" />
    <isotopes>
      <isotope massNumber="152" mass="151.919788" abundance="0.002" />
      <isotope massNumber="154" mass="153.920862" abundance="0.0218" />
      <isotope massNumber="155" mass="154.922619" abundance="0.148" />
      <isotope massNumber="156" mass="155.92212" abundance="0.2047" />
      <isotope massNumber="157" mass="156.923957" abundance="0.1565" />
      <isotope massNumber="158" mass="157.924101" abundance="0.2484" />
      <isotope massNumber="160" mass="159.927051" abundance="0.2186" />
    </isotopes>
  </element>
  <element symbol="Ge" name="Germanium" atomicNumber="32">
    <mass monoisotopic="73.9211782" average="72.6127591769" />
    <isotopes>
      <isotope massNumber="70" mass="69.9242504" abundance="0.2084" />
      <isotope massNumber="72" mass="71.9220762" abundance="0.2754" />
      <isotope massNumber="73" mass="72.9234594" abundance="0.0773" />
      <isotope massNumber="74" mass="73.9211782" abundance="0.3628" />
      <isotope massNumber="76" mass="75.9214027" abundance="0.0761" />
    </isotopes>
  </element>
  <element symbol="H" name="Hydrogen" atomicNumber="1">
    <mass monoisotopic="1.0078250321" average="1.00794075393" />
    <isotopes>
      <isotope massNumber="1" mass="1.0078250321" abundance="0.999885" />
      <isotope massNumber="2" mass="2.014101778" abundance="0.000115" />
      <isotope massNumber="3" mass="3.0160492675" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="He" name="Helium" atomicNumber="2">
    <mass monoisotopic="4.0026032497" average="4.00260189809" />
    <isotopes>
      <isotope massNumber="3" mass="3.0160293097" abundance="1.37e-06" />
      <isotope massNumber="4" mass="4.0026032497" abundance="0.99999863" />
    </isotopes>
  </element>
  <element symbol="Hf" name="Hafnium" atomicNumber="72">
    <mass monoisotopic="179.9465488" average="178.484970787" />
    <isotopes>
      <isotope massNumber="174" mass="173.94004" abundance="0.0016" />
      <isotope massNumber="176" mass="175.9414018" abundance="0.0526" />
      <isotope massNumber="177" mass="176.94322" abundance="0.186" />
      <isotope massNumber="178" mass="177.9436977" abundance="0.2728" />
      <isotope massNumber="179" mass="178.9458151" abundance="0.1362" />
      <isotope massNumber="180" mass="179.9465488" abundance="0.3508" />
    </isotopes>
  </element>
  <element symbol="Hg" name="Mercury" atomicNumber="80">
    <mass monoisotopic="201.970626" average="200.599149363" />
    <isotopes>
      <isotope massNumber="196" mass="195.965815" abundance="0.0015" />
      <isotope massNumber="198" mass="197.966752" abundance="0.0997" />
      <isotope massNumber="199" mass="198.968262" abundance="0.1687" />
      <isotope massNumber="200" mass="199.968309" abundance="0.231" />
      <isotope massNumber="201" mass="200.970285" abundance="0.1318" />
      <isotope massNumber="202" mass="201.970626" abundance="0.2986" />
      <isotope massNumber="204" mass="203.973476" abundance="0.0687" />
    </isotopes>
  </element>
  <element symbol="Ho" name="Holmium" atomicNumber="67">
    <mass monoisotopic="164.930319" average="164.930319" />
    <isotopes>
      <isotope massNumber="165" mass="164.930319" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="I" name="Iodine" atomicNumber="53">
    <mass monoisotopic="126.904468" average="126.904468" />
    <isotopes>
      <isotope massNumber="127" mass="126.904468" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="In" name="Indium" atomicNumber="49">
    <mass monoisotopic="114.903878" average="114.818085851" />
    <isotopes>
      <isotope massNumber="113" mass="112.904061" abundance="0.0429" />
      <isotope massNumber="115" mass="114.903878" abundance="0.9571" />
    </isotopes>
  </element>
  <element symbol="Ir" name="Iridium" atomicNumber="77">
    <mass monoisotopic="192.962924" average="192.216053791" />
    <isotopes>
      <isotope massNumber="191" mass="190.960591" abundance="0.373" />
      <isotope massNumber="193" mass="192.962924" abundance="0.627" />
    </isotopes>
  </element>
  <element symbol="K" name="Potassium" atomicNumber="19">
    <mass monoisotopic="38.9637069" average="39.0983013438" />
    <isotopes>
      <isotope massNumber="39" mass="38.9637069" abundance="0.932581" />
      <isotope massNumber="40" mass="39.96399867" abundance="0.000117" />
      <isotope massNumber="41" mass="40.96182597" abundance="0.067302" />
    </isotopes>
  </element>
  <element symbol="Kr" name="Krypton" atomicNumber="36">
    <mass monoisotopic="83.911507" average="83.7993250844" />
    <isotopes>
      <isotope massNumber="78" mass="77.920386" abundance="0.0035" />
      <isotope massNumber="80" mass="79.916378" abundance="0.0228" />
      <isotope massNumber="82" mass="81.9134846" abundance="0.1158" />
      <isotope massNumber="83" mass="82.914136" abundance="0.1149" />
      <isotope massNumber="84" mass="83.911507" abundance="0.57" />
      <isotope massNumber="86" mass="85.9106103" abundance="0.173" />
    </isotopes>
  </element>
  <element symbol="La" name="Lanthanum" atomicNumber="57">
    <mass monoisotopic="138.906348" average="138.905448683" />
    <isotopes>
      <isotope massNumber="138" mass="137.907107" abundance="0.0009" />
      <isotope massNumber="139" mass="138.906348" abundance="0.9991" />
    </isotopes>
  </element>
  <element symbol="Li" name="Lithium" atomicNumber="3">
    <mass monoisotopic="7.016004" average="6.94003707897" />
    <isotopes>
      <isotope massNumber="6" mass="6.0151223" abundance="0.0759" />
      <isotope massNumber="7" mass="7.016004" abundance="0.9241" />
    </isotopes>
  </element>
  <element symbol="Lr" name="Lawrencium" atomicNumber="103">
    <mass monoisotopic="262.10969" average="262.10969" />
    <isotopes>
      <isotope massNumber="262" mass="262.10969" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Lu" name="Lutetium" atomicNumber="71">
    <mass monoisotopic="174.9407679" average="174.966717486" />
    <isotopes>
      <isotope massNumber="175" mass="174.9407679" abundance="0.9741" />
      <isotope massNumber="176" mass="175.9426824" abundance="0.0259" />
    </isotopes>
  </element>
  <element symbol="Md" name="Mendelevium" atomicNumber="101">
    <mass monoisotopic="258.098425" average="258.098425" />
    <isotopes>
      <isotope massNumber="256" mass="256.09405" abundance="0.0" />
      <isotope massNumber="258" mass="258.098425" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Mg" name="Magnesium" atomicNumber="12">
    <mass monoisotopic="23.9850419" average="24.3050517925" />
    <isotopes>
      <isotope massNumber="24" mass="23.9850419" abundance="0.7899" />
      <isotope massNumber="25" mass="24.98583702" abundance="0.1" />
      <isotope massNumber="26" mass="25.98259304" abundance="0.1101" />
    </isotopes>
  </element>
  <element symbol="Mn" name="Manganese" atomicNumber="25">
    <mass monoisotopic="54.9380496" average="54.9380496" />
    <isotopes>
      <isotope massNumber="55" mass="54.9380496" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Mo" name="Molybdenum" atomicNumber="42">
    <mass monoisotopic="97.9054078" average="95.9312915571" />
    <isotopes>
      <isotope massNumber="100" mass="99.907477" abundance="0.0963" />
      <isotope massNumber="92" mass="91.90681" abundance="0.1484" />
      <isotope massNumber="94" mass="93.9050876" abundance="0.0925" />
      <isotope massNumber="95" mass="94.9058415" abundance="0.1592" />
      <isotope massNumber="96" mass="95.9046789" abundance="0.1668" />
      <isotope massNumber="97" mass="96.906021" abundance="0.0955" />
      <isotope massNumber="98" mass="97.9054078" abundance="0.2413" />
    </isotopes>
  </element>
  <element symbol="Mt" name="Meitnerium" atomicNumber="109">
    <mass monoisotopic="268.13882" average="268.13882" />
    <isotopes>
      <isotope massNumber="268" mass="268.13882" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="N" name="Nitrogen" atomicNumber="7">
    <mass monoisotopic="14.0030740052" average="14.0067430936" />
    <isotopes>
      <isotope massNumber="14" mass="14.0030740052" abundance="0.99632" />
      <isotope massNumber="15" mass="15.0001088984" abundance="0.00368" />
    </isotopes>
  </element>
  <element symbol="Na" name="Sodium" atomicNumber="11">
    <mass monoisotopic="22.98976967" average="22.98976967" />
    <isotopes>
      <isotope massNumber="23" mass="22.98976967" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Nb" name="Niobium" atomicNumber="41">
    <mass monoisotopic="92.9063775" average="92.9063775" />
    <isotopes>
      <isotope massNumber="93" mass="92.9063775" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Nd" name="Neodymium" atomicNumber="60">
    <mass monoisotopic="141.907719" average="144.236126978" />
    <isotopes>
      <isotope massNumber="142" mass="141.907719" abundance="0.272" />
      <isotope massNumber="143" mass="142.90981" abundance="0.122" />
      <isotope massNumber="144" mass="143.910083" abundance="0.238" />
      <isotope massNumber="145" mass="144.912569" abundance="0.083" />
      <isotope massNumber="146" mass="145.913112" abundance="0.172" />
      <isotope massNumber="148" mass="147.916889" abundance="0.057" />
      <isotope massNumber="150" mass="149.920887" abundance="0.056" />
    </isotopes>
  </element>
  <element symbol="Ne" name="Neon" atomicNumber="10">
    <mass monoisotopic="19.9924401759" average="20.180046417" />
    <isotopes>
      <isotope massNumber="20" mass="19.9924401759" abundance="0.9048" />
      <isotope massNumber="21" mass="20.99384674" abundance="0.0027" />
      <isotope massNumber="22" mass="21.99138551" abundance="0.0925" />
    </isotopes>
  </element>
  <element symbol="Ni" name="Nickel" atomicNumber="28">
    <mass monoisotopic="57.9353479" average="58.6933562856" />
    <isotopes>
      <isotope massNumber="58" mass="57.9353479" abundance="0.680769" />
      <isotope massNumber="60" mass="59.9307906" abundance="0.262231" />
      <isotope massNumber="61" mass="60.9310604" abundance="0.011399" />
      <isotope massNumber="62" mass="61.9283488" abundance="0.036345" />
      <isotope massNumber="64" mass="63.9279696" abundance="0.009256" />
    </isotopes>
  </element>
  <element symbol="No" name="Nobelium" atomicNumber="102">
    <mass monoisotopic="259.10102" average="259.10102" />
    <isotopes>
      <isotope massNumber="259" mass="259.10102" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Np" name="Neptunium" atomicNumber="93">
    <mass monoisotopic="237.0481673" average="237.0481673" />
    <isotopes>
      <isotope massNumber="237" mass="237.0481673" abundance="1.0" />
      <isotope massNumber="239" mass="239.0529314" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="O" name="Oxygen" atomicNumber="8">
    <mass monoisotopic="15.9949146221" average="15.9994049284" />
    <isotopes>
      <isotope massNumber="16" mass="15.9949146221" abundance="0.99757" />
      <isotope massNumber="17" mass="16.9991315" abundance="0.00038" />
      <isotope massNumber="18" mass="17.9991604" abundance="0.00205" />
    </isotopes>
  </element>
  <element symbol="Os" name="Osmium" atomicNumber="76">
    <mass monoisotopic="191.961479" average="190.224861062" />
    <isotopes>
      <isotope massNumber="184" mass="183.952491" abundance="0.0002" />
      <isotope massNumber="186" mass="185.953838" abundance="0.0159" />
      <isotope massNumber="187" mass="186.9557479" abundance="0.0196" />
      <isotope massNumber="188" mass="187.955836" abundance="0.1324" />
      <isotope massNumber="189" mass="188.9581449" abundance="0.1615" />
      <isotope massNumber="190" mass="189.958445" abundance="0.2626" />
      <isotope massNumber="192" mass="191.961479" abundance="0.4078" />
    </isotopes>
  </element>
  <element symbol="P" name="Phosphorus" atomicNumber="15">
    <mass monoisotopic="30.97376151" average="30.97376151" />
    <isotopes>
      <isotope massNumber="31" mass="30.97376151" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Pa" name="Protactinium" atomicNumber="91">
    <mass monoisotopic="231.0358789" average="231.0358789" />
    <isotopes>
      <isotope massNumber="231" mass="231.0358789" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Pb" name="Lead" atomicNumber="82">
    <mass monoisotopic="207.976636" average="207.21689158" />
    <isotopes>
      <isotope massNumber="204" mass="203.973029" abundance="0.014" />
      <isotope massNumber="206" mass="205.974449" abundance="0.241" />
      <isotope massNumber="207" mass="206.975881" abundance="0.221" />
      <isotope massNumber="208" mass="207.976636" abundance="0.524" />
    </isotopes>
  </element>
  <element symbol="Pd" name="Palladium" atomicNumber="46">
    <mass monoisotopic="105.903483" average="106.415328028" />
    <isotopes>
      <isotope massNumber="102" mass="101.905608" abundance="0.0102" />
      <isotope massNumber="104" mass="103.904035" abundance="0.1114" />
      <isotope massNumber="105" mass="104.905084" abundance="0.2233" />
      <isotope massNumber="106" mass="105.903483" abundance="0.2733" />
      <isotope massNumber="108" mass="107.903894" abundance="0.2646" />
      <isotope massNumber="110" mass="109.905152" abundance="0.1172" />
    </isotopes>
  </element>
  <element symbol="Pm" name="Promethium" atomicNumber="61">
    <mass monoisotopic="144.912744" average="144.912744" />
    <isotopes>
      <isotope massNumber="145" mass="144.912744" abundance="1.0" />
      <isotope massNumber="147" mass="146.915134" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Po" name="Polonium" atomicNumber="84">
    <mass monoisotopic="208.982416" average="208.982416" />
    <isotopes>
      <isotope massNumber="209" mass="208.982416" abundance="1.0" />
      <isotope massNumber="210" mass="209.982857" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Pr" name="Praseodymium" atomicNumber="59">
    <mass monoisotopic="140.907648" average="140.907648" />
    <isotopes>
      <isotope massNumber="141" mass="140.907648" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Pt" name="Platinum" atomicNumber="78">
    <mass monoisotopic="194.964774" average="195.077791315" />
    <isotopes>
      <isotope massNumber="190" mass="189.95993" abundance="0.00014" />
      <isotope massNumber="192" mass="191.961035" abundance="0.00782" />
      <isotope massNumber="194" mass="193.962664" abundance="0.32967" />
      <isotope massNumber="195" mass="194.964774" abundance="0.33832" />
      <isotope massNumber="196" mass="195.964935" abundance="0.25242" />
      <isotope massNumber="198" mass="197.967876" abundance="0.07163" />
    </isotopes>
  </element>
  <element symbol="Pu" name="Plutonium" atomicNumber="94">
    <mass monoisotopic="244.064198" average="244.064198" />
    <isotopes>
      <isotope massNumber="238" mass="238.0495534" abundance="0.0" />
      <isotope massNumber="239" mass="239.0521565" abundance="0.0" />
      <isotope massNumber="240" mass="240.0538075" abundance="0.0" />
      <isotope massNumber="241" mass="241.0568453" abundance="0.0" />
      <isotope massNumber="242" mass="242.0587368" abundance="0.0" />
      <isotope massNumber="244" mass="244.064198" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ra" name="Radium" atomicNumber="88">
    <mass monoisotopic="226.0254026" average="226.0254026" />
    <isotopes>
      <isotope massNumber="223" mass="223.018497" abundance="0.0" />
      <isotope massNumber="224" mass="224.020202" abundance="0.0" />
      <isotope massNumber="226" mass="226.0254026" abundance="1.0" />
      <isotope massNumber="228" mass="228.0310641" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Rb" name="Rubidium" atomicNumber="37">
    <mass monoisotopic="84.9117893" average="85.4676641059" />
    <isotopes>
      <isotope massNumber="85" mass="84.9117893" abundance="0.7217" />
      <isotope massNumber="87" mass="86.9091835" abundance="0.2783" />
    </isotopes>
  </element>
  <element symbol="Re" name="Rhenium" atomicNumber="75">
    <mass monoisotopic="186.9557508" average="186.206705433" />
    <isotopes>
      <isotope massNumber="185" mass="184.9529557" abundance="0.374" />
      <isotope massNumber="187" mass="186.9557508" abundance="0.626" />
    </isotopes>
  </element>
  <element symbol="Rf" name="Rutherfordium" atomicNumber="104">
    <mass monoisotopic="261.10875" average="261.10875" />
    <isotopes>
      <isotope massNumber="261" mass="261.10875" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Rh" name="Rhodium" atomicNumber="45">
    <mass monoisotopic="102.905504" average="102.905504" />
    <isotopes>
      <isotope massNumber="103" mass="102.905504" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Rn" name="Radon" atomicNumber="86">
    <mass monoisotopic="222.0175705" average="222.0175705" />
    <isotopes>
      <isotope massNumber="211" mass="210.990585" abundance="0.0" />
      <isotope massNumber="220" mass="220.0113841" abundance="0.0" />
      <isotope massNumber="222" mass="222.0175705" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ru" name="Ruthenium" atomicNumber="44">
    <mass monoisotopic="101.9043495" average="101.06494499" />
    <isotopes>
      <isotope massNumber="100" mass="99.9042197" abundance="0.126" />
      <isotope massNumber="101" mass="100.9055822" abundance="0.1706" />
      <isotope massNumber="102" mass="101.9043495" abundance="0.3155" />
      <isotope massNumber="104" mass="103.90543" abundance="0.1862" />
      <isotope massNumber="96" mass="95.907598" abundance="0.0554" />
      <isotope massNumber="98" mass="97.905287" abundance="0.0187" />
      <isotope massNumber="99" mass="98.9059393" abundance="0.1276" />
    </isotopes>
  </element>
  <element symbol="S" name="Sulfur" atomicNumber="16">
    <mass monoisotopic="31.97207069" average="32.0660846938" />
    <isotopes>
      <isotope massNumber="32" mass="31.97207069" abundance="0.9493" />
      <isotope massNumber="33" mass="32.9714585" abundance="0.0076" />
      <isotope massNumber="34" mass="33.96786683" abundance="0.0429" />
      <isotope massNumber="36" mass="35.96708088" abundance="0.0002" />
    </isotopes>
  </element>
  <element symbol="Sb" name="Antimony" atomicNumber="51">
    <mass monoisotopic="120.903818" average="121.759788176" />
    <isotopes>
      <isotope massNumber="121" mass="120.903818" abundance="0.5721" />
      <isotope massNumber="123" mass="122.9042157" abundance="0.4279" />
    </isotopes>
  </element>
  <element symbol="Sc" name="Scandium" atomicNumber="21">
    <mass monoisotopic="44.9559102" average="44.9559102" />
    <isotopes>
      <isotope massNumber="45" mass="44.9559102" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Se" name="Selenium" atomicNumber="34">
    <mass monoisotopic="79.9165218" average="78.95938873" />
    <isotopes>
      <isotope massNumber="74" mass="73.9224766" abundance="0.0089" />
      <isotope massNumber="76" mass="75.9192141" abundance="0.0937" />
      <isotope massNumber="77" mass="76.9199146" abundance="0.0763" />
      <isotope massNumber="78" mass="77.9173095" abundance="0.2377" />
      <isotope massNumber="80" mass="79.9165218" abundance="0.4961" />
      <isotope massNumber="82" mass="81.9167" abundance="0.0873" />
    </isotopes>
  </element>
  <element symbol="Sg" name="Seaborgium" atomicNumber="106">
    <mass monoisotopic="266.12193" average="266.12193" />
    <isotopes>
      <isotope massNumber="266" mass="266.12193" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Si" name="Silicon" atomicNumber="14">
    <mass monoisotopic="27.9769265327" average="28.0854128453" />
    <isotopes>
      <isotope massNumber="28" mass="27.9769265327" abundance="0.922297" />
      <isotope massNumber="29" mass="28.97649472" abundance="0.046832" />
      <isotope massNumber="30" mass="29.97377022" abundance="0.030872" />
    </isotopes>
  </element>
  <element symbol="Sm" name="Samarium" atomicNumber="62">
    <mass monoisotopic="151.919728" average="150.366344004" />
    <isotopes>
      <isotope massNumber="144" mass="143.911995" abundance="0.0307" />
      <isotope massNumber="147" mass="146.914893" abundance="0.1499" />
      <isotope massNumber="148" mass="147.914818" abundance="0.1124" />
      <isotope massNumber="149" mass="148.91718" abundance="0.1382" />
      <isotope massNumber="150" mass="149.917271" abundance="0.0738" />
      <isotope massNumber="152" mass="151.919728" abundance="0.2675" />
      <isotope massNumber="154" mass="153.922205" abundance="0.2275" />
    </isotopes>
  </element>
  <element symbol="Sn" name="Tin" atomicNumber="50">
    <mass monoisotopic="119.9021966" average="118.710110491" />
    <isotopes>
      <isotope massNumber="112" mass="111.904821" abundance="0.0097" />
      <isotope massNumber="114" mass="113.902782" abundance="0.0066" />
      <isotope massNumber="115" mass="114.903346" abundance="0.0034" />
      <isotope massNumber="116" mass="115.901744" abundance="0.1454" />
      <isotope massNumber="117" mass="116.902954" abundance="0.0768" />
      <isotope massNumber="118" mass="117.901606" abundance="0.2422" />
      <isotope massNumber="119" mass="118.903309" abundance="0.0859" />
      <isotope massNumber="120" mass="119.9021966" abundance="0.3258" />
      <isotope massNumber="122" mass="121.9034401" abundance="0.0463" />
      <isotope massNumber="124" mass="123.9052746" abundance="0.0579" />
    </isotopes>
  </element>
  <element symbol="Sr" name="Strontium" atomicNumber="38">
    <mass monoisotopic="87.9056143" average="87.6166462926" />
    <isotopes>
      <isotope massNumber="84" mass="83.913425" abundance="0.0056" />
      <isotope massNumber="86" mass="85.9092624" abundance="0.0986" />
      <isotope massNumber="87" mass="86.9088793" abundance="0.07" />
      <isotope massNumber="88" mass="87.9056143" abundance="0.8258" />
    </isotopes>
  </element>
  <element symbol="Ta" name="Tantalum" atomicNumber="73">
    <mass monoisotopic="180.947996" average="180.947875936" />
    <isotopes>
      <isotope massNumber="180" mass="179.947466" abundance="0.00012" />
      <isotope massNumber="181" mass="180.947996" abundance="0.99988" />
    </isotopes>
  </element>
  <element symbol="Tb" name="Terbium" atomicNumber="65">
    <mass monoisotopic="158.925343" average="158.925343" />
    <isotopes>
      <isotope massNumber="159" mass="158.925343" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Tc" name="Technetium" atomicNumber="43">
    <mass monoisotopic="97.907216" average="97.907216" />
    <isotopes>
      <isotope massNumber="97" mass="96.906365" abundance="0.0" />
      <isotope massNumber="98" mass="97.907216" abundance="1.0" />
      <isotope massNumber="99" mass="98.9062546" abundance="0.0" />
    </isotopes>
  </element>
  <element symbol="Te" name="Tellurium" atomicNumber="52">
    <mass monoisotopic="129.9062228" average="127.603125354" />
    <isotopes>
      <isotope massNumber="120" mass="119.90402" abundance="0.0009" />
      <isotope massNumber="122" mass="121.9030471" abundance="0.0255" />
      <isotope massNumber="123" mass="122.904273" abundance="0.0089" />
      <isotope massNumber="124" mass="123.9028195" abundance="0.0474" />
      <isotope massNumber="125" mass="124.9044247" abundance="0.0707" />
      <isotope massNumber="126" mass="125.9033055" abundance="0.1884" />
      <isotope massNumber="128" mass="127.9044614" abundance="0.3174" />
      <isotope massNumber="130" mass="129.9062228" abundance="0.3408" />
    </isotopes>
  </element>
  <element symbol="Th" name="Thorium" atomicNumber="90">
    <mass monoisotopic="230.0331266" average="765.802546733" />
    <isotopes>
      <isotope massNumber="230" mass="230.0331266" abundance="2.320381" />
      <isotope massNumber="232" mass="232.0380504" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Ti" name="Titanium" atomicNumber="22">
    <mass monoisotopic="47.9479471" average="47.8667498036" />
    <isotopes>
      <isotope massNumber="46" mass="45.9526295" abundance="0.0825" />
      <isotope massNumber="47" mass="46.9517638" abundance="0.0744" />
      <isotope massNumber="48" mass="47.9479471" abundance="0.7372" />
      <isotope massNumber="49" mass="48.9478708" abundance="0.0541" />
      <isotope massNumber="50" mass="49.9447921" abundance="0.0518" />
    </isotopes>
  </element>
  <element symbol="Tl" name="Thallium" atomicNumber="81">
    <mass monoisotopic="204.974412" average="204.383317015" />
    <isotopes>
      <isotope massNumber="203" mass="202.972329" abundance="0.29524" />
      <isotope massNumber="205" mass="204.974412" abundance="0.70476" />
    </isotopes>
  </element>
  <element symbol="Tm" name="Thulium" atomicNumber="69">
    <mass monoisotopic="168.934211" average="168.934211" />
    <isotopes>
      <isotope massNumber="169" mass="168.934211" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="U" name="Uranium" atomicNumber="92">
    <mass monoisotopic="233.039628" average="792.730599067" />
    <isotopes>
      <isotope massNumber="233" mass="233.039628" abundance="2.3802891" />
      <isotope massNumber="234" mass="234.0409456" abundance="5.5e-05" />
      <isotope massNumber="235" mass="235.0439231" abundance="0.0072" />
      <isotope massNumber="236" mass="236.0455619" abundance="0.0" />
      <isotope massNumber="238" mass="238.0507826" abundance="0.992745" />
    </isotopes>
  </element>
  <element symbol="V" name="Vanadium" atomicNumber="23">
    <mass monoisotopic="50.9439637" average="50.9414716978" />
    <isotopes>
      <isotope massNumber="50" mass="49.9471628" abundance="0.0025" />
      <isotope massNumber="51" mass="50.9439637" abundance="0.9975" />
    </isotopes>
  </element>
  <element symbol="W" name="Tungsten" atomicNumber="74">
    <mass monoisotopic="183.9509326" average="183.841778628" />
    <isotopes>
      <isotope massNumber="180" mass="179.946706" abundance="0.0012" />
      <isotope massNumber="182" mass="181.948206" abundance="0.265" />
      <isotope massNumber="183" mass="182.9502245" abundance="0.1431" />
      <isotope massNumber="184" mass="183.9509326" abundance="0.3064" />
      <isotope massNumber="186" mass="185.954362" abundance="0.2843" />
    </isotopes>
  </element>
  <element symbol="Xe" name="Xenon" atomicNumber="54">
    <mass monoisotopic="131.9041545" average="131.292480845" />
    <isotopes>
      <isotope massNumber="124" mass="123.9058958" abundance="0.0009" />
      <isotope massNumber="126" mass="125.904269" abundance="0.0009" />
      <isotope massNumber="128" mass="127.9035304" abundance="0.0192" />
      <isotope massNumber="129" mass="128.9047795" abundance="0.2644" />
      <isotope massNumber="130" mass="129.9035079" abundance="0.0408" />
      <isotope massNumber="131" mass="130.9050819" abundance="0.2118" />
      <isotope massNumber="132" mass="131.9041545" abundance="0.2689" />
      <isotope massNumber="134" mass="133.9053945" abundance="0.1044" />
      <isotope massNumber="136" mass="135.90722" abundance="0.0887" />
    </isotopes>
  </element>
  <element symbol="Y" name="Yttrium" atomicNumber="39">
    <mass monoisotopic="88.9058479" average="88.9058479" />
    <isotopes>
      <isotope massNumber="89" mass="88.9058479" abundance="1.0" />
    </isotopes>
  </element>
  <element symbol="Yb" name="Ytterbium" atomicNumber="70">
    <mass monoisotopic="173.9388581" average="173.037691736" />
    <isotopes>
      <isotope massNumber="168" mass="167.933894" abundance="0.0013" />
      <isotope massNumber="170" mass="169.934759" abundance="0.0304" />
      <isotope massNumber="171" mass="170.936322" abundance="0.1428" />
      <isotope massNumber="172" mass="171.9363777" abundance="0.2183" />
      <isotope massNumber="173" mass="172.9382068" abundance="0.1613" />
      <isotope massNumber="174" mass="173.9388581" abundance="0.3183" />
      <isotope massNumber="176" mass="175.942568" abundance="0.1276" />
    </isotopes>
  </element>
  <element symbol="Zn" name="Zinc" atomicNumber="30">
    <mass monoisotopic="63.9291466" average="65.3955665657" />
    <isotopes>
      <isotope massNumber="64" mass="63.9291466" abundance="0.4863" />
      <isotope massNumber="66" mass="65.9260368" abundance="0.279" />
      <isotope massNumber="67" mass="66.9271309" abundance="0.041" />
      <isotope massNumber="68" mass="67.9248476" abundance="0.1875" />
      <isotope massNumber="70" mass="69.925325" abundance="0.0062" />
    </isotopes>
  </element>
  <element symbol="Zr" name="Zirconium" atomicNumber="40">
    <mass monoisotopic="89.9047037" average="91.2236472138" />
    <isotopes>
      <isotope massNumber="90" mass="89.9047037" abundance="0.5145" />
      <isotope massNumber="91" mass="90.905645" abundance="0.1122" />
      <isotope massNumber="92" mass="91.9050401" abundance="0.1715" />
      <isotope massNumber="94" mass="93.9063158" abundance="0.1738" />
      <isotope massNumber="96" mass="95.908276" abundance="0.028" />
    </isotopes>
  </element>
</mspyElements>
"""


aminoacids = """<?xml version="1.0" encoding="utf-8" ?>
<mspyAminoacids version="1.0">
  <aminoacid symbol="A" name="Alanine" abbr="Ala" formula="C3H5NO" />
  <aminoacid symbol="C" name="Cysteine" abbr="Cys" formula="C3H5NOS" />
  <aminoacid symbol="D" name="Aspartic Acid" abbr="Asp" formula="C4H5NO3" />
  <aminoacid symbol="E" name="Glutamic Acid" abbr="Glu" formula="C5H7NO3" />
  <aminoacid symbol="F" name="Phenylalanine" abbr="Phe" formula="C9H9NO" />
  <aminoacid symbol="G" name="Glycine" abbr="Gly" formula="C2H3NO" />
  <aminoacid symbol="H" name="Histidine" abbr="His" formula="C6H7N3O" />
  <aminoacid symbol="I" name="Isoleucine" abbr="Ile" formula="C6H11NO" />
  <aminoacid symbol="K" name="Lysine" abbr="Lys" formula="C6H12N2O" />
  <aminoacid symbol="L" name="Leucine" abbr="Leu" formula="C6H11NO" />
  <aminoacid symbol="M" name="Methionine" abbr="Met" formula="C5H9NSO" />
  <aminoacid symbol="N" name="Asparagine" abbr="Asn" formula="C4H6O2N2" />
  <aminoacid symbol="P" name="Proline" abbr="Pro" formula="C5H7NO" />
  <aminoacid symbol="Q" name="Glutamine" abbr="Gln" formula="C5H8N2O2" />
  <aminoacid symbol="R" name="Arginine" abbr="Arg" formula="C6H12N4O" />
  <aminoacid symbol="S" name="Serine" abbr="Ser" formula="C3H5NO2" />
  <aminoacid symbol="T" name="Threonine" abbr="Thr" formula="C4H7NO2" />
  <aminoacid symbol="V" name="Valine" abbr="Val" formula="C5H9NO" />
  <aminoacid symbol="W" name="Tryptophan" abbr="Trp" formula="C11H10N2O" />
  <aminoacid symbol="Y" name="Tyrosine" abbr="Tyr" formula="C9H9NO2" />
</mspyAminoacids>
"""


enzymes = """<?xml version="1.0" encoding="utf-8" ?>
<mspyEnzymes version="1.0">
  <enzyme name="Arg-C">
    <expression><![CDATA[[R][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Asp-N">
    <expression><![CDATA[[A-Z][D]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="1" after="0" />
  </enzyme>
  <enzyme name="Bromelain">
    <expression><![CDATA[[KAY][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="CNBr-HSerLac">
    <expression><![CDATA[[M][A-Z]]]></expression>
    <formula nTerm="H" cTerm="O-1C-1H-3" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Cathepsin B">
    <expression><![CDATA[[R][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Cathepsin D">
    <expression><![CDATA[[LF][^VAG]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Cathepsin G">
    <expression><![CDATA[[YWF][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Chymotrypsin">
    <expression><![CDATA[[YWFL][^P]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Clostripain">
    <expression><![CDATA[[R][^P]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Elastase">
    <expression><![CDATA[[AVLIGS][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Glu-C Bic">
    <expression><![CDATA[[E][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Glu-C Phos">
    <expression><![CDATA[[ED][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Hydroxylamine">
    <expression><![CDATA[[N][G]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="0" />
  </enzyme>
  <enzyme name="Lys-C">
    <expression><![CDATA[[K][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Lys-N">
    <expression><![CDATA[[A-Z][K]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="1" after="0" />
  </enzyme>
  <enzyme name="Non-Specific">
    <expression><![CDATA[[A-Z][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="1" after="1" />
  </enzyme>
  <enzyme name="Papain">
    <expression><![CDATA[[RK][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Pepsin">
    <expression><![CDATA[[LF][^VAG]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Proteinase K">
    <expression><![CDATA[[YWF][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Subtilisin">
    <expression><![CDATA[[^RHK][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Thermolysin">
    <expression><![CDATA[[A-Z][LFIVMA]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="1" after="0" />
  </enzyme>
  <enzyme name="TrypAspN">
    <expression><![CDATA[(([KR][^P])|([A-Z][D]))]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="0" />
  </enzyme>
  <enzyme name="TrypChymo">
    <expression><![CDATA[[FYWLKR][^P]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Trypsin">
    <expression><![CDATA[[KR][^P]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
  <enzyme name="Trypsin/P">
    <expression><![CDATA[[KR][A-Z]]]></expression>
    <formula nTerm="H" cTerm="OH" />
    <allowMods before="0" after="1" />
  </enzyme>
</mspyEnzymes>
"""


fragments = """<?xml version="1.0" encoding="utf-8" ?>
<mspyFragments version="1.0">
  <fragment name="a" terminus="N" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="" cTerm="C-1O-1H-1" neutralLoss="" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="a-H2O" terminus="N" specifity="STED">
    <formula nTerm="" cTerm="C-1O-1H-1" neutralLoss="H2O" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="a-NH3" terminus="N" specifity="RKQN">
    <formula nTerm="" cTerm="C-1O-1H-1" neutralLoss="NH3" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="b" terminus="N" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="" cTerm="H-1" neutralLoss="" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="b-H2O" terminus="N" specifity="STED">
    <formula nTerm="" cTerm="H-1" neutralLoss="H2O" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="b-NH3" terminus="N" specifity="RKQN">
    <formula nTerm="" cTerm="H-1" neutralLoss="NH3" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="c" terminus="N" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="" cTerm="NH2" neutralLoss="" />
    <termFilter nTerm="1" cTerm="1" />
  </fragment>
  <fragment name="c-ladder" terminus="N" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="" cTerm="OH" neutralLoss="" />
    <termFilter nTerm="0" cTerm="1" />
  </fragment>
  <fragment name="im" terminus="S" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="H" cTerm="C-1O-1H-1" neutralLoss="" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
  <fragment name="int" terminus="I" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="H" cTerm="H-1" neutralLoss="" />
    <termFilter nTerm="0" cTerm="0" />
  </fragment>
  <fragment name="int-CO" terminus="I" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="H" cTerm="C-1O-1H-1" neutralLoss="" />
    <termFilter nTerm="0" cTerm="0" />
  </fragment>
  <fragment name="int-H2O" terminus="I" specifity="STED">
    <formula nTerm="H" cTerm="H-1" neutralLoss="H2O" />
    <termFilter nTerm="0" cTerm="0" />
  </fragment>
  <fragment name="int-NH3" terminus="I" specifity="RKQN">
    <formula nTerm="H" cTerm="H-1" neutralLoss="NH3" />
    <termFilter nTerm="0" cTerm="0" />
  </fragment>
  <fragment name="n-ladder" terminus="C" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="H" cTerm="" neutralLoss="" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
  <fragment name="x" terminus="C" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="COH-1" cTerm="" neutralLoss="" />
    <termFilter nTerm="0" cTerm="1" />
  </fragment>
  <fragment name="y" terminus="C" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="H" cTerm="" neutralLoss="" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
  <fragment name="y-H2O" terminus="C" specifity="STED">
    <formula nTerm="H" cTerm="" neutralLoss="H2O" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
  <fragment name="y-NH3" terminus="C" specifity="RKQN">
    <formula nTerm="H" cTerm="" neutralLoss="NH3" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
  <fragment name="z" terminus="C" specifity="ACDEFGHIKLMNPQRSTVYW">
    <formula nTerm="N-1H-1" cTerm="" neutralLoss="" />
    <termFilter nTerm="1" cTerm="0" />
  </fragment>
</mspyFragments>
"""


modifications = """<?xml version="1.0" encoding="utf-8" ?>
<mspyModifications version="1.0">
  <modification name="Acetyl">
    <description>Acetylation</description>
    <formula gain="C2H3O" loss="H" />
    <specifity amino="KCST" terminus="N" />
  </modification>
  <modification name="Amide">
    <description>Amidation</description>
    <formula gain="NH2" loss="OH" />
    <specifity amino="" terminus="C" />
  </modification>
  <modification name="Aminotyrosine">
    <description>Tyrosine oxidation to 2-aminotyrosine</description>
    <formula gain="HN" loss="" />
    <specifity amino="Y" terminus="" />
  </modification>
  <modification name="Biotin">
    <description>Biotinylation</description>
    <formula gain="H14C10N2O2S" loss="" />
    <specifity amino="K" terminus="N" />
  </modification>
  <modification name="Boc">
    <description>Boc protecting group</description>
    <formula gain="C5H9O2" loss="H" />
    <specifity amino="K" terminus="N" />
  </modification>
  <modification name="Carbamidomethyl">
    <description>Iodoacetamide derivative</description>
    <formula gain="CH2CONH2" loss="H" />
    <specifity amino="CKHDE" terminus="N" />
  </modification>
  <modification name="Carbamyl">
    <description>Carbamylation</description>
    <formula gain="HCNO" loss="" />
    <specifity amino="KRCM" terminus="N" />
  </modification>
  <modification name="Carboxyethyl">
    <description>Carboxyethyl</description>
    <formula gain="H4C3O2" loss="" />
    <specifity amino="K" terminus="" />
  </modification>
  <modification name="Carboxyl">
    <description>Carboxylation</description>
    <formula gain="CO2" loss="" />
    <specifity amino="WKDEM" terminus="" />
  </modification>
  <modification name="Carboxymethyl">
    <description>Iodoacetic acid derivative</description>
    <formula gain="CH2COOH" loss="H" />
    <specifity amino="CKW" terminus="N" />
  </modification>
  <modification name="Cation:K">
    <description>Replacement of proton by potassium</description>
    <formula gain="K" loss="H" />
    <specifity amino="DE" terminus="C" />
  </modification>
  <modification name="Cation:Na">
    <description>Replacement of proton by sodium</description>
    <formula gain="Na" loss="H" />
    <specifity amino="DE" terminus="C" />
  </modification>
  <modification name="Cyano">
    <description>Cyano</description>
    <formula gain="CN" loss="H" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Cystine">
    <description>Half of a disulfide bridge</description>
    <formula gain="" loss="H" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Deamidation">
    <description>Deamidation</description>
    <formula gain="O" loss="HN" />
    <specifity amino="NQRF" terminus="" />
  </modification>
  <modification name="Dehydrated">
    <description>Dehydration</description>
    <formula gain="" loss="H2O" />
    <specifity amino="NQSTYDC" terminus="" />
  </modification>
  <modification name="Cys->Dha">
    <description>Dehydroalanine (from Cysteine)</description>
    <formula gain="" loss="H2S" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Tyr->Dha">
    <description>Dehydroalanine (from Tyrosine)</description>
    <formula gain="" loss="H6C6O" />
    <specifity amino="Y" terminus="" />
  </modification>
  <modification name="dHex">
    <description>Deoxyhexose, fucose</description>
    <formula gain="C6H12O5" loss="H2O" />
    <specifity amino="ST" terminus="" />
  </modification>
  <modification name="Diacylglycerol">
    <description>Diacylglycerol</description>
    <formula gain="H68C37O4" loss="" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Dioxidation">
    <description>Dihydroxy</description>
    <formula gain="O2H2" loss="H2" />
    <specifity amino="PRKMFWYC" terminus="" />
  </modification>
  <modification name="Dimethyl">
    <description>Di-Methylation</description>
    <formula gain="C2H6" loss="H2" />
    <specifity amino="KRNP" terminus="N" />
  </modification>
  <modification name="Ethanolyl">
    <description>Ethanolation of Cys</description>
    <formula gain="H4C2O" loss="" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Ethyl">
    <description>Ethylation</description>
    <formula gain="H4C2" loss="" />
    <specifity amino="KED" terminus="N" />
  </modification>
  <modification name="FAD">
    <description>Flavin adenine dinucleotide</description>
    <formula gain="H31C27N9O15P2" loss="" />
    <specifity amino="CHY" terminus="" />
  </modification>
  <modification name="FMNH">
    <description>Flavin mononucleotide</description>
    <formula gain="H19C17N4O9P" loss="" />
    <specifity amino="CH" terminus="" />
  </modification>
  <modification name="Fluorescein">
    <description>5-iodoacetamidofluorescein</description>
    <formula gain="H14C22NO6" loss="" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Fmoc">
    <description>Fmoc protecting group</description>
    <formula gain="C15H11O2" loss="H" />
    <specifity amino="K" terminus="N" />
  </modification>
  <modification name="Formyl">
    <description>Formylation</description>
    <formula gain="CHO" loss="H" />
    <specifity amino="KST" terminus="N" />
  </modification>
  <modification name="Guanidination">
    <description>Homoarginine from Lysine</description>
    <formula gain="CH3N2" loss="H" />
    <specifity amino="K" terminus="" />
  </modification>
  <modification name="Guanidinyl">
    <description>Guanidination</description>
    <formula gain="H2CN2" loss="" />
    <specifity amino="K" terminus="" />
  </modification>
  <modification name="Heme">
    <description>Heme</description>
    <formula gain="H32C34N4O4Fe" loss="" />
    <specifity amino="CH" terminus="" />
  </modification>
  <modification name="Hep">
    <description>Heptose</description>
    <formula gain="C7H14O7" loss="H2O" />
    <specifity amino="KNQRST" terminus="" />
  </modification>
  <modification name="HexNAc">
    <description>N-Acetylhexosamine</description>
    <formula gain="C8H15N1O6" loss="H2O" />
    <specifity amino="NST" terminus="" />
  </modification>
  <modification name="HexN">
    <description>Hexosamine</description>
    <formula gain="C6H13N1O5" loss="H2O" />
    <specifity amino="KNTW" terminus="" />
  </modification>
  <modification name="Hex">
    <description>Hexose</description>
    <formula gain="C6H12O6" loss="H2O" />
    <specifity amino="KNTWCRY" terminus="N" />
  </modification>
  <modification name="Hydroxymethyl">
    <description>Hydroxymethyl</description>
    <formula gain="H2CO" loss="" />
    <specifity amino="N" terminus="" />
  </modification>
  <modification name="Iodo">
    <description>Iodination</description>
    <formula gain="I" loss="H" />
    <specifity amino="YH" terminus="" />
  </modification>
  <modification name="Lipoyl">
    <description>Lipoyl</description>
    <formula gain="H12C8OS2" loss="" />
    <specifity amino="K" terminus="" />
  </modification>
  <modification name="Methyl">
    <description>Methylation</description>
    <formula gain="CH3" loss="H" />
    <specifity amino="CHKNQRIL" terminus="N" />
  </modification>
  <modification name="Myristoyl">
    <description>Myristoylation</description>
    <formula gain="C14H27O" loss="H" />
    <specifity amino="GKC" terminus="N" />
  </modification>
  <modification name="FormylMet">
    <description>Addition of N-formyl Methionine</description>
    <formula gain="H10C6NO2S" loss="" />
    <specifity amino="" terminus="N" />
  </modification>
  <modification name="Nitro">
    <description>Oxidation to nitro</description>
    <formula gain="NO2" loss="H" />
    <specifity amino="WY" terminus="" />
  </modification>
  <modification name="Oxidation">
    <description>Oxidation or Hydroxylation</description>
    <formula gain="O" loss="" />
    <specifity amino="ODKNPFYRMCHWG" terminus="" />
  </modification>
  <modification name="Phenylisocyanate">
    <description>Phenyl isocyanate</description>
    <formula gain="H5C7NO" loss="" />
    <specifity amino="" terminus="N" />
  </modification>
  <modification name="Palmitoyl">
    <description>Palmitoylation</description>
    <formula gain="C16H31O" loss="H" />
    <specifity amino="CKST" terminus="N" />
  </modification>
  <modification name="Pentose">
    <description>Pentose</description>
    <formula gain="C5H10O5" loss="H2O" />
    <specifity amino="STD" terminus="" />
  </modification>
  <modification name="Phospho">
    <description>Phosphorylation</description>
    <formula gain="H2PO3" loss="H" />
    <specifity amino="STYDHCR" terminus="" />
  </modification>
  <modification name="Propionamide">
    <description>Acrylamide adduct</description>
    <formula gain="C3H6ON" loss="H" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="Label:13C(6)">
    <description>13C(6) Silac label</description>
    <formula gain="C{13}6" loss="C6" />
    <specifity amino="KR" terminus="" />
  </modification>
  <modification name="SeCys">
    <description>Selenium replaces sulphur in Cysteine</description>
    <formula gain="Se" loss="S" />
    <specifity amino="C" terminus="" />
  </modification>
  <modification name="SeMet">
    <description>Selenium replaces sulphur in Methionine</description>
    <formula gain="Se" loss="S" />
    <specifity amino="M" terminus="" />
  </modification>
  <modification name="Sulfo">
    <description>O-Sulfonation</description>
    <formula gain="HSO3" loss="H" />
    <specifity amino="STYC" terminus="" />
  </modification>
  <modification name="tButyl">
    <description>tButyl protecting group</description>
    <formula gain="C4H9" loss="H" />
    <specifity amino="CDEHSTY" terminus="" />
  </modification>
</mspyModifications>
"""


# SAVE BLOCK FILES
# ----------------

def saveElements(path):
    """Save elements XML."""
    
    try:
        save = file(path, 'w')
        save.write(elements.encode("utf-8"))
        save.close()
        return True
    except:
        return False
# ----


def saveAminoacids(path):
    """Save aminoacids XML."""
    
    try:
        save = file(path, 'w')
        save.write(aminoacids.encode("utf-8"))
        save.close()
        return True
    except:
        return False
# ----


def saveEnzymes(path):
    """Save enzymes XML."""
    
    try:
        save = file(path, 'w')
        save.write(enzymes.encode("utf-8"))
        save.close()
        return True
    except:
        return False
# ----


def saveFragments(path):
    """Save fragments XML."""
    
    try:
        save = file(path, 'w')
        save.write(fragments.encode("utf-8"))
        save.close()
        return True
    except:
        return False
# ----


def saveModifications(path):
    """Save modifications XML."""
    
    try:
        save = file(path, 'w')
        save.write(modifications.encode("utf-8"))
        save.close()
        return True
    except:
        return False
# ----


