
## Tutorials

Tutorials for mlpack can be found [here : mlpack tutorials](http://www.mlpack.org/tutorials.html).


### General mlpack tutorials

These tutorials introduce the basic concepts of working with mlpack, aimed at developers who want to use and contribute to mlpack but are not sure where to start.

* [Building mlpack from source](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=build.html)
* [File Formats in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=formatdoc.html)
* [Matrices in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=matrices.html)
* [mlpack input and output](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=iodoc.html)
* [mlpack timers](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=timer.html)
* [Simple sample mlpack programs](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=sample.html)


### Method-specific tutorials

These tutorials introduce the various methods mlpack offers, aimed at users who want to get started quickly. These tutorials start with simple examples and progress to complex, extensible uses.

* [NeighborSearch tutorial (mlpack_knn / mlpack_kfn)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=nstutorial.html)
* [LinearRegression tutorial (mlpack_linear_regression)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=lrtutorial.html)
* [RangeSearch tutorial (mlpack_range_search)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=rstutorial.html)
* [Density Estimation Trees tutorial (mlpack_det)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=dettutorial.html)
* [K-Means tutorial (mlpack_kmeans)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=kmtutorial.html)
* [FastMKS tutorial (mlpack_fastmks)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=fmkstutorial.html)
* [Euclidean Minimum Spanning Trees tutorial (mlpack_emst)](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=emst_tutorial.html)
* [Alternating Matrix Factorization Tutorial](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=amftutorial.html)
* [Collaborative Filtering Tutorial](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=cftutorial.html)


### Policy Class Documentation

mlpack uses templates to achieve its genericity and flexibility. Some of the template types used by mlpack are common across multiple machine learning algorithms. The links below provide documentation for some of these common types.

* [The MetricType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=metrics.html)
* [The KernelType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=kernels.html)
* [The TreeType policy in mlpack](http://www.mlpack.org/docs/mlpack-git/doxygen.php?doc=trees.html)
