/**
 * @file binary_space_tree.hpp
 * @author Ryan Curtin
 *
 * Include all the necessary files to use the BinarySpaceTree class.
 *
 * This file is part of mlpack 2.0.0.
 *
 * mlpack is free software: you can redistribute it and/or modify it under the
 * terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option) any
 * later version.
 *
 * mlpack is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details (LICENSE.txt).
 *
 * You should have received a copy of the GNU General Public License along with
 * mlpack.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef __MLPACK_CORE_TREE_BINARY_SPACE_TREE_HPP
#define __MLPACK_CORE_TREE_BINARY_SPACE_TREE_HPP

#include <mlpack/core.hpp>
#include "bounds.hpp"
#include "binary_space_tree/midpoint_split.hpp"
#include "binary_space_tree/mean_split.hpp"
#include "binary_space_tree/binary_space_tree.hpp"
#include "binary_space_tree/single_tree_traverser.hpp"
#include "binary_space_tree/single_tree_traverser_impl.hpp"
#include "binary_space_tree/dual_tree_traverser.hpp"
#include "binary_space_tree/dual_tree_traverser_impl.hpp"
#include "binary_space_tree/breadth_first_dual_tree_traverser.hpp"
#include "binary_space_tree/breadth_first_dual_tree_traverser_impl.hpp"
#include "binary_space_tree/traits.hpp"
#include "binary_space_tree/typedef.hpp"

#endif
