(*
 *  C2caml : parses c headers and produces appropriate caml bindings for it
 *  Copyright (C) 1999  Sven LUTHER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(* $Id: var.ml,v 1.1 1999/06/19 14:59:20 sven Exp $ *)

type types = Expr.types
type values = Expr.expr
type var = string * (types * values)
type varlist = var list list ref

exception Double_defined
let empty () = (ref [] : varlist)
let vl = empty ()
let begin_block vl = vl := []::!vl
let end_block vl = vl := List.tl !vl
let add_var var vl t v =
  let h = List.hd !vl
  in if List.mem_assoc var h
    then raise Double_defined
    else vl := ((var,(t,v))::h)::(List.tl !vl)
let rec get_var var vl =
  let rec rgv = function
  | [] -> raise Not_found
  | t::q -> try List.assoc var t with Not_found -> rgv q
  in rgv !vl
let get_type var vl = fst (get_var var vl)
let get_value var vl = snd (get_var var vl)
let is_typedef var vl =
  try
    match (snd (get_var var vl)).Expr.expr with
    | Expr.E_typedef -> true
    | _ -> false
  with Not_found -> false
let is_enum_ident var vl =
  try
    match (snd (get_var var vl)).Expr.expr with
    | Expr.E_enum_ident -> true
    | _ -> false
  with Not_found -> false
