(*
 *                     The OCaml-gtk interface
 *
 * Copyright (c) 1997, 1998   David Monniaux & Pascal Cuoq
 *
 * This file is distributed under the conditions described in
 * the file LICENSE.
 *)

(* $Id: glib.ml,v 1.10 1999/06/21 12:23:50 sven Exp $ *)

(* WARNING:
These lists are NOT for storing ML boxed values.
The pointers in those lists won't be updated during garbage collection.
*)
module GList =
struct
  type 'a t
  external empty : unit->'a t = "mlg_zero";;
  external alloc : unit->'a t = "g_list_alloc";;
  external free : 'a t->unit = "mlg_list_free";;
  external free_1 : 'a t->unit = "mlg_list_free_1";;
  external append : 'a t->'a->'a t = "g_list_append";;
  external prepend : 'a t->'a->'a t = "g_list_prepend";;
  external insert : 'a t->'a->int->'a t = "mlg_list_insert";;
  external remove : 'a t->'a->'a t = "g_list_remove";;
  external remove_link : 'a t->'a t->'a t="g_list_remove_link";;
  external reverse : 'a t->'a t="g_list_reverse";;
  external nth : 'a t->int->'a t="mlg_list_nth";;
  external find : 'a t->'a->'a t="g_list_find";;
  external last : 'a t->'a ="g_list_last";;
  external first : 'a t->'a ="g_list_first";;
  external length : 'a t->int="mlg_list_length";;
  external foreach : 'a t->('a->unit)->unit="mlg_list_foreach";;

  let rec from_ml : 'a list->'a t = function
      [] -> empty()
    | h::t -> prepend (from_ml t) h;;
  let ml_from (l : 'a t) =
    let output=ref [] in
      foreach l (fun x->output:=x :: !output);
      List.rev(! output);;
end;;

module GSList =
struct
  type 'a t
  external empty : unit->'a t = "mlg_zero";;
  external alloc : unit->'a t = "g_slist_alloc";;
  external free : 'a t->unit = "mlg_slist_free";;
  external free_1 : 'a t->unit = "mlg_slist_free_1";;
  external append : 'a t->'a->'a t = "g_slist_append";;
  external prepend : 'a t->'a->'a t = "g_slist_prepend";;
  external insert : 'a t->'a->int->'a t = "mlg_slist_insert";;
  external remove : 'a t->'a->'a t = "g_slist_remove";;
  external remove_link : 'a t->'a t->'a t="g_slist_remove_link";;
  external reverse : 'a t->'a t="g_slist_reverse";;
  external nth : 'a t->int->'a t="mlg_slist_nth";;
  external find: 'a t->'a->'a t="g_slist_find";;
  external last : 'a t->'a ="g_slist_last";;
  (*external first: 'a t->'a ="g_slist_first";;*)
  external length : 'a t->int="mlg_slist_length";;
  external foreach : 'a t->('a->unit)->unit="mlg_slist_foreach";;

  let rec from_ml : 'a list->'a t = function
      [] -> empty()
    | h::t -> prepend (from_ml t) h;;
  let ml_from (l  : 'a t) =
    let output=ref [] in
      foreach l (fun x->output :=x :: !output);
      List.rev(! output);;
end;;

module Pointer = struct
  type t
  external int_poke : t->int->unit = "mlgtk_int_poke"
  external int_peek : t->int = "mlgtk_int_peek"
end;;
