/*******************************************************************************
* Copyright 2019 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "common_f32.hpp"
#include "jit_generator.hpp"

namespace mkldnn {
namespace impl {
namespace cpu {

jit_avx_kernel_sgemm_kern::jit_avx_kernel_sgemm_kern() :
    jit_generator(nullptr, F32_COMPUTE_KERNEL_CODE_SIZE) {

#ifndef _WIN32

#define M   rdi
#define N   rsi
#define K   rdx
#define A   r8
#define B   r9
#define C   rcx
#define LDC r10

#define AA  r15
#define I   r11
#define J   r12
#define H   rax
#define AO  rbx
#define BO  rbp
#define CO1 r13
#define CO2 r14

#define OLD_C       8+stacksize+rsp
#define OLD_LDC     16+stacksize+rsp

#else

#define M   rcx
#define N   rdx
#define K   r8
#define A   rdi
#define B   rsi
#define C   r9
#define LDC r10
#define AA  r15
#define I   r11
#define J   r12
#define H   rax
#define AO  rbx
#define BO  rbp
#define CO1 r13
#define CO2 r14

#define OLD_A       40+stacksize+rsp
#define OLD_B       48+stacksize+rsp
#define OLD_C       56+stacksize+rsp
#define OLD_LDC     64+stacksize+rsp

#endif

inLocalLabel();
{

Xbyak::Label l1064;
Xbyak::Label l1078;
Xbyak::Label l10a8;
Xbyak::Label l1104;
Xbyak::Label l12c8;
Xbyak::Label l12e4;
Xbyak::Label l14a8;
Xbyak::Label l14b4;
Xbyak::Label l1524;
Xbyak::Label l15ac;
Xbyak::Label l1614;
Xbyak::Label l17d8;
Xbyak::Label l17e8;
Xbyak::Label l19ac;
Xbyak::Label l19b8;
Xbyak::Label l1a28;
Xbyak::Label l1a84;
Xbyak::Label l1aec;
Xbyak::Label l1cb0;
Xbyak::Label l1cbc;
Xbyak::Label l1e80;
Xbyak::Label l1e8c;
Xbyak::Label l1efc;
Xbyak::Label l1f44;
Xbyak::Label l1f48;
Xbyak::Label l1f78;
Xbyak::Label l1fd4;
Xbyak::Label l219c;
Xbyak::Label l21b8;
Xbyak::Label l2380;
Xbyak::Label l238c;
Xbyak::Label l23fc;
Xbyak::Label l2484;
Xbyak::Label l24ec;
Xbyak::Label l26b4;
Xbyak::Label l26c4;
Xbyak::Label l288c;
Xbyak::Label l2898;
Xbyak::Label l2908;
Xbyak::Label l2964;
Xbyak::Label l29cc;
Xbyak::Label l2a0;
Xbyak::Label l2b94;
Xbyak::Label l2ba0;
Xbyak::Label l2bc;
Xbyak::Label l2d68;
Xbyak::Label l2d74;
Xbyak::Label l2de4;
Xbyak::Label l2e2c;
Xbyak::Label l2e30;
Xbyak::Label l2e60;
Xbyak::Label l2ebc;
Xbyak::Label l3084;
Xbyak::Label l30a0;
Xbyak::Label l3268;
Xbyak::Label l3274;
Xbyak::Label l32e4;
Xbyak::Label l336c;
Xbyak::Label l33d4;
Xbyak::Label l359c;
Xbyak::Label l35ac;
Xbyak::Label l3774;
Xbyak::Label l3780;
Xbyak::Label l37f0;
Xbyak::Label l384c;
Xbyak::Label l38b4;
Xbyak::Label l3a7c;
Xbyak::Label l3a88;
Xbyak::Label l3c50;
Xbyak::Label l3c5c;
Xbyak::Label l3ccc;
Xbyak::Label l3d14;
Xbyak::Label l3d18;
Xbyak::Label l3d48;
Xbyak::Label l3da4;
Xbyak::Label l3f6c;
Xbyak::Label l3f84;
Xbyak::Label l414c;
Xbyak::Label l4158;
Xbyak::Label l41c8;
Xbyak::Label l4250;
Xbyak::Label l42b8;
Xbyak::Label l4480;
Xbyak::Label l4490;
Xbyak::Label l4658;
Xbyak::Label l4664;
Xbyak::Label l46d4;
Xbyak::Label l4730;
Xbyak::Label l4798;
Xbyak::Label l48c;
Xbyak::Label l4960;
Xbyak::Label l496c;
Xbyak::Label l498;
Xbyak::Label l4b34;
Xbyak::Label l4b40;
Xbyak::Label l4bb0;
Xbyak::Label l4bf8;
Xbyak::Label l4bfc;
Xbyak::Label l50;
Xbyak::Label l508;
Xbyak::Label l608;
Xbyak::Label l670;
Xbyak::Label l74;
Xbyak::Label l840;
Xbyak::Label l850;
Xbyak::Label la20;
Xbyak::Label la2c;
Xbyak::Label la9c;
Xbyak::Label lb4c;
Xbyak::Label lbb4;
Xbyak::Label ld0;
Xbyak::Label ld84;
Xbyak::Label ld90;
Xbyak::Label lf60;
Xbyak::Label lf6c;
Xbyak::Label lfdc;

    preamble();
    auto stacksize = get_size_of_abi_save_regs();
#ifdef _WIN32
    mov(A, ptr[OLD_A]);
    mov(B, ptr[OLD_B]);
#endif
    mov(C, ptr[OLD_C]);
    mov(LDC, ptr[OLD_LDC]);

    mov(M, qword[M]);
    mov(N, qword[N]);
    mov(K, qword[K]);
    shl(LDC, 0x2);
    sub(A, -128);
    sub(B, -128);
    mov(J, M);
    cmp(J, 0x10);
    jl(l1078, T_NEAR);
    align(4);

L(l50);
    mov(AA, K);
    imul(AA, AA, 0x40);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x40);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(l608, T_NEAR);
    align(4);

L(l74);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l48c, T_NEAR);
    sub(H, 0x1e);
    jle(l2a0, T_NEAR);
    align(4);

L(ld0);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(ld0, T_NEAR);
    align(4);

L(l2a0);
    prefetcht0(byte[CO1+0x3c]);
    prefetcht0(byte[CO1+LDC*1+0x3c]);
    prefetcht0(byte[CO2+0x3c]);
    prefetcht0(byte[CO2+LDC*1+0x3c]);
    add(H, 0x1e);
    align(4);

L(l2bc);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l2bc, T_NEAR);
    align(4);

L(l48c);
    mov(H, K);
    and_(H, 0x3);
    je(l508, T_NEAR);
    align(4);

L(l498);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x40]);
    vmovups(ymm1, yword[AO-0x20]);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    sub(AO, -64);
    sub(BO, -16);
    dec(H);
    jg(l498, T_NEAR);
    align(4);

L(l508);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    vmovups(ymm1, yword[CO1+0x20]);
    vaddps(ymm12, ymm1, ymm12);
    vmovups(yword[CO1+0x20], ymm12);
    vmovups(ymm0, yword[CO1+LDC*1+0x0]);
    vaddps(ymm9, ymm0, ymm9);
    vmovups(yword[CO1+LDC*1+0x0], ymm9);
    vmovups(ymm1, yword[CO1+LDC*1+0x20]);
    vaddps(ymm13, ymm1, ymm13);
    vmovups(yword[CO1+LDC*1+0x20], ymm13);
    vmovups(ymm0, yword[CO2]);
    vaddps(ymm10, ymm0, ymm10);
    vmovups(yword[CO2], ymm10);
    vmovups(ymm1, yword[CO2+0x20]);
    vaddps(ymm14, ymm1, ymm14);
    vmovups(yword[CO2+0x20], ymm14);
    vmovups(ymm0, yword[CO2+LDC*1]);
    vaddps(ymm11, ymm0, ymm11);
    vmovups(yword[CO2+LDC*1], ymm11);
    vmovups(ymm1, yword[CO2+LDC*1+0x20]);
    vaddps(ymm15, ymm1, ymm15);
    vmovups(yword[CO2+LDC*1+0x20], ymm15);
    lea(CO1, ptr[CO1+LDC*4+0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(l74, T_NEAR);
    align(4);

L(l608);
    test(I, 0x2);
    jle(lb4c, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(la20, T_NEAR);
    sub(H, 0x1e);
    jle(l840, T_NEAR);
    align(4);

L(l670);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l670, T_NEAR);
    align(4);

L(l840);
    prefetcht0(byte[CO1+0x3c]);
    prefetcht0(byte[CO1+LDC*1+0x3c]);
    add(H, 0x1e);
    align(4);

L(l850);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l850, T_NEAR);
    align(4);

L(la20);
    mov(H, K);
    and_(H, 0x3);
    je(la9c, T_NEAR);
    align(4);

L(la2c);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x40]);
    vmovups(ymm1, yword[AO-0x20]);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    sub(AO, -64);
    sub(BO, -8);
    dec(H);
    jg(la2c, T_NEAR);
    align(4);

L(la9c);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    vmovups(ymm1, yword[CO1+0x20]);
    vaddps(ymm12, ymm1, ymm12);
    vmovups(yword[CO1+0x20], ymm12);
    vmovups(ymm0, yword[CO1+LDC*1+0x0]);
    vaddps(ymm9, ymm0, ymm9);
    vmovups(yword[CO1+LDC*1+0x0], ymm9);
    vmovups(ymm1, yword[CO1+LDC*1+0x20]);
    vaddps(ymm13, ymm1, ymm13);
    vmovups(yword[CO1+LDC*1+0x20], ymm13);
    lea(CO1, ptr[CO1+LDC*2+0x0]);
    align(4);

L(lb4c);
    test(I, 0x1);
    jle(l1064, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(lf60, T_NEAR);
    sub(H, 0x1e);
    jle(ld84, T_NEAR);
    align(4);

L(lbb4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(lbb4, T_NEAR);
    align(4);

L(ld84);
    prefetcht0(byte[CO1+0x3c]);
    add(H, 0x1e);
    align(4);

L(ld90);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO+0x40]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO+0x60]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO+0x80]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0xa0]);
    sub(AO, -256);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(ld90, T_NEAR);
    align(4);

L(lf60);
    mov(H, K);
    and_(H, 0x3);
    je(lfdc, T_NEAR);
    align(4);

L(lf6c);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x40]);
    vmovups(ymm1, yword[AO-0x20]);
    vbroadcastf128(ymm2, xword[BO-0x7c]);
    sub(AO, -64);
    sub(BO, -4);
    dec(H);
    jg(lf6c, T_NEAR);
    align(4);

L(lfdc);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vblendps(ymm0, ymm12, ymm13, 0xaa);
    vblendps(ymm1, ymm12, ymm13, 0x55);
    vblendps(ymm2, ymm14, ymm15, 0xaa);
    vblendps(ymm3, ymm14, ymm15, 0x55);
    vblendps(ymm12, ymm0, ymm2, 0xcc);
    vblendps(ymm13, ymm1, ymm3, 0xcc);
    vblendps(ymm14, ymm0, ymm2, 0x33);
    vblendps(ymm15, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    vmovups(ymm1, yword[CO1+0x20]);
    vaddps(ymm12, ymm1, ymm12);
    vmovups(yword[CO1+0x20], ymm12);
    lea(CO1, ptr[CO1+LDC*1+0x0]);
    align(4);

L(l1064);
    mov(A, AO);
    sub(J, 0x10);
    cmp(J, 0x10);
    jge(l50, T_NEAR);
    align(4);

L(l1078);
    test(J, 0x8);
    jle(l1f48, T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x20);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x20);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(l15ac, T_NEAR);
    align(4);

L(l10a8);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l14a8, T_NEAR);
    sub(H, 0x1e);
    jle(l12c8, T_NEAR);
    align(4);

L(l1104);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l1104, T_NEAR);
    align(4);

L(l12c8);
    prefetcht0(byte[CO1+0x1c]);
    prefetcht0(byte[CO1+LDC*1+0x1c]);
    prefetcht0(byte[CO2+0x1c]);
    prefetcht0(byte[CO2+LDC*1+0x1c]);
    add(H, 0x1e);
    align(4);

L(l12e4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l12e4, T_NEAR);
    align(4);

L(l14a8);
    mov(H, K);
    and_(H, 0x3);
    je(l1524, T_NEAR);
    align(4);

L(l14b4);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x60]);
    vmovups(ymm1, yword[AO-0x40]);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    sub(AO, -32);
    sub(BO, -16);
    dec(H);
    jg(l14b4, T_NEAR);
    align(4);

L(l1524);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    vmovups(ymm0, yword[CO1+LDC*1+0x0]);
    vaddps(ymm9, ymm0, ymm9);
    vmovups(yword[CO1+LDC*1+0x0], ymm9);
    vmovups(ymm0, yword[CO2]);
    vaddps(ymm10, ymm0, ymm10);
    vmovups(yword[CO2], ymm10);
    vmovups(ymm0, yword[CO2+LDC*1]);
    vaddps(ymm11, ymm0, ymm11);
    vmovups(yword[CO2+LDC*1], ymm11);
    lea(CO1, ptr[CO1+LDC*4+0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(l10a8, T_NEAR);
    align(4);

L(l15ac);
    test(I, 0x2);
    jle(l1a84, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l19ac, T_NEAR);
    sub(H, 0x1e);
    jle(l17d8, T_NEAR);
    align(4);

L(l1614);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l1614, T_NEAR);
    align(4);

L(l17d8);
    prefetcht0(byte[CO1+0x1c]);
    prefetcht0(byte[CO1+LDC*1+0x1c]);
    add(H, 0x1e);
    align(4);

L(l17e8);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l17e8, T_NEAR);
    align(4);

L(l19ac);
    mov(H, K);
    and_(H, 0x3);
    je(l1a28, T_NEAR);
    align(4);

L(l19b8);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x60]);
    vmovups(ymm1, yword[AO-0x40]);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    sub(AO, -32);
    sub(BO, -8);
    dec(H);
    jg(l19b8, T_NEAR);
    align(4);

L(l1a28);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    vmovups(ymm0, yword[CO1+LDC*1+0x0]);
    vaddps(ymm9, ymm0, ymm9);
    vmovups(yword[CO1+LDC*1+0x0], ymm9);
    lea(CO1, ptr[CO1+LDC*2+0x0]);
    align(4);

L(l1a84);
    test(I, 0x1);
    jle(l1f44, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l1e80, T_NEAR);
    sub(H, 0x1e);
    jle(l1cb0, T_NEAR);
    align(4);

L(l1aec);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l1aec, T_NEAR);
    align(4);

L(l1cb0);
    prefetcht0(byte[CO1+0x1c]);
    add(H, 0x1e);
    align(4);

L(l1cbc);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x20]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO+0x20]);
    sub(AO, -128);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l1cbc, T_NEAR);
    align(4);

L(l1e80);
    mov(H, K);
    and_(H, 0x3);
    je(l1efc, T_NEAR);
    align(4);

L(l1e8c);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x60]);
    vmovups(ymm1, yword[AO-0x40]);
    vbroadcastf128(ymm2, xword[BO-0x7c]);
    sub(AO, -32);
    sub(BO, -4);
    dec(H);
    jg(l1e8c, T_NEAR);
    align(4);

L(l1efc);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(ymm0, yword[CO1+0x0]);
    vaddps(ymm8, ymm0, ymm8);
    vmovups(yword[CO1+0x0], ymm8);
    lea(CO1, ptr[CO1+LDC*1+0x0]);
    align(4);

L(l1f44);
    mov(A, AO);
    align(4);

L(l1f48);
    test(J, 0x4);
    jle(l2e30, T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x10);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x10);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(l2484, T_NEAR);
    align(4);

L(l1f78);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l2380, T_NEAR);
    sub(H, 0x1e);
    jle(l219c, T_NEAR);
    align(4);

L(l1fd4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l1fd4, T_NEAR);
    align(4);

L(l219c);
    prefetcht0(byte[CO1+0xc]);
    prefetcht0(byte[CO1+LDC*1+0xc]);
    prefetcht0(byte[CO2+0xc]);
    prefetcht0(byte[CO2+LDC*1+0xc]);
    add(H, 0x1e);
    align(4);

L(l21b8);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l21b8, T_NEAR);
    align(4);

L(l2380);
    mov(H, K);
    and_(H, 0x3);
    je(l23fc, T_NEAR);
    align(4);

L(l238c);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x70]);
    vmovups(ymm1, yword[AO-0x50]);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    sub(AO, -16);
    sub(BO, -16);
    dec(H);
    jg(l238c, T_NEAR);
    align(4);

L(l23fc);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1+0x0], xmm8);
    vmovups(xmm0, xword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovups(xword[CO1+LDC*1+0x0], xmm9);
    vmovups(xmm0, xword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovups(xword[CO2], xmm10);
    vmovups(xmm0, xword[CO2+LDC*1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovups(xword[CO2+LDC*1], xmm11);
    lea(CO1, ptr[CO1+LDC*4+0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(l1f78, T_NEAR);
    align(4);

L(l2484);
    test(I, 0x2);
    jle(l2964, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l288c, T_NEAR);
    sub(H, 0x1e);
    jle(l26b4, T_NEAR);
    align(4);

L(l24ec);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l24ec, T_NEAR);
    align(4);

L(l26b4);
    prefetcht0(byte[CO1+0xc]);
    prefetcht0(byte[CO1+LDC*1+0xc]);
    add(H, 0x1e);
    align(4);

L(l26c4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l26c4, T_NEAR);
    align(4);

L(l288c);
    mov(H, K);
    and_(H, 0x3);
    je(l2908, T_NEAR);
    align(4);

L(l2898);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x70]);
    vmovups(ymm1, yword[AO-0x50]);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    sub(AO, -16);
    sub(BO, -8);
    dec(H);
    jg(l2898, T_NEAR);
    align(4);

L(l2908);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1+0x0], xmm8);
    vmovups(xmm0, xword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovups(xword[CO1+LDC*1+0x0], xmm9);
    lea(CO1, ptr[CO1+LDC*2+0x0]);
    align(4);

L(l2964);
    test(I, 0x1);
    jle(l2e2c, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l2d68, T_NEAR);
    sub(H, 0x1e);
    jle(l2b94, T_NEAR);
    align(4);

L(l29cc);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l29cc, T_NEAR);
    align(4);

L(l2b94);
    prefetcht0(byte[CO1+0xc]);
    add(H, 0x1e);
    align(4);

L(l2ba0);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x50]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x30]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x40]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x20]);
    sub(AO, -64);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l2ba0, T_NEAR);
    align(4);

L(l2d68);
    mov(H, K);
    and_(H, 0x3);
    je(l2de4, T_NEAR);
    align(4);

L(l2d74);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x70]);
    vmovups(ymm1, yword[AO-0x50]);
    vbroadcastf128(ymm2, xword[BO-0x7c]);
    sub(AO, -16);
    sub(BO, -4);
    dec(H);
    jg(l2d74, T_NEAR);
    align(4);

L(l2de4);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovups(xmm0, xword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovups(xword[CO1+0x0], xmm8);
    lea(CO1, ptr[CO1+LDC*1+0x0]);
    align(4);

L(l2e2c);
    mov(A, AO);
    align(4);

L(l2e30);
    test(J, 0x2);
    jle(l3d18, T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x8);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x8);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(l336c, T_NEAR);
    align(4);

L(l2e60);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l3268, T_NEAR);
    sub(H, 0x1e);
    jle(l3084, T_NEAR);
    align(4);

L(l2ebc);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l2ebc, T_NEAR);
    align(4);

L(l3084);
    prefetcht0(byte[CO1+0x4]);
    prefetcht0(byte[CO1+LDC*1+0x4]);
    prefetcht0(byte[CO2+0x4]);
    prefetcht0(byte[CO2+LDC*1+0x4]);
    add(H, 0x1e);
    align(4);

L(l30a0);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l30a0, T_NEAR);
    align(4);

L(l3268);
    mov(H, K);
    and_(H, 0x3);
    je(l32e4, T_NEAR);
    align(4);

L(l3274);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x78]);
    vmovups(ymm1, yword[AO-0x58]);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    sub(AO, -8);
    sub(BO, -16);
    dec(H);
    jg(l3274, T_NEAR);
    align(4);

L(l32e4);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1+0x0], xmm8);
    vmovsd(xmm0, qword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovlps(qword[CO1+LDC*1+0x0], xmm9);
    vmovsd(xmm0, qword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovlps(qword[CO2], xmm10);
    vmovsd(xmm0, qword[CO2+LDC*1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovlps(qword[CO2+LDC*1], xmm11);
    lea(CO1, ptr[CO1+LDC*4+0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(l2e60, T_NEAR);
    align(4);

L(l336c);
    test(I, 0x2);
    jle(l384c, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l3774, T_NEAR);
    sub(H, 0x1e);
    jle(l359c, T_NEAR);
    align(4);

L(l33d4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l33d4, T_NEAR);
    align(4);

L(l359c);
    prefetcht0(byte[CO1+0x4]);
    prefetcht0(byte[CO1+LDC*1+0x4]);
    add(H, 0x1e);
    align(4);

L(l35ac);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l35ac, T_NEAR);
    align(4);

L(l3774);
    mov(H, K);
    and_(H, 0x3);
    je(l37f0, T_NEAR);
    align(4);

L(l3780);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x78]);
    vmovups(ymm1, yword[AO-0x58]);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    sub(AO, -8);
    sub(BO, -8);
    dec(H);
    jg(l3780, T_NEAR);
    align(4);

L(l37f0);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1+0x0], xmm8);
    vmovsd(xmm0, qword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovlps(qword[CO1+LDC*1+0x0], xmm9);
    lea(CO1, ptr[CO1+LDC*2+0x0]);
    align(4);

L(l384c);
    test(I, 0x1);
    jle(l3d14, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l3c50, T_NEAR);
    sub(H, 0x1e);
    jle(l3a7c, T_NEAR);
    align(4);

L(l38b4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l38b4, T_NEAR);
    align(4);

L(l3a7c);
    prefetcht0(byte[CO1+0x4]);
    add(H, 0x1e);
    align(4);

L(l3a88);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x68]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x48]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x60]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x40]);
    sub(AO, -32);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l3a88, T_NEAR);
    align(4);

L(l3c50);
    mov(H, K);
    and_(H, 0x3);
    je(l3ccc, T_NEAR);
    align(4);

L(l3c5c);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x78]);
    vmovups(ymm1, yword[AO-0x58]);
    vbroadcastf128(ymm2, xword[BO-0x7c]);
    sub(AO, -8);
    sub(BO, -4);
    dec(H);
    jg(l3c5c, T_NEAR);
    align(4);

L(l3ccc);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovsd(xmm0, qword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovlps(qword[CO1+0x0], xmm8);
    lea(CO1, ptr[CO1+LDC*1+0x0]);
    align(4);

L(l3d14);
    mov(A, AO);
    align(4);

L(l3d18);
    test(J, 0x1);
    jle(l4bfc, T_NEAR);
    mov(AA, K);
    imul(AA, AA, 0x4);
    add(AA, A);
    mov(CO1, C);
    add(C, 0x4);
    mov(BO, B);
    mov(I, N);
    cmp(I, 0x4);
    jl(l4250, T_NEAR);
    align(4);

L(l3d48);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l414c, T_NEAR);
    sub(H, 0x1e);
    jle(l3f6c, T_NEAR);
    align(4);

L(l3da4);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l3da4, T_NEAR);
    align(4);

L(l3f6c);
    prefetcht0(byte[CO1+0x0]);
    prefetcht0(byte[CO1+LDC*1+0x0]);
    prefetcht0(byte[CO2]);
    prefetcht0(byte[CO2+LDC*1]);
    add(H, 0x1e);
    align(4);

L(l3f84);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x50]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x40]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -64);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l3f84, T_NEAR);
    align(4);

L(l414c);
    mov(H, K);
    and_(H, 0x3);
    je(l41c8, T_NEAR);
    align(4);

L(l4158);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x7c]);
    vmovups(ymm1, yword[AO-0x5c]);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    sub(AO, -4);
    sub(BO, -16);
    dec(H);
    jg(l4158, T_NEAR);
    align(4);

L(l41c8);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1+0x0], xmm8);
    vmovss(xmm0, dword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovss(dword[CO1+LDC*1+0x0], xmm9);
    vmovss(xmm0, dword[CO2]);
    vaddps(xmm10, xmm0, xmm10);
    vmovss(dword[CO2], xmm10);
    vmovss(xmm0, dword[CO2+LDC*1]);
    vaddps(xmm11, xmm0, xmm11);
    vmovss(dword[CO2+LDC*1], xmm11);
    lea(CO1, ptr[CO1+LDC*4+0x0]);
    sub(I, 0x4);
    cmp(I, 0x4);
    jge(l3d48, T_NEAR);
    align(4);

L(l4250);
    test(I, 0x2);
    jle(l4730, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l4658, T_NEAR);
    sub(H, 0x1e);
    jle(l4480, T_NEAR);
    align(4);

L(l42b8);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l42b8, T_NEAR);
    align(4);

L(l4480);
    prefetcht0(byte[CO1+0x0]);
    prefetcht0(byte[CO1+LDC*1+0x0]);
    add(H, 0x1e);
    align(4);

L(l4490);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x68]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x60]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -32);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l4490, T_NEAR);
    align(4);

L(l4658);
    mov(H, K);
    and_(H, 0x3);
    je(l46d4, T_NEAR);
    align(4);

L(l4664);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x7c]);
    vmovups(ymm1, yword[AO-0x5c]);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    sub(AO, -4);
    sub(BO, -8);
    dec(H);
    jg(l4664, T_NEAR);
    align(4);

L(l46d4);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1+0x0], xmm8);
    vmovss(xmm0, dword[CO1+LDC*1+0x0]);
    vaddps(xmm9, xmm0, xmm9);
    vmovss(dword[CO1+LDC*1+0x0], xmm9);
    lea(CO1, ptr[CO1+LDC*2+0x0]);
    align(4);

L(l4730);
    test(I, 0x1);
    jle(l4bf8, T_NEAR);
    vxorps(ymm8, ymm8, ymm8);
    vbroadcastf128(ymm2, xword[BO-0x80]);
    vxorps(ymm9, ymm9, ymm9);
    vmovups(ymm0, yword[A-0x80]);
    vxorps(ymm10, ymm10, ymm10);
    vmovups(ymm1, yword[A-0x60]);
    vxorps(ymm11, ymm11, ymm11);
    lea(CO2, ptr[CO1+LDC*2+0x0]);
    vxorps(ymm12, ymm12, ymm12);
    vxorps(ymm13, ymm13, ymm13);
    vxorps(ymm14, ymm14, ymm14);
    vxorps(ymm15, ymm15, ymm15);
    mov(AO, A);
    mov(H, K);
    sar(H, 0x2);
    jle(l4b34, T_NEAR);
    sub(H, 0x1e);
    jle(l4960, T_NEAR);
    align(4);

L(l4798);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l4798, T_NEAR);
    align(4);

L(l4960);
    prefetcht0(byte[CO1+0x0]);
    add(H, 0x1e);
    align(4);

L(l496c);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x180]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    prefetcht0(byte[BO+0x100]);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x7c]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x7c]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x5c]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x1c0]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x78]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    prefetcht0(byte[AA-0x80]);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x78]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x58]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm2, ymm0);
    prefetcht0(byte[AO+0x200]);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm3, xword[BO-0x74]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm6, ymm2, ymm0);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm6, ymm2, ymm0);
    vmovups(ymm0, yword[AO-0x74]);
    vmulps(ymm7, ymm2, ymm1);
    vmovups(ymm1, yword[AO-0x54]);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    vmulps(ymm6, ymm3, ymm0);
    prefetcht0(byte[AO+0x240]);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm8, ymm8, ymm6);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm9, ymm9, ymm6);
    vbroadcastf128(ymm2, xword[BO-0x70]);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm3, ymm3, 0x1b);
    vmulps(ymm6, ymm3, ymm0);
    vmulps(ymm7, ymm3, ymm1);
    vaddps(ymm10, ymm10, ymm6);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm3, ymm3, 0xb1);
    add(AA, 0x4);
    vmulps(ymm6, ymm3, ymm0);
    vmovups(ymm0, yword[AO-0x70]);
    vmulps(ymm7, ymm3, ymm1);
    vmovups(ymm1, yword[AO-0x50]);
    sub(AO, -16);
    sub(BO, -16);
    vaddps(ymm11, ymm11, ymm6);
    vaddps(ymm15, ymm15, ymm7);
    sub(H, 0x1);
    jg(l496c, T_NEAR);
    align(4);

L(l4b34);
    mov(H, K);
    and_(H, 0x3);
    je(l4bb0, T_NEAR);
    align(4);

L(l4b40);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm8, ymm8, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm12, ymm12, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm9, ymm9, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm13, ymm13, ymm7);
    vpermilps(ymm2, ymm2, 0x1b);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm10, ymm10, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm14, ymm14, ymm7);
    vpermilps(ymm2, ymm2, 0xb1);
    vmulps(ymm7, ymm2, ymm0);
    vaddps(ymm11, ymm11, ymm7);
    vmulps(ymm7, ymm2, ymm1);
    vaddps(ymm15, ymm15, ymm7);
    vmovups(ymm0, yword[AO-0x7c]);
    vmovups(ymm1, yword[AO-0x5c]);
    vbroadcastf128(ymm2, xword[BO-0x7c]);
    sub(AO, -4);
    sub(BO, -4);
    dec(H);
    jg(l4b40, T_NEAR);
    align(4);

L(l4bb0);
    vblendps(ymm0, ymm8, ymm9, 0xaa);
    vblendps(ymm1, ymm8, ymm9, 0x55);
    vblendps(ymm2, ymm10, ymm11, 0xaa);
    vblendps(ymm3, ymm10, ymm11, 0x55);
    vblendps(ymm8, ymm0, ymm2, 0xcc);
    vblendps(ymm9, ymm1, ymm3, 0xcc);
    vblendps(ymm10, ymm0, ymm2, 0x33);
    vblendps(ymm11, ymm1, ymm3, 0x33);
    vmovss(xmm0, dword[CO1+0x0]);
    vaddps(xmm8, xmm0, xmm8);
    vmovss(dword[CO1+0x0], xmm8);
    lea(CO1, ptr[CO1+LDC*1+0x0]);
    align(4);

L(l4bf8);
    mov(A, AO);
    align(4);

L(l4bfc);

    postamble();
}
outLocalLabel();

#undef M
#undef N
#undef K
#undef A
#undef B
#undef C
#undef LDC
#undef AA
#undef I
#undef J
#undef H
#undef AO
#undef BO
#undef CO1
#undef CO2
#ifdef _WIN32
#undef OLD_A
#undef OLD_B
#endif
#undef OLD_C
#undef OLD_LDC
}

}
}
}
