/*******************************************************************************
* Copyright 2019 Intel Corporation
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*******************************************************************************/

#include "common_f32.hpp"
#include "jit_generator.hpp"

namespace mkldnn {
namespace impl {
namespace cpu {

jit_avx2_f32_copy_an_kern::jit_avx2_f32_copy_an_kern() :
    jit_generator(nullptr, F32_COPY_KERNEL_CODE_SIZE) {

#ifndef _WIN32
#define M   rdi
#define N   rsi
#define A   rdx
#define LDA rcx
#define ALPHA   r8
#define B   r9

#define I   rax
#define A1  r10
#define A2  r8
#define LDA3    r11

#else
#define M   rcx
#define N   rdx
#define A   r8
#define LDA r9
#define ALPHA   rsi
#define B   rdi
#define I   rax
#define A1  rsi
#define A2  r10
#define LDA3    r11

#define ARG_ALPHA   40+stacksize+rsp
#define ARG_B       48+stacksize+rsp

#endif

inLocalLabel();
{

Xbyak::Label l1018;
Xbyak::Label l1048;
Xbyak::Label l104c;
Xbyak::Label l1070;
Xbyak::Label l1110;
Xbyak::Label l1164;
Xbyak::Label l1198;
Xbyak::Label l11b8;
Xbyak::Label l11bc;
Xbyak::Label l11e0;
Xbyak::Label l127c;
Xbyak::Label l12d0;
Xbyak::Label l1304;
Xbyak::Label l1324;
Xbyak::Label l1328;
Xbyak::Label l134c;
Xbyak::Label l13e8;
Xbyak::Label l143c;
Xbyak::Label l1470;
Xbyak::Label l1490;
Xbyak::Label l1494;
Xbyak::Label l14b8;
Xbyak::Label l1554;
Xbyak::Label l15a8;
Xbyak::Label l15dc;
Xbyak::Label l15fc;
Xbyak::Label l1600;
Xbyak::Label l1608;
Xbyak::Label l1614;
Xbyak::Label l162c;
Xbyak::Label l1808;
Xbyak::Label l18f4;
Xbyak::Label l196c;
Xbyak::Label l19ac;
Xbyak::Label l19bc;
Xbyak::Label l19e0;
Xbyak::Label l1b1c;
Xbyak::Label l1bbc;
Xbyak::Label l1c10;
Xbyak::Label l1c40;
Xbyak::Label l1c44;
Xbyak::Label l1c68;
Xbyak::Label l1d08;
Xbyak::Label l1d5c;
Xbyak::Label l1d90;
Xbyak::Label l1db0;
Xbyak::Label l1db4;
Xbyak::Label l1dd8;
Xbyak::Label l1e74;
Xbyak::Label l1e8;
Xbyak::Label l1ec8;
Xbyak::Label l1efc;
Xbyak::Label l1f1c;
Xbyak::Label l1f20;
Xbyak::Label l1f44;
Xbyak::Label l1fe0;
Xbyak::Label l2034;
Xbyak::Label l2068;
Xbyak::Label l2088;
Xbyak::Label l208c;
Xbyak::Label l20b0;
Xbyak::Label l214c;
Xbyak::Label l21a0;
Xbyak::Label l21d4;
Xbyak::Label l21f4;
Xbyak::Label l21f8;
Xbyak::Label l2a4;
Xbyak::Label l304;
Xbyak::Label l338;
Xbyak::Label l348;
Xbyak::Label l36c;
Xbyak::Label l468;
Xbyak::Label l4e4;
Xbyak::Label l528;
Xbyak::Label l54;
Xbyak::Label l550;
Xbyak::Label l554;
Xbyak::Label l574;
Xbyak::Label l5f0;
Xbyak::Label l634;
Xbyak::Label l660;
Xbyak::Label l67c;
Xbyak::Label l680;
Xbyak::Label l6a0;
Xbyak::Label l6c;
Xbyak::Label l718;
Xbyak::Label l75c;
Xbyak::Label l788;
Xbyak::Label l7a4;
Xbyak::Label l7a8;
Xbyak::Label l7c8;
Xbyak::Label l840;
Xbyak::Label l884;
Xbyak::Label l8b0;
Xbyak::Label l8cc;
Xbyak::Label l8d0;
Xbyak::Label l8f0;
Xbyak::Label l968;
Xbyak::Label l9ac;
Xbyak::Label l9d8;
Xbyak::Label l9f4;
Xbyak::Label l9f8;
Xbyak::Label la00;
Xbyak::Label la1c;
Xbyak::Label la34;
Xbyak::Label lc10;
Xbyak::Label lcfc;
Xbyak::Label ld74;
Xbyak::Label ldb4;
Xbyak::Label ldc4;
Xbyak::Label lde8;
Xbyak::Label lf24;
Xbyak::Label lfc4;

    preamble();
#ifdef _WIN32
    auto stacksize = get_size_of_abi_save_regs();
    mov(ALPHA, ptr[ARG_ALPHA]);
    mov(B, ptr[ARG_B]);
#endif

    mov(M, qword[M]);
    mov(N, qword[N]);
    mov(LDA, qword[LDA]);
    sub(A, -128);
    sub(B, -128);
    shl(LDA, 0x2);
    lea(LDA3, ptr[LDA+LDA*2]);
    vbroadcastss(ymm6, dword[ALPHA]);
    vpcmpeqb(xmm3, xmm3, xmm3);
    vpsrld(xmm3, xmm3, 0x17);
    vpslld(xmm3, xmm3, 0x19);
    vpsrld(xmm3, xmm3, 0x2);
    vpcmpeqb(xmm4, xmm4, xmm4);
    vpslld(xmm4, xmm4, 0x1f);
    vperm2f128(ymm4, ymm4, ymm4, 0x20);
    vucomiss(xmm6, xmm3);
    jne(la00, T_NEAR);
    cmp(N, 0x18);
    jl(l348, T_NEAR);
    align(4);

L(l54);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x60);
    mov(I, M);
    sar(I, 0x3);
    jle(l1e8, T_NEAR);
    align(4);

L(l6c);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2-0x40]);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmovups(yword[B+0x160], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vmovups(yword[B+0x180], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x40]);
    vmovups(yword[B+0x1a0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmovups(yword[B+0x1c0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vmovups(yword[B+0x1e0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x40]);
    vmovups(yword[B+0x200], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmovups(yword[B+0x220], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vmovups(yword[B+0x240], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x40]);
    vmovups(yword[B+0x260], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -768);
    dec(I);
    jg(l6c, T_NEAR);
    align(4);

L(l1e8);
    test(M, 0x4);
    jle(l2a4, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vmovups(yword[B+0xe0], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -384);
    align(4);

L(l2a4);
    test(M, 0x2);
    jle(l304, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmovups(yword[B+0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -192);
    align(4);

L(l304);
    test(M, 0x1);
    jle(l338, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmovups(yword[B-0x40], ymm0);
    sub(B, -96);
    align(4);

L(l338);
    sub(N, 0x18);
    cmp(N, 0x18);
    jge(l54, T_NEAR);
    align(4);

L(l348);
    cmp(N, 0x10);
    jl(l554, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x40);
    mov(I, M);
    sar(I, 0x3);
    jle(l468, T_NEAR);
    align(4);

L(l36c);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vmovups(yword[B+0x160], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -512);
    dec(I);
    jg(l36c, T_NEAR);
    align(4);

L(l468);
    test(M, 0x4);
    jle(l4e4, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -256);
    align(4);

L(l4e4);
    test(M, 0x2);
    jle(l528, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -128);
    align(4);

L(l528);
    test(M, 0x1);
    jle(l550, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmovups(yword[B-0x60], ymm0);
    sub(B, -64);
    align(4);

L(l550);
    sub(N, 0x10);
    align(4);

L(l554);
    cmp(N, 0x8);
    jl(l680, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x20);
    mov(I, M);
    sar(I, 0x3);
    jle(l5f0, T_NEAR);
    align(4);

L(l574);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -256);
    dec(I);
    jg(l574, T_NEAR);
    align(4);

L(l5f0);
    test(M, 0x4);
    jle(l634, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -128);
    align(4);

L(l634);
    test(M, 0x2);
    jle(l660, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmovups(yword[B-0x60], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -64);
    align(4);

L(l660);
    test(M, 0x1);
    jle(l67c, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmovups(yword[B-0x80], ymm0);
    sub(B, -32);
    align(4);

L(l67c);
    sub(N, 0x8);
    align(4);

L(l680);
    cmp(N, 0x4);
    jl(l7a8, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x10);
    mov(I, M);
    sar(I, 0x3);
    jle(l718, T_NEAR);
    align(4);

L(l6a0);
    vmovups(xmm0, xword[A1-0x80]);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vmovups(xword[B-0x50], xmm0);
    vmovups(xmm0, xword[A2-0x80]);
    vmovups(xword[B-0x40], xmm0);
    vmovups(xmm0, xword[A2+LDA*1-0x80]);
    vmovups(xword[B-0x30], xmm0);
    vmovups(xmm0, xword[A2+LDA*2-0x80]);
    vmovups(xword[B-0x20], xmm0);
    vmovups(xmm0, xword[A2+LDA3*1-0x80]);
    vmovups(xword[B-0x10], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -128);
    dec(I);
    jg(l6a0, T_NEAR);
    align(4);

L(l718);
    test(M, 0x4);
    jle(l75c, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vmovups(xword[B-0x50], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -64);
    align(4);

L(l75c);
    test(M, 0x2);
    jle(l788, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmovups(xword[B-0x70], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -32);
    align(4);

L(l788);
    test(M, 0x1);
    jle(l7a4, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmovups(xword[B-0x80], xmm0);
    sub(B, -16);
    align(4);

L(l7a4);
    sub(N, 0x4);
    align(4);

L(l7a8);
    cmp(N, 0x2);
    jl(l8d0, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x8);
    mov(I, M);
    sar(I, 0x3);
    jle(l840, T_NEAR);
    align(4);

L(l7c8);
    vmovsd(xmm0, qword[A1-0x80]);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vmovlps(qword[B-0x68], xmm0);
    vmovsd(xmm0, qword[A2-0x80]);
    vmovlps(qword[B-0x60], xmm0);
    vmovsd(xmm0, qword[A2+LDA*1-0x80]);
    vmovlps(qword[B-0x58], xmm0);
    vmovsd(xmm0, qword[A2+LDA*2-0x80]);
    vmovlps(qword[B-0x50], xmm0);
    vmovsd(xmm0, qword[A2+LDA3*1-0x80]);
    vmovlps(qword[B-0x48], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -64);
    dec(I);
    jg(l7c8, T_NEAR);
    align(4);

L(l840);
    test(M, 0x4);
    jle(l884, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vmovlps(qword[B-0x68], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -32);
    align(4);

L(l884);
    test(M, 0x2);
    jle(l8b0, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmovlps(qword[B-0x78], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -16);
    align(4);

L(l8b0);
    test(M, 0x1);
    jle(l8cc, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmovlps(qword[B-0x80], xmm0);
    sub(B, -8);
    align(4);

L(l8cc);
    sub(N, 0x2);
    align(4);

L(l8d0);
    cmp(N, 0x1);
    jl(l9f8, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x4);
    mov(I, M);
    sar(I, 0x3);
    jle(l968, T_NEAR);
    align(4);

L(l8f0);
    vmovss(xmm0, dword[A1-0x80]);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vmovss(dword[B-0x74], xmm0);
    vmovss(xmm0, dword[A2-0x80]);
    vmovss(dword[B-0x70], xmm0);
    vmovss(xmm0, dword[A2+LDA*1-0x80]);
    vmovss(dword[B-0x6c], xmm0);
    vmovss(xmm0, dword[A2+LDA*2-0x80]);
    vmovss(dword[B-0x68], xmm0);
    vmovss(xmm0, dword[A2+LDA3*1-0x80]);
    vmovss(dword[B-0x64], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -32);
    dec(I);
    jg(l8f0, T_NEAR);
    align(4);

L(l968);
    test(M, 0x4);
    jle(l9ac, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vmovss(dword[B-0x74], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -16);
    align(4);

L(l9ac);
    test(M, 0x2);
    jle(l9d8, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmovss(dword[B-0x7c], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -8);
    align(4);

L(l9d8);
    test(M, 0x1);
    jle(l9f4, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmovss(dword[B-0x80], xmm0);
    sub(B, -4);
    align(4);

L(l9f4);
    sub(N, 0x1);
    align(4);

L(l9f8);
    jmp(l21f8, T_NEAR);
    align(4);

L(la00);
    vxorps(xmm3, xmm3, xmm4);
    vucomiss(xmm6, xmm3);
    jne(l1608, T_NEAR);
    vmovaps(ymm6, ymm4);
    cmp(N, 0x18);
    jl(ldc4, T_NEAR);
    align(4);

L(la1c);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x60);
    mov(I, M);
    sar(I, 0x3);
    jle(lc10, T_NEAR);
    align(4);

L(la34);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x160], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x180], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1a0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1c0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1e0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x200], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x220], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x240], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x260], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -768);
    dec(I);
    jg(la34, T_NEAR);
    align(4);

L(lc10);
    test(M, 0x4);
    jle(lcfc, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -384);
    align(4);

L(lcfc);
    test(M, 0x2);
    jle(ld74, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -192);
    align(4);

L(ld74);
    test(M, 0x1);
    jle(ldb4, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    sub(B, -96);
    align(4);

L(ldb4);
    sub(N, 0x18);
    cmp(N, 0x18);
    jge(la1c, T_NEAR);
    align(4);

L(ldc4);
    cmp(N, 0x10);
    jl(l104c, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x40);
    mov(I, M);
    sar(I, 0x3);
    jle(lf24, T_NEAR);
    align(4);

L(lde8);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x160], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -512);
    dec(I);
    jg(lde8, T_NEAR);
    align(4);

L(lf24);
    test(M, 0x4);
    jle(lfc4, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -256);
    align(4);

L(lfc4);
    test(M, 0x2);
    jle(l1018, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -128);
    align(4);

L(l1018);
    test(M, 0x1);
    jle(l1048, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    sub(B, -64);
    align(4);

L(l1048);
    sub(N, 0x10);
    align(4);

L(l104c);
    cmp(N, 0x8);
    jl(l11bc, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x20);
    mov(I, M);
    sar(I, 0x3);
    jle(l1110, T_NEAR);
    align(4);

L(l1070);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -256);
    dec(I);
    jg(l1070, T_NEAR);
    align(4);

L(l1110);
    test(M, 0x4);
    jle(l1164, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -128);
    align(4);

L(l1164);
    test(M, 0x2);
    jle(l1198, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -64);
    align(4);

L(l1198);
    test(M, 0x1);
    jle(l11b8, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vxorps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    sub(B, -32);
    align(4);

L(l11b8);
    sub(N, 0x8);
    align(4);

L(l11bc);
    cmp(N, 0x4);
    jl(l1328, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x10);
    mov(I, M);
    sar(I, 0x3);
    jle(l127c, T_NEAR);
    align(4);

L(l11e0);
    vmovups(xmm0, xword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x50], xmm0);
    vmovups(xmm0, xword[A2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x40], xmm0);
    vmovups(xmm0, xword[A2+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x30], xmm0);
    vmovups(xmm0, xword[A2+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x20], xmm0);
    vmovups(xmm0, xword[A2+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x10], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -128);
    dec(I);
    jg(l11e0, T_NEAR);
    align(4);

L(l127c);
    test(M, 0x4);
    jle(l12d0, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x50], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -64);
    align(4);

L(l12d0);
    test(M, 0x2);
    jle(l1304, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -32);
    align(4);

L(l1304);
    test(M, 0x1);
    jle(l1324, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    sub(B, -16);
    align(4);

L(l1324);
    sub(N, 0x4);
    align(4);

L(l1328);
    cmp(N, 0x2);
    jl(l1494, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x8);
    mov(I, M);
    sar(I, 0x3);
    jle(l13e8, T_NEAR);
    align(4);

L(l134c);
    vmovsd(xmm0, qword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x68], xmm0);
    vmovsd(xmm0, qword[A2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x60], xmm0);
    vmovsd(xmm0, qword[A2+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x58], xmm0);
    vmovsd(xmm0, qword[A2+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x50], xmm0);
    vmovsd(xmm0, qword[A2+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x48], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -64);
    dec(I);
    jg(l134c, T_NEAR);
    align(4);

L(l13e8);
    test(M, 0x4);
    jle(l143c, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x68], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -32);
    align(4);

L(l143c);
    test(M, 0x2);
    jle(l1470, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -16);
    align(4);

L(l1470);
    test(M, 0x1);
    jle(l1490, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    sub(B, -8);
    align(4);

L(l1490);
    sub(N, 0x2);
    align(4);

L(l1494);
    cmp(N, 0x1);
    jl(l1600, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x4);
    mov(I, M);
    sar(I, 0x3);
    jle(l1554, T_NEAR);
    align(4);

L(l14b8);
    vmovss(xmm0, dword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x74], xmm0);
    vmovss(xmm0, dword[A2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x70], xmm0);
    vmovss(xmm0, dword[A2+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x6c], xmm0);
    vmovss(xmm0, dword[A2+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x68], xmm0);
    vmovss(xmm0, dword[A2+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x64], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -32);
    dec(I);
    jg(l14b8, T_NEAR);
    align(4);

L(l1554);
    test(M, 0x4);
    jle(l15a8, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x74], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -16);
    align(4);

L(l15a8);
    test(M, 0x2);
    jle(l15dc, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -8);
    align(4);

L(l15dc);
    test(M, 0x1);
    jle(l15fc, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vxorps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    sub(B, -4);
    align(4);

L(l15fc);
    sub(N, 0x1);
    align(4);

L(l1600);
    jmp(l21f8, T_NEAR);
    align(4);

L(l1608);
    cmp(N, 0x18);
    jl(l19bc, T_NEAR);
    align(4);

L(l1614);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x60);
    mov(I, M);
    sar(I, 0x3);
    jle(l1808, T_NEAR);
    align(4);

L(l162c);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x160], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x180], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1a0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1c0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x1e0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x200], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x220], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x240], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x260], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -768);
    dec(I);
    jg(l162c, T_NEAR);
    align(4);

L(l1808);
    test(M, 0x4);
    jle(l18f4, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -384);
    align(4);

L(l18f4);
    test(M, 0x2);
    jle(l196c, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -192);
    align(4);

L(l196c);
    test(M, 0x1);
    jle(l19ac, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1-0x40]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    sub(B, -96);
    align(4);

L(l19ac);
    sub(N, 0x18);
    cmp(N, 0x18);
    jge(l1614, T_NEAR);
    align(4);

L(l19bc);
    cmp(N, 0x10);
    jl(l1c44, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x40);
    mov(I, M);
    sar(I, 0x3);
    jle(l1b1c, T_NEAR);
    align(4);

L(l19e0);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x80], ymm0);
    vmovups(ymm0, yword[A2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xa0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xc0], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0xe0], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x100], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x120], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x140], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x160], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -512);
    dec(I);
    jg(l19e0, T_NEAR);
    align(4);

L(l1b1c);
    test(M, 0x4);
    jle(l1bbc, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -256);
    align(4);

L(l1bbc);
    test(M, 0x2);
    jle(l1c10, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -128);
    align(4);

L(l1c10);
    test(M, 0x1);
    jle(l1c40, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1-0x60]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    sub(B, -64);
    align(4);

L(l1c40);
    sub(N, 0x10);
    align(4);

L(l1c44);
    cmp(N, 0x8);
    jl(l1db4, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x20);
    mov(I, M);
    sar(I, 0x3);
    jle(l1d08, T_NEAR);
    align(4);

L(l1c68);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    vmovups(ymm0, yword[A2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B], ymm0);
    vmovups(ymm0, yword[A2+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x20], ymm0);
    vmovups(ymm0, yword[A2+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x40], ymm0);
    vmovups(ymm0, yword[A2+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B+0x60], ymm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -256);
    dec(I);
    jg(l1c68, T_NEAR);
    align(4);

L(l1d08);
    test(M, 0x4);
    jle(l1d5c, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    vmovups(ymm0, yword[A1+LDA*2-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x40], ymm0);
    vmovups(ymm0, yword[A1+LDA3*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x20], ymm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -128);
    align(4);

L(l1d5c);
    test(M, 0x2);
    jle(l1d90, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    vmovups(ymm0, yword[A1+LDA*1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x60], ymm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -64);
    align(4);

L(l1d90);
    test(M, 0x1);
    jle(l1db0, T_NEAR);
    vmovups(ymm0, yword[A1-0x80]);
    vmulps(ymm0, ymm6, ymm0);
    vmovups(yword[B-0x80], ymm0);
    sub(B, -32);
    align(4);

L(l1db0);
    sub(N, 0x8);
    align(4);

L(l1db4);
    cmp(N, 0x4);
    jl(l1f20, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x10);
    mov(I, M);
    sar(I, 0x3);
    jle(l1e74, T_NEAR);
    align(4);

L(l1dd8);
    vmovups(xmm0, xword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x50], xmm0);
    vmovups(xmm0, xword[A2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x40], xmm0);
    vmovups(xmm0, xword[A2+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x30], xmm0);
    vmovups(xmm0, xword[A2+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x20], xmm0);
    vmovups(xmm0, xword[A2+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x10], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -128);
    dec(I);
    jg(l1dd8, T_NEAR);
    align(4);

L(l1e74);
    test(M, 0x4);
    jle(l1ec8, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    vmovups(xmm0, xword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x60], xmm0);
    vmovups(xmm0, xword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x50], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -64);
    align(4);

L(l1ec8);
    test(M, 0x2);
    jle(l1efc, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    vmovups(xmm0, xword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x70], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -32);
    align(4);

L(l1efc);
    test(M, 0x1);
    jle(l1f1c, T_NEAR);
    vmovups(xmm0, xword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovups(xword[B-0x80], xmm0);
    sub(B, -16);
    align(4);

L(l1f1c);
    sub(N, 0x4);
    align(4);

L(l1f20);
    cmp(N, 0x2);
    jl(l208c, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x8);
    mov(I, M);
    sar(I, 0x3);
    jle(l1fe0, T_NEAR);
    align(4);

L(l1f44);
    vmovsd(xmm0, qword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x68], xmm0);
    vmovsd(xmm0, qword[A2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x60], xmm0);
    vmovsd(xmm0, qword[A2+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x58], xmm0);
    vmovsd(xmm0, qword[A2+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x50], xmm0);
    vmovsd(xmm0, qword[A2+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x48], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -64);
    dec(I);
    jg(l1f44, T_NEAR);
    align(4);

L(l1fe0);
    test(M, 0x4);
    jle(l2034, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    vmovsd(xmm0, qword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x70], xmm0);
    vmovsd(xmm0, qword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x68], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -32);
    align(4);

L(l2034);
    test(M, 0x2);
    jle(l2068, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    vmovsd(xmm0, qword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x78], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -16);
    align(4);

L(l2068);
    test(M, 0x1);
    jle(l2088, T_NEAR);
    vmovsd(xmm0, qword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovlps(qword[B-0x80], xmm0);
    sub(B, -8);
    align(4);

L(l2088);
    sub(N, 0x2);
    align(4);

L(l208c);
    cmp(N, 0x1);
    jl(l21f8, T_NEAR);
    mov(A1, A);
    lea(A2, ptr[A1+LDA*4]);
    add(A, 0x4);
    mov(I, M);
    sar(I, 0x3);
    jle(l214c, T_NEAR);
    align(4);

L(l20b0);
    vmovss(xmm0, dword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x74], xmm0);
    vmovss(xmm0, dword[A2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x70], xmm0);
    vmovss(xmm0, dword[A2+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x6c], xmm0);
    vmovss(xmm0, dword[A2+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x68], xmm0);
    vmovss(xmm0, dword[A2+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x64], xmm0);
    lea(A1, ptr[A1+LDA*8]);
    lea(A2, ptr[A2+LDA*8]);
    sub(B, -32);
    dec(I);
    jg(l20b0, T_NEAR);
    align(4);

L(l214c);
    test(M, 0x4);
    jle(l21a0, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    vmovss(xmm0, dword[A1+LDA*2-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x78], xmm0);
    vmovss(xmm0, dword[A1+LDA3*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x74], xmm0);
    lea(A1, ptr[A1+LDA*4]);
    sub(B, -16);
    align(4);

L(l21a0);
    test(M, 0x2);
    jle(l21d4, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    vmovss(xmm0, dword[A1+LDA*1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x7c], xmm0);
    lea(A1, ptr[A1+LDA*2]);
    sub(B, -8);
    align(4);

L(l21d4);
    test(M, 0x1);
    jle(l21f4, T_NEAR);
    vmovss(xmm0, dword[A1-0x80]);
    vmulps(xmm0, xmm6, xmm0);
    vmovss(dword[B-0x80], xmm0);
    sub(B, -4);
    align(4);

L(l21f4);
    sub(N, 0x1);
    align(4);

L(l21f8);

    postamble();
}
outLocalLabel();

#undef M
#undef N
#undef A
#undef LDA
#undef ALPHA
#undef B
#undef I
#undef A1
#undef A2
#undef LDA3
#ifdef _WIN32
#undef ARG_ALPHA
#undef ARG_B
#endif
}

}
}
}
