#!/bin/bash
set -e

cflags=$(dpkg-buildflags --get CFLAGS)
ldflags=$(dpkg-buildflags --get LDFLAGS)

compile_and_test () {
	local _cc=$1
	local _src=$2
	echo $_cc ${cflags[@]} ${ldflags[@]} $_src -lmkldnn -o tester
	$_cc ${cflags[@]} ${ldflags[@]} $2 -lmkldnn -o tester
	./tester
	rm tester || true
}

dump_test_command () {
	local _cc=$1
	local _src=$2
	cat >> debian/tests/control <<EOF
Test-Command: $_cc \$(dpkg-buildflags --get CFLAGS) \$(dpkg-buildflags --get LDFLAGS) $_src -lmkldnn -o tester; ./tester
Depends: gcc, g++, clang, libc6-dev, libmkldnn-dev
Restrictions: allow-stderr

EOF
}

tests=(
examples/cpu_cnn_inference_f32.c
examples/cpu_cnn_inference_f32.cpp
#examples/cpu_cnn_inference_int8.cpp
#examples/cpu_cnn_training_bf16.cpp
examples/cpu_cnn_training_f32.c
examples/cpu_cnn_training_f32.cpp
examples/cpu_getting_started.cpp
examples/cpu_memory_format_propagation.cpp
examples/cpu_performance_profiling.cpp
examples/cpu_rnn_inference_f32.cpp
#examples/cpu_rnn_inference_int8.cpp
examples/cpu_rnn_training_f32.cpp
#examples/gpu_getting_started.c
#examples/gpu_getting_started.cpp
#examples/gpu_opencl_interop.cpp
)

case "$1" in
	test)
		for compiler in g++ clang++; do
			for t in ${tests[@]}; do
				compile_and_test $compiler $t
			done
		done
		;;
	generate)
		truncate -s0 debian/tests/control
		for compiler in g++ clang++; do
			for t in ${tests[@]}; do
				dump_test_command $compiler $t
			done
		done
		;;
	*)
		echo ???
		;;
esac
