---
date: 2023-10-02
authors: [squidfunk, alexvoss]
categories:
  - General
---

# Sunsetting Gitter: Towards Efficient Community Engagement

__As we're starting to build a team around Material for MkDocs, we've decided to
sunset and archive our [Gitter] channel on October 13, 2023 in favor of
[GitHub Discussions].__

As part of our efforts to improve the processes for maintaining Material for
MkDocs and for supporting the community, we have reviewed the use of different
communication channels. At the moment, both [Gitter] and [GitHub Discussions]
allow to ask the community for support and to discuss ideas and issues. In the
past weeks, we have begun to question whether this duplication is in the best
interest of our project. This post explains the rationale behind our decision.

  [our sponsors]: ../../insiders/index.md#how-to-become-a-sponsor
  [Gitter]: https://gitter.im/squidfunk/mkdocs-material
  [GitHub discussions]: https://github.com/squidfunk/mkdocs-material/discussions

<!-- more -->

## The Constraints of Gitter

In the first years of Material for MkDocs, [Gitter] served as a helpful platform
for quick community interactions and questions. However, there are some inherent
constraints that necessitated a shift. Here's a breakdown of the challenges we
encountered:

1. __Thread utilization__ –
   Even with the introduction of threads, many Gitter users were reticent to
   use them, leading to cluttered and disconnected conversations, making it
    difficult to follow.

2. __Search and discovery__ –
   Gitter's structure and interface makes it cumbersome to search for and
   retrieve past messages, resulting in lost insights and repeated conversations.

1. __User interface__ –
   After the acquisition by [Element], the user interface of Gitter has
   experienced a severe decline, becoming more complicated, less intuitive and
   user-friendly.

1. __Access mandate__ –
   The necessity for users to grant access to their GitHub accounts to use
   Gitter posed an unnecessary access barrier and potential security concerns.

  [Element]: https://element.io/blog/gitter-is-joining-element/

## GitHub Discussions

Thankfully, [GitHub Discussions] emerged and continues to evolve to be a much
better alternative, eliminating many of Gitter's constraints and offering
enhanced functionality:

1. __Threaded conversations__ –
   GitHub Discussions supports structured, threaded conversations, ensuring
   discussions are coherent, contextual, and easy to follow for everyone.

2. __Integration and linking__ –
   the platform facilitates seamless linking to other discussions, issues, code,
   and much more, enriching conversations and providing comprehensive context.

3. __A unified platform__ –
   GitHub acts as a one-stop shop for support, allowing users to access varied
   resources and support channels in one place, greatly improving user
   experience.

4. __Discoverability__ –
   GitHub Discussions are easily searchable and allow for categorization,
   preventing loss of valuable insights and fostering knowledge sharing.

## Conclusion

Sunsetting [Gitter] is a leap towards creating more efficient, user-friendly,
and enriched community interactions. By consolidating communication to
[GitHub Discussions], we seek to mitigate the fragmentation of information,
ease the user journey, and fortify the bonds within our community.

This concentrated approach enables us to provide consistent, fast and quality
support to our users. In the past, the nature of queries raised on Gitter
typically necessitated supplementary information or reproductions, prompting us
to advise users to initiate a discussion subsequently. The shift to a
centralized discussion forum is designed to simplify and accelerate this
procedure, ensuring swift and efficient resolutions for our community. It is a
testament to our ongoing commitment to support the community that helps Material
for MkDocs flourish.

We are confident that this streamlined approach will spur more
fruitful discussions, innovative ideas, and collective growth, and we are
excited to continue our journey with the unwavering support and active
participation of our community.

