#!/usr/bin/env python

# This file is part of mkchromecast.

"""
Google Cast device has to point out to http://ip:5000/stream
"""

import mkchromecast.__init__
from mkchromecast.audiodevices import *
import mkchromecast.colors as colors
from mkchromecast.config import *
from mkchromecast.preferences import ConfigSectionMap
import psutil
import pickle
import sys
import time
from functools import partial
from subprocess import Popen, PIPE
from flask import Flask, Response, request
import multiprocessing
import threading
import os
from os import getpid

"""
Configparser is imported differently in Python3
"""
try:
    import ConfigParser
except ImportError:
    import configparser as ConfigParser # This is for Python3

backends_dict = {}


"""
In this block we check variables from __init__.py
"""
tray = mkchromecast.__init__.tray
chunk_size = mkchromecast.__init__.chunk_size
if debug == True:
    print(':::ffmpeg::: chunk_size: ', chunk_size)
debug = mkchromecast.__init__.debug
config = ConfigParser.RawConfigParser()
configurations = config_manager()    # Class from mkchromecast.config
configf = configurations.configf
appendtourl = 'stream'

try:
    youtubeurl = mkchromecast.__init__.youtubeurl
except AttributeError:
    youtubeurl = None

# This is to take the youtube URL
if youtubeurl != None:
    print(colors.options('The Youtube URL chosen:')+' '+youtubeurl)

    try:
        import urlparse
        url_data = urlparse.urlparse(youtubeurl)
        query = urlparse.parse_qs(url_data.query)
    except ImportError:
        import urllib.parse
        url_data = urllib.parse.urlparse(youtubeurl)
        query = urllib.parse.parse_qs(url_data.query)
    video = query['v'][0]
    print(colors.options('Playing video:')+' '+video)
    command = [
        'youtube-dl',
        '-o',
        '-',
        youtubeurl
        ]
    mtype = 'audio/mp4'
else:
    if os.path.exists(configf) and tray == True:
        configurations.chk_config()
        config.read(configf)
        backend = ConfigSectionMap('settings')['backend']
        backends_dict[backend] = backend
        codec= ConfigSectionMap('settings')['codec']
        bitrate = ConfigSectionMap('settings')['bitrate']
        samplerate= ConfigSectionMap('settings')['samplerate']
        if debug == True:
            print(':::ffmpeg::: tray ='+str(tray))
            print(colors.warning('Configuration file exist'))
            print(colors.warning('Using defaults set there'))
            print(backend,codec,bitrate,samplerate)
    else:
        backend = mkchromecast.__init__.backend
        backends_dict[backend] = backend
        codec = mkchromecast.__init__.codec
        bitrate = str(mkchromecast.__init__.bitrate)
        samplerate = str(mkchromecast.__init__.samplerate)

    backends = [
        'ffmpeg',
        'avconv',
        'parec'
        ]
    if tray == True and backend in backends:
        import os, getpass
        import subprocess
        USER = getpass.getuser()
        PATH = './bin:./nodejs/bin:/Users/' \
        +str(USER) \
        +'/bin:/usr/local/bin:/usr/local/sbin:/usr/bin:/bin:/usr/sbin:/sbin:/opt/X11/bin:/usr/X11/bin:/usr/games:' \
        +os.environ['PATH']

        iterate = PATH.split(':')
        for item in iterate:
            verifyif = str(item+'/'+backend)
            if os.path.exists(verifyif) == False:
                continue
            else:
                backends_dict[verifyif] = backend
                backend = verifyif
                if debug == True:
                    print(':::ffmpeg::: Program '+str(backend)+' found in '+str(verifyif))
                    print(':::ffmpeg::: backend dictionary '+str(backends_dict))

    if codec == 'mp3':
        appendmtype = 'mpeg'
    elif codec == 'aac':
        appendmtype = 'mp4' #This is the container used for aac
    else:
        appendmtype = codec

    mtype = 'audio/'+appendmtype

    print(colors.options('Selected backend:')+' '+ backend)
    print(colors.options('Selected audio codec:')+' '+ codec)

    if backend != 'node':
        if bitrate == '192':
            bitrate = bitrate+'k'
            print(colors.options('Default bitrate used:')+' '+ bitrate)
        elif bitrate == 'None':
            print(colors.warning('The '+codec+' codec does not require the bitrate argument.'))
        else:
            if codec == 'mp3' and int(bitrate) > 320:
                print(colors.warning('Maximum bitrate supported by '+codec+' is: '+str(320)+'k.'))
                print(colors.warning('You may try lossless audio coding formats.'))
                bitrate = '320'
                print(colors.warning('Bitrate has been set to maximum!'))

            if codec == 'ogg' and int(bitrate) > 500:
                print(colors.warning('Maximum bitrate supported by '+codec+' is: '+str(500)+'k.'))
                print(colors.warning('You may try lossless audio coding formats.'))
                bitrate = '500'
                print(colors.warning('Bitrate has been set to maximum!'))

            if codec == 'aac' and int(bitrate) > 500:
                print(colors.warning('Maximum bitrate supported by '+codec+' is: '+str(500)+'k.'))
                print(colors.warning('At about 128-256k is already considered as "transparent" for '+codec+'.'))
                print(colors.warning('You may try lossless audio coding formats.'))
                bitrate = '500'
                print(colors.warning('Bitrate has been set to maximum!'))

            bitrate = bitrate+'k'
            print(colors.options('Selected bitrate:')+' '+ bitrate)

        if samplerate == '44100':
            print(colors.options('Default sample rate used:')+' '+ samplerate+'Hz')
        else:
            codecs_sr = [
                'mp3',
                'ogg',
                'aac',
                'wav',
                'flac'
                ]

            '''
            The codecs below do not support 96000Hz
            '''
            no96k = [
                'mp3',
                'ogg'
                ]

            if codec in codecs_sr and int(samplerate) > 22000 and int(samplerate) <= 27050:
                print(colors.warning('Sample rates supported by '+codec+' are: '
                    +str(22050)+'Hz, '
                    +str(32000)+'Hz, '
                    +str(44100)+'Hz, '
                    +str(48000)+'Hz or '
                    +str(96000)+'Hz')
                    )
                samplerate = '22050'

            if codec in codecs_sr and int(samplerate) > 27050 and int(samplerate) <= 32000:
                print(colors.warning('Sample rates supported by '+codec+' are: '
                    +str(22050)+'Hz, '
                    +str(32000)+'Hz, '
                    +str(44100)+'Hz, '
                    +str(48000)+'Hz or '
                    +str(96000)+'Hz')
                    )
                samplerate = '32000'

            elif codec in codecs_sr and int(samplerate) > 32000 and int(samplerate) <= 36000:
                print(colors.warning('Sample rates supported by '+codec+' are: '
                    +str(22050)+'Hz, '
                    +str(32000)+'Hz, '
                    +str(44100)+'Hz, '
                    +str(48000)+'Hz or '
                    +str(96000)+'Hz')
                    )
                samplerate = '32000'

            elif codec in codecs_sr and int(samplerate) > 36000 and int(samplerate) <= 43000:
                print(colors.warning('Sample rates supported by '+codec+' are: '
                    +str(22050)+'Hz, '
                    +str(32000)+'Hz, '
                    +str(44100)+'Hz, '
                    +str(48000)+'Hz or '
                    +str(96000)+'Hz')
                    )
                samplerate = '44100'
                print(colors.warning('Sample rate has been set to default!'))

            elif codec in codecs_sr and int(samplerate) > 43000 and int(samplerate) <= 72000:
                print(colors.warning('Sample rates supported by '+codec+' are: '
                    +str(22050)+'Hz, '
                    +str(32000)+'Hz, '
                    +str(44100)+'Hz, '
                    +str(48000)+'Hz or '
                    +str(96000)+'Hz')
                    )
                samplerate = '48000'

            elif codec in codecs_sr and int(samplerate) > 72000:
                if codec in no96k:
                    print(colors.warning('sample rates supported by '+codec+' are: '
                        +str(22050)+'hz, '
                        +str(32000)+'hz, '
                        +str(44100)+'hz or, '
                        +str(48000)+'hz')
                        )
                    samplerate = '48000'
                else:
                    print(colors.warning('sample rates supported by '+codec+' are: '
                        +str(22050)+'hz, '
                        +str(32000)+'hz, '
                        +str(44100)+'hz, '
                        +str(48000)+'hz or '
                        +str(96000)+'hz')
                        )
                    samplerate = '96000'

                print(colors.warning('Sample rate has been set to maximum!'))

            print(colors.options('Sample rate set to:')+' '+samplerate+'Hz')

    """
    We verify platform and other options
    """
    platform = mkchromecast.__init__.platform

    def debug_command():                # This function add some more flags to the ffmpeg command
        command.insert(1, '-loglevel')  # when user passes --debug option.
        command.insert(2, 'panic')
        return

    """
    MP3 192k
    """
    if  codec == 'mp3':

        if platform == 'Linux' and backends_dict[backend] != 'parec':
            command = [
                backend,
                '-re',
                '-ac', '2',
                '-ar', '44100',
                '-f', 'pulse',
                '-i', 'mkchromecast.monitor',
                '-acodec', 'libmp3lame',
                '-f', 'mp3',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                'pipe:'
                ]
        elif platform == 'Linux' and backends_dict[backend] == 'parec':
            command = [
                'lame',
                '-b', bitrate[:-1],
                '-r',
                '-'
                ]
        else:
            command = [
                backend,
                '-re',
                '-f', 'avfoundation',
                '-audio_device_index', '0',
                '-i', '',
                '-acodec', 'libmp3lame',
                '-f', 'mp3',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                'pipe:'
                ]
        if debug == False and backends_dict[backend] != 'parec':
            debug_command()

    """
    OGG 192k
    """
    if  codec == 'ogg':
        if platform == 'Linux' and backends_dict[backend] != 'parec':
            command = [
                backend,
                '-re',
                '-ac', '2',
                '-ar', '44100',
                '-f', 'pulse',
                '-i', 'mkchromecast.monitor',
                '-acodec', 'libvorbis',
                '-f', 'ogg',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                'pipe:'
                ]
        elif platform == 'Linux' and backends_dict[backend] == 'parec':
            command = [
                'oggenc',
                '-b', bitrate[:-1],
                '-Q',
                '-r',
                '--ignorelength',
                '-'
                ]
        else:
            command = [
                backend,
                '-re',
                '-f', 'avfoundation',
                '-audio_device_index', '0',
                '-i', '',
                '-acodec', 'libvorbis',
                '-f', 'ogg',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                'pipe:'
                ]
        if debug == False and backends_dict[backend] != 'parec':
            debug_command()

    """
    AAC > 128k for Stereo, Default sample rate: 44100kHz
    """
    if  codec == 'aac':
        if platform == 'Linux' and backends_dict[backend] != 'parec':
            command = [
                backend,
                '-re',
                '-ac', '2',
                '-ar', '44100',
                '-f', 'pulse',
                '-i', 'mkchromecast.monitor',
                '-acodec', 'aac',
                '-f', 'adts',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                '-cutoff', '18000',
                'pipe:'
                ]
        elif platform == 'Linux' and backends_dict[backend] == 'parec':
            command = [
                'faac',
                '-b', bitrate[:-1],
                '-X',
                '-P',
                '-c','18000',
                '-o',
                '-',
                '-'
                ]
        else:
            command = [
                backend,
                '-re',
                '-f', 'avfoundation',
                '-audio_device_index', '0',
                '-i', '',
                '-acodec', 'libfdk_aac',
                '-f', 'adts',
                '-ac', '2',
                '-ar', samplerate,
                '-b:a', bitrate,
                '-cutoff', '18000',
                'pipe:'
                ]
        if debug == False and backends_dict[backend] != 'parec':
            debug_command()

    """
    WAV 24-Bit
    """
    if  codec == 'wav':
        if platform == 'Linux' and backends_dict[backend] != 'parec':
            command = [
                backend, '-re',
                '-ac', '2',
                '-ar', '44100',
                '-f', 'pulse',
                '-i', 'mkchromecast.monitor',
                '-acodec', 'pcm_s24le',
                '-f', 'wav',
                '-ac', '2',
                '-ar', samplerate,
                'pipe:'
                ]
        elif platform == 'Linux' and backends_dict[backend] == 'parec':
            command = [
                'sox',
                '-t', 'raw',
                '-b', '16',
                '-e', 'signed',
                '-c', '2',
                '-r', samplerate,
                '-',
                '-t', 'wav',
                '-b', '16',
                '-e', 'signed',
                '-c', '2',
                '-r', samplerate,
                '-L', '-'
                ]
        else:
            command = [
                backend,
                '-re',
                '-f', 'avfoundation',
                '-audio_device_index', '0',
                '-i', '',
                '-acodec', 'pcm_s24le',
                '-f', 'wav',
                '-ac', '2',
                '-ar', samplerate,
                'pipe:'
                ]
        if debug == False and backends_dict[backend] != 'parec':
            debug_command()

    """
    FLAC 24-Bit (values taken from: https://trac.ffmpeg.org/wiki/Encode/HighQualityAudio) except for parec.
    """
    if  codec == 'flac':
        if platform == 'Linux' and backends_dict[backend] != 'parec':
            command = [
                backend,
                '-re',
                '-ac', '2',
                '-ar', '44100',
                '-f', 'pulse',
                '-i', 'mkchromecast.monitor',
                '-acodec', 'flac',
                '-f', 'flac',
                '-ac', '2',
                '-ar', samplerate,
                'pipe:'
                ]
        elif platform == 'Linux' and backends_dict[backend] == 'parec':
            command = [
                'flac',
                '-',
                '-c',
                '--channels', '2',
                '--bps', '16',
                '--sample-rate', samplerate,
                '--endian', 'little',
                '--sign', 'signed',
                '-s'
                ]
        else:
            command = [
                backend,
                '-re',
                '-f', 'avfoundation',
                '-audio_device_index', '0',
                '-i', '',
                '-acodec', 'flac',
                '-f', 'flac',
                '-ac', '2',
                '-ar', samplerate,
                'pipe:'
                ]
        if debug == False and backends_dict[backend] != 'parec':
            debug_command()

app = Flask(__name__)

if debug == True:
    print(':::ffmpeg::: command '+str(command))

@app.route('/')
def index():
    return """<!doctype html>
<title>Play {appendtourl}</title>
<audio controls autoplay >
    <source src="{appendtourl}" type="audio/mp3" >
    Your browser does not support this audio format.
</audio>""".format(appendtourl=appendtourl)


"""
The code below is supposed to kill the Flask server. I don't know if it would
be useful later.
"""
"""
def shutdown_server():
    func = request.environ.get('werkzeug.server.shutdown')
    if func is None:
        raise RuntimeError('Not running with the Werkzeug Server')
    func()

@app.route('/shutdown', methods=['POST'])
def shutdown():
    shutdown_server()
    return 'Server shutting down...'

"""
@app.route('/' + appendtourl)
def stream():
    if platform == 'Linux' and bool(backends_dict) == True \
            and backends_dict[backend] == 'parec':
        c_parec = [
            backend,
            '--format=s16le',
            '-d', 'mkchromecast.monitor'
            ]
        parec = Popen(c_parec, stdout=PIPE)
        process = Popen(command, stdin=parec.stdout, stdout=PIPE, bufsize=-1)
    else:
        process = Popen(command, stdout=PIPE, bufsize=-1)
    read_chunk = partial(os.read, process.stdout.fileno(), chunk_size)
    return Response(iter(read_chunk, b''), mimetype=mtype)

def start_app():
    monitor_daemon = monitor()
    monitor_daemon.start()
    app.run(host= '0.0.0.0')

class multi_proc(object):       # I launch ffmpeg in a different process
    def __init__(self):
        self.proc = multiprocessing.Process(target=start_app)
        self.proc.daemon = True

    def start(self):
        self.proc.start()
"""
I create a class to launch a thread in this process that monitors if main
application stops.
A normal running of mkchromecast will have 2 threads in the streaming process
when ffmpeg is used.
"""
class monitor(object):
    def __init__(self):
        self.monitor_d = threading.Thread(target=monitor_daemon)
        self.monitor_d.daemon = True

    def start(self):
        self.monitor_d.start()

def monitor_daemon():
    f = open('/tmp/mkchromecast.pid', 'rb')
    pidnumber=int(pickle.load(f))
    print(colors.options('PID of main process:')+' '+str(pidnumber))

    localpid=getpid()
    print(colors.options('PID of streaming process:')+' '+str(localpid))

    while psutil.pid_exists(localpid) == True:
        try:
            time.sleep(0.5)
            if psutil.pid_exists(pidnumber) == False:   # With this I ensure that if the main app fails, everything
                if platform == 'Darwin':                # will get back to normal
                    inputint()
                    outputint()
                else:
                    from mkchromecast.pulseaudio import remove_sink
                    remove_sink()
                parent = psutil.Process(localpid)
                for child in parent.children(recursive=True):  # or parent.children() for recursive=False
                    child.kill()
                parent.kill()
        except KeyboardInterrupt:
            print('Ctrl-c was requested')
            sys.exit(0)
        except IOError:
            print('I/O Error')
            sys.exit(0)
        except OSError:
            print('OSError')
            sys.exit(0)

def main():
    st = multi_proc()
    st.start()
