/*
 * Copyright © 2013 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Alexandros Frantzis <alexandros.frantzis@canonical.com>
 */

#ifndef MIR_GRAPHICS_GBM_VIRTUAL_TERMINAL_H_
#define MIR_GRAPHICS_GBM_VIRTUAL_TERMINAL_H_

#include <functional>

namespace mir
{

class MainLoop;

namespace graphics
{
namespace gbm
{

class VirtualTerminal
{
public:
    virtual ~VirtualTerminal() = default;

    virtual void set_graphics_mode() = 0;
    virtual void register_switch_handlers(
        MainLoop& main_loop,
        std::function<bool()> const& switch_away,
        std::function<bool()> const& switch_back) = 0;

protected:
    VirtualTerminal() = default;
    VirtualTerminal(VirtualTerminal const&) = delete;
    VirtualTerminal& operator=(VirtualTerminal const&) = delete;
};

}
}
}

#endif /* MIR_GRAPHICS_GBM_VIRTUAL_TERMINAL_H_ */
