## Example data directory for different InSAR processors

### ISCE / [topsStack](https://github.com/isce-framework/isce2/blob/main/contrib/stack/topsStack/README.md) ###

```
$DATA_DIR/GalapagosSenDT128
├── baselines
│   ├── 20141213_20141225
│   │   └── 20141213_20141225.txt
│   └── ...
├── reference
│   ├── data.rsc    #generated by prep_isce.py
│   ├── IW1
│   ├── IW1.xml
│   ├── IW2
│   └── IW2.xml
├── merged
│   ├── geom_reference
│   │   ├── hgt.rdr
│   │   ├── hgt.rdr.full.vrt
│   │   ├── hgt.rdr.full.xml
│   │   ├── hgt.rdr.vrt
│   │   ├── hgt.rdr.xml
│   │   ├── lat.rdr
│   │   ├── lat.rdr.full.vrt
│   │   ├── lat.rdr.full.xml
│   │   ├── lat.rdr.vrt
│   │   ├── lat.rdr.xml
│   │   ├── lon.rdr
│   │   ├── lon.rdr.full.vrt
│   │   ├── lon.rdr.full.xml
│   │   ├── lon.rdr.vrt
│   │   ├── lon.rdr.xml
│   │   ├── los.rdr
│   │   ├── los.rdr.full.vrt
│   │   ├── los.rdr.full.xml
│   │   ├── los.rdr.vrt
│   │   ├── los.rdr.xml
│   │   ├── shadowMask.rdr
│   │   ├── shadowMask.rdr.full.vrt
│   │   ├── shadowMask.rdr.full.xml
│   │   ├── shadowMask.rdr.vrt
│   │   └── shadowMask.rdr.xml
│   └── interferograms
│       ├── 20141213_20141225
│       │   ├── filt_fine.cor
│       │   ├── filt_fine.cor.vrt
│       │   ├── filt_fine.cor.xml
│       │   ├── filt_fine.unw
│       │   ├── filt_fine.unw.conncomp
│       │   ├── filt_fine.unw.conncomp.vrt
│       │   ├── filt_fine.unw.conncomp.xml
│       │   ├── filt_fine.unw.vrt
│       │   ├── filt_fine.unw.xml
│       │   ├── ...
│       ├── 20141213_20150307
│       └── ...
├── secondarys
│   ├── 20141225
│   │   ├── IW1
│   │   ├── IW1.xml
│   │   ├── IW2
│   │   └── IW2.xml
│   ├── 20150307
│   └── ...
└── mintpy
    └── GalapagosSenDT128.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = isce
##---------for ISCE only:
mintpy.load.metaFile         = $DATA_DIR/GalapagosSenDT128/reference/IW*.xml
mintpy.load.baselineDir      = $DATA_DIR/GalapagosSenDT128/baselines
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/GalapagosSenDT128/merged/interferograms/*/filt_*.unw
mintpy.load.corFile          = $DATA_DIR/GalapagosSenDT128/merged/interferograms/*/filt_*.cor
mintpy.load.connCompFile     = $DATA_DIR/GalapagosSenDT128/merged/interferograms/*/filt_*.unw.conncomp
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/hgt.rdr
mintpy.load.lookupYFile      = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/lat.rdr
mintpy.load.lookupXFile      = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/lon.rdr
mintpy.load.incAngleFile     = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/los.rdr
mintpy.load.azAngleFile      = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/los.rdr
mintpy.load.shadowMaskFile   = $DATA_DIR/GalapagosSenDT128/merged/geom_reference/shadowMask.rdr
```

### ISCE / [stripmapStack](https://github.com/isce-framework/isce2/blob/main/contrib/stack/stripmapStack/README.md) ###

```
$DATA_DIR/KirishimaAlosAT424F620_630
├── baselines
│   ├── 20060624_20060924.txt
│   ├── 20060624_20061225.txt
│   └── ...
├── geom_reference
│   ├── hgt.rdr
│   ├── hgt.rdr.full.vrt
│   ├── hgt.rdr.full.xml
│   ├── hgt.rdr.vrt
│   ├── hgt.rdr.xml
│   ├── incLocal.rdr
│   ├── incLocal.rdr.full.vrt
│   ├── incLocal.rdr.full.xml
│   ├── incLocal.rdr.vrt
│   ├── incLocal.rdr.xml
│   ├── lat.rdr
│   ├── lat.rdr.full.vrt
│   ├── lat.rdr.full.xml
│   ├── lat.rdr.vrt
│   ├── lat.rdr.xml
│   ├── lon.rdr
│   ├── lon.rdr.full.vrt
│   ├── lon.rdr.full.xml
│   ├── lon.rdr.vrt
│   ├── lon.rdr.xml
│   ├── los.rdr
│   ├── los.rdr.full.vrt
│   ├── los.rdr.full.xml
│   ├── los.rdr.vrt
│   ├── los.rdr.xml
│   ├── shadowMask.rdr
│   ├── shadowMask.rdr.full.vrt
│   ├── shadowMask.rdr.full.xml
│   ├── shadowMask.rdr.vrt
│   └── shadowMask.rdr.xml
├── merged
│   ├── baselines
│   │   ├── 20060624
│   │   │   ├── 20060624
│   │   │   ├── 20060624.full.vrt
│   │   │   ├── 20060624.vrt
│   │   │   └── 20060624.xml
│   │   ├── 20060924
│   │   │   ├── 20060924
│   │   │   ├── 20060924.full.vrt
│   │   │   ├── 20060924.vrt
│   │   │   └── 20060924.xml
│   │   └── ...
│   └── SLC
│       ├── 20060624
│       │   ├── ...
│       │   └── referenceShelve
│       │       ├── data.bak
│       │       ├── data.dat
│       │       ├── data.dir
│       │       └── data.rsc    #generated by prep_isce.py
│       ├── 20060924
│       └── ...
├── Igrams
│   ├── 20060624_20061225
│   │   ├── filt_20060624_20061225.cor
│   │   ├── filt_20060624_20061225.cor.vrt
│   │   ├── filt_20060624_20061225.cor.xml
│   │   ├── filt_20060624_20061225_snaphu.unw
│   │   ├── filt_20060624_20061225_snaphu.unw.conncomp
│   │   ├── filt_20060624_20061225_snaphu.unw.conncomp.vrt
│   │   ├── filt_20060624_20061225_snaphu.unw.conncomp.xml
│   │   ├── filt_20060624_20061225_snaphu.unw.vrt
│   │   └── filt_20060624_20061225_snaphu.unw.xml
│   ├── 20060624_20080814
│   └── ...
├── ionosphere
│   ├── 20070107_20071125
│   │   ├── iono.bil.unwCor.filt
│   │   ├── iono.bil.unwCor.filt.vrt
│   │   ├── iono.bil.unwCor.filt.xml
│   │   ├── mask.bil
│   │   ├── mask.bil.vrt
│   │   └── mask.bil.xml
│   ├── 20070107_20080110
│   └── ...
└── mintpy
    └── KirishimaAlosAT424F620_630.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = isce
##---------for ISCE only:
mintpy.load.metaFile         = $DATA_DIR/KirishimaAlosAT424/merged/SLC/*/referenceShelve/data.dat
mintpy.load.baselineDir      = $DATA_DIR/KirishimaAlosAT424/baselines
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/KirishimaAlosAT424/Igrams/*/filt_*.unw
mintpy.load.corFile          = $DATA_DIR/KirishimaAlosAT424/Igrams/*/filt_*.cor
mintpy.load.connCompFile     = $DATA_DIR/KirishimaAlosAT424/Igrams/*/filt_*.unw.conncomp
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/KirishimaAlosAT424/geom_reference/hgt.rdr
mintpy.load.lookupYFile      = $DATA_DIR/KirishimaAlosAT424/geom_reference/lat.rdr
mintpy.load.lookupXFile      = $DATA_DIR/KirishimaAlosAT424/geom_reference/lon.rdr
mintpy.load.incAngleFile     = $DATA_DIR/KirishimaAlosAT424/geom_reference/los.rdr
mintpy.load.azAngleFile      = $DATA_DIR/KirishimaAlosAT424/geom_reference/los.rdr
mintpy.load.shadowMaskFile   = $DATA_DIR/KirishimaAlosAT424/geom_reference/shadowMask.rdr
```

### ISCE / [alosStack](https://github.com/isce-framework/isce2/blob/main/contrib/stack/alosStack/alosStack_tutorial.txt) ###

```
$DATA_DIR/NCalAlos2DT169
├── alosStack.xml
├── baseline
│   ├── baseline_center.txt
│   └── ...
├── dates_ion
│   ├── filt_ion_150225_5rlks_28alks.ion
│   ├── filt_ion_150225_5rlks_28alks.ion.vrt
│   ├── filt_ion_150225_5rlks_28alks.ion.xml
│   └── ...
├── dates_resampled
│   ├── 150225
│   │   ├── 150225.track.xml         #only in reference date folder
│   │   ├── f1_2800
│   │   │   ├── 150225.frame.xml     #only in reference date folder
│   │   │   └── ...
│   │   └── insar
│   │       ├── 150225_1rlks_14alks.hgt        #the following files only in reference date folder
│   │       ├── ...
│   │       ├── 150225_5rlks_28alks.hgt
│   │       ├── 150225_5rlks_28alks.hgt.vrt
│   │       ├── 150225_5rlks_28alks.hgt.xml
│   │       ├── 150225_5rlks_28alks.lat
│   │       ├── 150225_5rlks_28alks.lat.vrt
│   │       ├── 150225_5rlks_28alks.lat.xml
│   │       ├── 150225_5rlks_28alks.lon
│   │       ├── 150225_5rlks_28alks.lon.vrt
│   │       ├── 150225_5rlks_28alks.lon.xml
│   │       ├── 150225_5rlks_28alks.los
│   │       ├── 150225_5rlks_28alks.los.vrt
│   │       ├── 150225_5rlks_28alks.los.xml
│   │       ├── 150225_5rlks_28alks.wbd
│   │       ├── 150225_5rlks_28alks.wbd.vrt
│   │       ├── 150225_5rlks_28alks.wbd.xml
│   │       └── ...
│   └── ...
├── pairs
│   ├── 150225-150408
│   │   ├── 150225.track.xml
│   │   ├── 150408.track.xml
│   │   ├── f1_2800
│   │   │   ├── 150225.frame.xml
│   │   │   ├── 150408.frame.xml
│   │   │   └── ...
│   │   └── insar
│   │       ├── 150225-150408_5rlks_28alks.cor
│   │       ├── 150225-150408_5rlks_28alks.cor.vrt
│   │       ├── 150225-150408_5rlks_28alks.cor.xml
│   │       ├── filt_150225-150408_5rlks_28alks.unw
│   │       ├── filt_150225-150408_5rlks_28alks.unw.conncomp
│   │       ├── filt_150225-150408_5rlks_28alks.unw.conncomp.vrt
│   │       ├── filt_150225-150408_5rlks_28alks.unw.conncomp.xml
│   │       ├── filt_150225-150408_5rlks_28alks.unw.vrt
│   │       ├── filt_150225-150408_5rlks_28alks.unw.xml
│   │       └── ...
│   └── ...
├── pairs_ion
│   ├── 150225-150408
│   │   ├── 150225.track.xml
│   │   ├── 150408.track.xml
│   │   ├── f1_2800
│   │   │   ├── 150225.frame.xml
│   │   │   ├── 150408.frame.xml
│   │   │   └── ...
│   │   └── ion
│   │       ├── ion_cal
│   │       │   ├── diff_150225-150408_80rlks_448alks.int
│   │       │   ├── diff_150225-150408_80rlks_448alks.int.vrt
│   │       │   ├── diff_150225-150408_80rlks_448alks.int.xml
│   │       │   ├── filt_ion_80rlks_448alks.ion
│   │       │   ├── filt_ion_80rlks_448alks.ion.vrt
│   │       │   ├── filt_ion_80rlks_448alks.ion.xml
│   │       │   ├── filt_ion_80rlks_448alks.std
│   │       │   ├── filt_ion_80rlks_448alks.std.vrt
│   │       │   ├── filt_ion_80rlks_448alks.std.xml
│   │       │   └── ...
│   │       └── ...
│   └── ...
└── mintpy
    └── NCalAlos2DT169.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = isce
## NOTE: 150408 is the reference date of alosStack processing.
##       (parameter "reference date of the stack" of alosStack input xml file)
##---------for ISCE only:
mintpy.load.metaFile         = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/150408.track.xml
mintpy.load.baselineDir      = $DATA_DIR/NCalAlos2DT169/baseline
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/NCalAlos2DT169/pairs/*-*/insar/filt_*-*_5rlks_28alks.unw
mintpy.load.corFile          = $DATA_DIR/NCalAlos2DT169/pairs/*-*/insar/*-*_5rlks_28alks.cor
mintpy.load.connCompFile     = $DATA_DIR/NCalAlos2DT169/pairs/*-*/insar/filt_*-*_5rlks_28alks.unw.conncomp
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.hgt
mintpy.load.lookupYFile      = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.lat
mintpy.load.lookupXFile      = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.lon
mintpy.load.incAngleFile     = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.los
mintpy.load.azAngleFile      = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.los
mintpy.load.waterMaskFile    = $DATA_DIR/NCalAlos2DT169/dates_res*/150408/insar/*_5rlks_28alks.wbd
```

### ARIA from [ARIA-tools](https://github.com/aria-tools/ARIA-tools) ###

1. Download GUNW products using [ariaDownload.py](https://nbviewer.jupyter.org/github/aria-tools/ARIA-tools-docs/blob/master/JupyterDocs/ariaDownload/ariaDownload_tutorial.ipynb).
2. Prepare GUNW products layers for time series analysis using [ariaTSsetup.py](https://nbviewer.jupyter.org/github/aria-tools/ARIA-tools-docs/blob/master/JupyterDocs/ariaTSsetup/ariaTSsetup_tutorial.ipynb)

```
$DATA_DIR/SanFranSenDT42
├── DEM
│   ├── SRTM_3arcsec.dem
│   ├── SRTM_3arcsec.dem.aux.xml
│   ├── SRTM_3arcsec.dem.vrt
│   ├── SRTM_3arcsec.hdr
│   └── ...
├── azimuthAngle
│   ├── 20150605_20150512
│   ├── 20150605_20150512.aux.xml
│   ├── 20150605_20150512.hdr
│   └── 20150605_20150512.vrt
├── coherence
│   ├── 20150605_20150512
│   ├── 20150605_20150512.aux.xml
│   ├── 20150605_20150512.hdr
│   ├── 20150605_20150512.vrt
│   └── ...
├── connectedComponents
│   ├── 20150605_20150512
│   ├── 20150605_20150512.aux.xml
│   ├── 20150605_20150512.hdr
│   ├── 20150605_20150512.vrt
│   └── ...
├── incidenceAngle
│   ├── 20150605_20150512
│   ├── 20150605_20150512.aux.xml
│   ├── 20150605_20150512.hdr
│   └── 20150605_20150512.vrt
├── mask
│   ├── watermask.hdr
│   ├── watermask.msk
│   ├── watermask.msk.aux.xml
│   ├── watermask.msk.vrt
│   └── ...
├── mintpy
│   ├── SanFranSenDT42.txt
│   └── ...
├── products
│   ├── S1-GUNW-D-R-042-tops-20150605_20150512-140722-39616N_37642N-PP-e396-v2_0_0.nc
│   ├── S1-GUNW-D-R-042-tops-20150605_20150512-140746-38125N_36150N-PP-24d1-v2_0_0.nc
│   └── ...
├── stack
│   ├── cohStack.vrt
│   ├── connCompStack.vrt
│   └── unwrapStack.vrt
└── unwrappedPhase
    ├── 20150605_20150512
    ├── 20150605_20150512.aux.xml
    ├── 20150605_20150512.hdr
    ├── 20150605_20150512.vrt
    └── ...
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = aria
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/SanFranSenDT42/stack/unwrapStack.vrt
mintpy.load.corFile          = $DATA_DIR/SanFranSenDT42/stack/cohStack.vrt
mintpy.load.connCompFile     = $DATA_DIR/SanFranSenDT42/stack/connCompStack.vrt
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/SanFranSenDT42/DEM/SRTM_3arcsec.dem
mintpy.load.incAngleFile     = $DATA_DIR/SanFranSenDT42/incidenceAngle/*.vrt
mintpy.load.azAngleFile      = $DATA_DIR/SanFranSenDT42/azimuthAngle/*.vrt
mintpy.load.waterMaskFile    = $DATA_DIR/SanFranSenDT42/mask/watermask.msk
```

### [ASF HyP3](https://hyp3-docs.asf.alaska.edu/)

1. Search, request and download interferograms using [hyp3_sdk](https://nbviewer.jupyter.org/github/ASFHyP3/hyp3-sdk/blob/main/docs/sdk_example.ipynb) or the [ASF Vertex website](https://search.asf.alaska.edu/) following the [story map](https://storymaps.arcgis.com/stories/68a8a3253900411185ae9eb6bb5283d3).
    + For at least one interferogram, download the accompanying DEM.
    + Unzip the downloaded files. E.g., `for f in *.zip; do unzip $f; done` in bash.

2. Clip DEM and all interferograms to the same area using hyp3lib/[cutGeotiffs.py](https://github.com/ASFHyP3/hyp3-lib/blob/develop/hyp3lib/cutGeotiffs.py) script.

Here is an example workflow: [smallbaselineApp_hyp3](https://nbviewer.org/github/insarlab/MintPy-tutorial/blob/main/workflows/smallbaselineApp_hyp3.ipynb).

HyP3 produces two types of InSAR products: 1) scene-wide products using Gamma and 2) burst-wide products using ISCE2.

+ INSAR_GAMMA directory structure:

```
$DATA_DIR/RidgecrestSenDT71
├── hyp3
│   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_corr_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_dem_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_lv_theta_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_lv_phi_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_unw_phase_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43_water_mask_clip.tif
│   │   ├── S1AA_20190622T135157_20190704T135158_VVP012_INT80_G_ueF_4C43.txt
│   │   └── ...
│   ├── S1AA_20190622T135157_20190716T135159_VVP024_INT80_G_ueF_BA28
│   │   ├── S1AA_20190622T135157_20190716T135159_VVP024_INT80_G_ueF_BA28_corr_clip.tif
│   │   ├── S1AA_20190622T135157_20190716T135159_VVP024_INT80_G_ueF_BA28_unw_phase_clip.tif
│   │   ├── S1AA_20190622T135157_20190716T135159_VVP024_INT80_G_ueF_BA28.txt
│   │   └── ...
│   └── ...
└── mintpy
    └── RidgecrestSenDT71.txt
```

+ INSAR_ISCE2_BURST directory structure:

```
$DATA_DIR/MtEdgecumbeSenAT174
├── hyp3
│   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_dem_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_corr_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_lv_theta_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_lv_phi_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_unw_phase_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044_water_mask_clipped.tif
│   │   ├── S1_372326_IW3_20141017_20141110_VV_INT80_7044.txt
│   │   └── ...
│   ├── S1_372326_IW3_20141110_20141204_VV_INT80_1894
│   │   ├── S1_372326_IW3_20141110_20141204_VV_INT80_1894_corr_clipped.tif
│   │   ├── S1_372326_IW3_20141110_20141204_VV_INT80_1894_unw_phase_clipped.tif
│   │   ├── S1_372326_IW3_20141110_20141204_VV_INT80_1894.txt
│   │   └── ...
│   └── ...
└── mintpy
    └── MtEdgecumbeSenAT174.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = hyp3
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*unw_phase_clip.tif
mintpy.load.corFile          = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*corr_clip.tif
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*dem_clip.tif
mintpy.load.incAngleFile     = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*lv_theta_clip.tif
mintpy.load.azAngleFile      = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*lv_phi_clip.tif
mintpy.load.waterMaskFile    = $DATA_DIR/RidgecrestSenDT71/hyp3/*/*water_mask_clip.tif
```

### [GMTSAR](https://github.com/gmtsar/gmtsar) ###

Below is a recipe to prepare a stack of interferograms from Sentinel-1:

+ [https://topex.ucsd.edu/gmtsar/tar/sentinel_time_series_2.pdf](https://topex.ucsd.edu/gmtsar/tar/sentinel_time_series_2.pdf)

```
$DATA_DIR/StHelensEnvDT156
├── geometry
│   └── topo_ll.grd
├── interferograms
│   ├── 2004114_2004324
│   │   ├── 20040423.LED
│   │   ├── 20040423.PRM
│   │   ├── 20041119.LED
│   │   ├── 20041119.PRM
│   │   ├── baseline.txt   #generated by SAT_baseline
│   │   ├── corr.grd
│   │   ├── corr_ll.grd
│   │   ├── unwrap.grd
│   │   └── unwrap_ll.grd
│   ├── 2004114_2004359
│   └── ...
└── mintpy
    └── StHelensEnvDT156.txt
```

The corresponding template options for `load_data`:

```cfg
## manually specify the following attributes since they are missing from gmtsar products
HEADING         = -168.0     #[float], satellite heading angle, measured from the north in clockwise as positive
                             # One could open the *.kml file in Google Earth and measure it manually
ORBIT_DIRECTION = DESCENDING #[ASCENDING, DESCENDING]

mintpy.load.processor   = gmtsar
##---------interferogram datasets:
mintpy.load.unwFile     = $DATA_DIR/StHelensEnvDT156/interferograms/*/unwrap_ll.grd
mintpy.load.corFile     = $DATA_DIR/StHelensEnvDT156/interferograms/*/corr_ll.grd
##---------geometry datasets:
mintpy.load.demFile     = $DATA_DIR/StHelensEnvDT156/geometry/topo_ll.grd
```

### Gamma ###

```
$DATA_DIR/GalapagosEnvA2T061
├── geometry
│   ├── sim_20040207_4rlks.UTM_TO_RDC
│   ├── sim_20040207_4rlks.diff_par
│   ├── sim_20040207_4rlks.rdc.dem (or sim_150911.hgt_sim)
│   └── sim_20040207_4rlks.utm.dem.par
├── interferograms
│   ├── 20030329_20030503
│   │   ├── 20030329_20030503_4rlks.base_perp   #generated by base_perp
│   │   ├── 20030329_20030503_4rlks.baseline    #generated by base_orbit
│   │   ├── 20030329_20030503_4rlks.off
│   │   ├── 20030329_4rlks.ramp.corner
│   │   ├── 20030329_4rlks.ramp.corner_full     #generated by SLC_corners
│   │   ├── 20030329_4rlks.ramp.par
│   │   ├── 20030503_4rlks.ramp.par
│   │   ├── filt_20030329_20030503_4rlks.cor
│   │   └── diff_filt_20030329_20030503_4rlks.unw
│   ├── 20030329_20030607
│   └── ...
└── mintpy
    └── GalapagosEnvA2T061.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = gamma
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/GalapagosEnvA2T061/interferograms/*/diff*rlks.unw
mintpy.load.corFile          = $DATA_DIR/GalapagosEnvA2T061/interferograms/*/*filt*rlks.cor
mintpy.load.connCompFile     = None
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/GalapagosEnvA2T061/geometry/sim*rlks.rdc.dem
mintpy.load.lookupYFile      = $DATA_DIR/GalapagosEnvA2T061/geometry/sim*rlks.UTM_TO_RDC
mintpy.load.lookupXFile      = $DATA_DIR/GalapagosEnvA2T061/geometry/sim*rlks.UTM_TO_RDC
```

### [SNAP](http://step.esa.int/) ###

Below is a preliminary recipe to prepare a stack of geocoded interferograms of Sentinel-1:

+ [https://github.com/insarlab/MintPy/wiki/SNAP-input-data](https://github.com/insarlab/MintPy/wiki/SNAP-input-data)

```
$DATA_DIR/WCapeSenAT29
├── interferograms
│   ├── 20190408_20190420
│   │   ├── 20190408_20190420_coh_tc.dim
│   │   ├── 20190408_20190420_coh_tc.data
│   │   │   ├── coh*.img
│   │   │   └── coh*.hdr
│   │   ├── 20190408_20190420_filt_int_sub_tc.dim
│   │   ├── 20190408_20190420_filt_int_sub_tc.data
│   │   │   ├── Phase_ifg*.img
│   │   │   └── Phase_ifg*.hdr
│   │   ├── 20190408_20190420_unw_tc.dim
│   │   ├── 20190408_20190420_unw_tc.data
│   │   │   ├── Unw_Phase_ifg*.img
│   │   │   └── Unw_Phase_ifg*.hdr
│   ├── 20190408_20190502
│   └── ...
├── dem_tc.dim
├── dem_tc.data
│   ├── dem*.img
│   └── dem*.hdr
└── mintpy
    └── WCapeSenAT29.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor        = snap
##---------interferogram datasets:
mintpy.load.unwFile          = $DATA_DIR/WCapeSenAT29/interferograms/*/*/Unw_*.img
mintpy.load.corFile          = $DATA_DIR/WCapeSenAT29/interferograms/*/*/coh_*.img
##---------geometry datasets:
mintpy.load.demFile          = $DATA_DIR/WCapeSenAT29/dem_tc.data/dem*.img
```

### ROI_PAC (rsmas version) ###

```
$DATA_DIR/GalapagosAlosAT133
├── PROCESS
│   ├── bl_list.txt
│   ├── DONE
│   │   ├── IFGRAM_GalapagosT133F7160_7180AlosA_080304-100910_0920_-0272
│   │   │   ├── 080304_100910_baseline.rsc
│   │   │   ├── filt_080304-100910-sim_HDR_8rlks_c10_snap_connect.byt
│   │   │   ├── filt_080304-100910-sim_HDR_8rlks_c10.unw
│   │   │   ├── filt_080304-100910-sim_HDR_8rlks_c10.unw.rsc
│   │   │   ├── filt_080304-100910-sim_HDR_8rlks.cor
│   │   │   ├── filt_080304-100910-sim_HDR_8rlks.cor.rsc
│   │   │   ├── radar_8rlks.hgt
│   │   │   └── radar_8rlks.hgt.rsc
│   │   └── ...
│   ├── GEO
│   │   └── geo_100610-100910                  # reference interferogram
│   │       ├── geomap_8rlks.trans
│   │       └── geomap_8rlks.trans.rsc
│   ├── ifgram_list.txt
│   └── reference_ifgram.txt
└── mintpy
    └── GalapagosAlosAT133.txt
```

The corresponding template options for `load_data`:

```cfg
mintpy.load.processor      = roipac  #[isce,roipac,gamma,], auto for isce
##---------interferogram datasets:
mintpy.load.unwFile        = $DATA_DIR/GalapagosAlosAT133/PROCESS/DONE/IFG*/filt*.unw
mintpy.load.corFile        = $DATA_DIR/GalapagosAlosAT133/PROCESS/DONE/IFG*/filt*.cor
mintpy.load.connCompFile   = $DATA_DIR/GalapagosAlosAT133/PROCESS/DONE/IFG*/filt*snap_connect.byt
##---------geometry datasets:
mintpy.load.demFile        = $DATA_DIR/GalapagosAlosAT133/PROCESS/DONE/IFG*100610-100910*/radar_*rlks.hgt
mintpy.load.lookupYFile    = $DATA_DIR/GalapagosAlosAT133/PROCESS/GEO/geo_100610-100910/geomap_*rlks.trans
mintpy.load.lookupXFile    = $DATA_DIR/GalapagosAlosAT133/PROCESS/GEO/geo_100610-100910/geomap_*rlks.trans
```
