;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;   MDH 070918 - Simple test for arities of tuples
;;;;   This example does not involve extraction, but merely
;;;;   tests the associativity procedure "tytuple-assoc"
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(load "~/minlog/init.scm")
(set! COMMENT-FLAG #f)
(mload "../modules/diatup.scm")
(add-tvar-name "a" "b" "x" "y" "u" "v")
(add-var-name "va" (py "a"))
(add-var-name "vb" (py "b"))
(add-var-name "vx" (py "x"))
(add-var-name "vy" (py "y"))
(add-var-name "vu" (py "u"))
(add-var-name "vv" (py "v"))
(add-pvar-name "A" (make-arity (py "x") (py "y")))
(add-pvar-name "B" (make-arity (py "u") (py "v")))
(add-pvar-name "C" (make-arity (py "a") (py "b")))
(define fA "(ex vx.all vy. A vx vy )")
(define fB "(ex vu.all vv. B vu vv )")
(define fC "(ex va.all vb. C va vb )")
(define form1 (pf (string-append "(" fA "&" fB ") -> " fC)))
(define form2 (pf (string-append fA "->(" fB "->" fC ")")))
(nldisplay "1st Formula: \n" (formula-to-string form1))
(nldisplay "2nd Formula: \n" (formula-to-string form2))
(define typa1 (DIA-formula-to-typair 'pure form1))
(define typa2 (DIA-formula-to-typair 'pure form2))
(nldisplay "EXISTENTIAL SIDE")
(define tytup (typair-left typa1))
(nldisplay (tytuple-to-string tytup))
(nldisplay (tytuple-to-string (typair-left typa2)))
(define tytupEX (tytuple-assoc tytup))
(nldisplay "After ASSOCIATIVITY")
(nldisplay (tytuple-to-string  tytupEX))
(tytuple_Eq? (typair-left typa2) tytupEX)
(nldisplay "UNIVERSAL SIDE")
(nldisplay (tytuple-to-string (typair-right typa1)))
(nldisplay (tytuple-to-string (typair-right typa2)))
(define tytupFA (tytuple-assoc (typair-right typa1)))
(nldisplay "After ASSOCIATIVITY")
(nldisplay (tytuple-to-string  tytupFA))
(tytuple_Eq? (typair-right typa2) tytupFA)

