; $Id: etsd.scm,v 1.2 2007/07/28 08:51:31 schwicht Exp $
; Extracted terms for the Dialectica interpretation
; =================================================

(set! DIALECTICA-FLAG #t)

(define (formula-to-etdp-type formula)
  (car (formula-to-etd-types formula)))

(define (formula-to-etdn-type formula)
  (cadr (formula-to-etd-types formula)))

(define (formula-to-etd-types formula)
  (case (tag formula)
    ((atom) (list (make-tconst "nulltype") (make-tconst "nulltype")))
    ((predicate)
     (let ((pred (predicate-form-to-predicate formula)))
       (cond ((pvar-form? pred)
	      (if (pvar-with-positive-content? pred)
		  (let ((tvarp (PVAR-TO-TVARP pred)))
		    (if (pvar-with-negative-content? pred)
			(let ((tvarn (PVAR-TO-TVARN pred)))
			  (list tvarp tvarn))
			(list tvarp (make-tconst "nulltype"))))
		  (if (pvar-with-negative-content? pred)
		      (let ((tvarn (PVAR-TO-TVARN pred)))
			(list (make-tconst "nulltype") tvarn))
		      (list (make-tconst "nulltype")
			    (make-tconst "nulltype")))))
	     ((predconst-form? pred)
	      (list (make-tconst "nulltype") (make-tconst "nulltype")))
	     ((idpredconst-form? pred)
	      (myerror "formula-to-etd-types"
		       "not implemented for idpredconst" pred))
	     (else (myerror
		    "formula-to-etd-types" "predicate expected" pred)))))
    ((imp)
     (let* ((prev-prem (formula-to-etd-types (imp-form-to-premise formula)))
	    (prev-conc (formula-to-etd-types
			 (imp-form-to-conclusion formula)))
	    (etdp-type-prem (car prev-prem))
	    (etdn-type-prem (cadr prev-prem))
	    (etdp-type-conc (car prev-conc))
	    (etdn-type-conc (cadr prev-conc)))
       (list (make-star-et 
	      (make-arrow-et etdp-type-prem etdp-type-conc)
	      (mk-arrow-et etdp-type-prem etdn-type-conc etdn-type-prem))
	     (make-star-et etdp-type-prem etdn-type-conc))))
    ((and)
     (let* ((prev-left (formula-to-etd-types (and-form-to-left formula)))
	    (prev-right (formula-to-etd-types (and-form-to-right formula)))
	    (etdp-type-left (car prev-left))
	    (etdn-type-left (cadr prev-left))
	    (etdp-type-right (car prev-right))
	    (etdn-type-right (cadr prev-right)))
       (list (make-star-et etdp-type-left etdp-type-right)
	     (make-star-et etdn-type-left etdn-type-right))))
    ((all)
     (let* ((type (var-to-type (all-form-to-var formula)))
	    (prev-kernel (formula-to-etd-types (all-form-to-kernel formula)))
	    (etdp-type-kernel (car prev-kernel))
	    (etdn-type-kernel (cadr prev-kernel)))
       (list (make-arrow-et type etdp-type-kernel)
	     (make-star-et type etdn-type-kernel))))
    ((ex)
     (let* ((type (var-to-type (ex-form-to-var formula)))
	    (prev-kernel (formula-to-etd-types (ex-form-to-kernel formula)))
	    (etdp-type-kernel (car prev-kernel))
	    (etdn-type-kernel (cadr prev-kernel)))
       (list (make-star-et type etdp-type-kernel)
	     etdn-type-kernel)))
    ((allnc) (formula-to-etd-types (allnc-form-to-kernel formula)))
    ((exnc) (formula-to-etd-types (exnc-form-to-kernel formula)))
    ((exca excl) (formula-to-etd-types (unfold-formula formula)))
    (else (myerror "formula-to-etd-types" "formula expected" formula))))

; Often we have to check whether a formula has positive or negative
; computational content.  This can be done without computing its
; etd-types, by using formula-of-nulltypep? and formula-of-nulltypen?
; (defined in term.scm).

(define (make-pvar-to-var)
  (let ((assoc-list '()))
    (lambda (pvar)
      (let ((info (assoc pvar assoc-list)))
	(if
	 info
	 (cadr info)
	 (let* ((h-deg-one? (not (pvar-with-positive-content? pvar)))
		(n-deg-one? (not (pvar-with-negative-content? pvar)))
		(arity (pvar-to-arity pvar))
		(types (arity-to-types arity)))		   
	   (cond
	    ((and h-deg-one? n-deg-one?)
	     (let* ((type (apply mk-arrow (append types (list (py "boole")))))
		    (var (type-to-new-var type)))
	       (set! assoc-list (cons (list pvar var) assoc-list))
	       var))
	    (n-deg-one?
	     (let* ((tvarp (PVAR-TO-TVARP pvar))
		    (type (apply
			   mk-arrow
			   (append (list tvarp) types (list (py "boole")))))
		    (var (type-to-new-var type)))
	       (set! assoc-list (cons (list pvar var) assoc-list))
	       var))
	    (h-deg-one?
	     (let* ((tvarn (PVAR-TO-TVARN pvar))
		    (type (apply
			   mk-arrow
			   (append (list tvarn) types (list (py "boole")))))
		    (var (type-to-new-var type)))
	       (set! assoc-list (cons (list pvar var) assoc-list))
	       var))
	    (else
	     (let* ((tvarp (PVAR-TO-TVARP pvar))
		    (tvarn (PVAR-TO-TVARN pvar))
		    (type (apply mk-arrow (append (list tvarp tvarn)
						  types (list (py "boole")))))
		    (var (type-to-new-var type)))
	       (set! assoc-list (cons (list pvar var) assoc-list))
	       var)))))))))

(define (formula-to-d-formula formula)
  (let* ((pvar-to-var (make-pvar-to-var))
	 (types (formula-to-etd-types formula))
	 (typep (car types))
	 (typen (cadr types))
	 (p? (nulltype? typep))
	 (n? (nulltype? typen)))
    (cond
     ((and (not p?) (not n?))
      (let* ((x (type-to-new-var typep))
	     (y (type-to-new-var typen))
	     (real (make-term-in-var-form x))
	     (chal (make-term-in-var-form y)))
	(make-ex x (make-all y (real-and-chal-and-formula-to-d-formula-aux
				real chal formula pvar-to-var)))))
     ((and (not p?) n?)
      (let* ((x (type-to-new-var typep))
	     (real (make-term-in-var-form x)))
	(make-ex x (real-and-chal-and-formula-to-d-formula-aux
		    real 'eps formula pvar-to-var))))
     ((and p? (not n?))
      (let* ((y (type-to-new-var typen))
	     (chal (make-term-in-var-form y)))
	(make-all y (real-and-chal-and-formula-to-d-formula-aux
		     'eps chal formula pvar-to-var))))
     ((and p? n?)
      (real-and-chal-and-formula-to-d-formula-aux
       'eps 'eps formula pvar-to-var)))))

; (pp (formula-to-d-formula (pf "ex boole1 all boole2 boole1=boole2")))
; (pp (formula-to-d-formula (pf "all boole1 ex boole2 boole1=boole2")))
; (pp (formula-to-d-formula (pf "all nat1 exca nat2 nat1<nat2")))

(define (real-and-chal-and-formula-to-d-formula real chal formula)
  (let* ((pvar-to-var (make-pvar-to-var))
	 (types (formula-to-etd-types formula))
	 (typep (car types))
	 (typen (cadr types)))
    (if (not (or (and (eq? 'eps real) (nulltype? typep))
		 (and (term-form? real) (equal? (term-to-type real) typep))))
	(myerror "real-and-chal-and-formula-to-d-formula"
		 "equal types expected"
		 (if (term-form? real) (term-to-type real) real)
		 typep))
    (if (not (or (and (eq? 'eps chal) (nulltype? typen))
		 (and (term-form? chal) (equal? (term-to-type chal) typen))))
	(myerror "real-and-chal-and-formula-to-d-formula"
		 "equal types expected"
		 (if (term-form? chal) (term-to-type chal) chal)
		 typen))
    (real-and-chal-and-formula-to-d-formula-aux real chal formula
						pvar-to-var)))

(define (real-and-chal-and-formula-to-d-formula-aux real chal formula
						    pvar-to-var)
  (case (tag formula)
    ((atom) formula)
    ((predicate)
     (let ((pred (predicate-form-to-predicate formula))
	   (args (predicate-form-to-args formula)))
       (if
	(pvar-form? pred)
	(let* ((h-deg-one? (not (pvar-with-positive-content? pred)))
	       (n-deg-one? (not (pvar-with-negative-content? pred)))
	       (real-and-chal (cond ((and h-deg-one? n-deg-one?) '())
				    (n-deg-one? (list real))
				    (h-deg-one? (list chal))
				    (else (list real chal)))))
	  (make-atomic-formula
	   (apply mk-term-in-app-form
		  (cons (make-term-in-var-form (pvar-to-var pred))
			(append real-and-chal args)))))
	formula)))
    ((imp)
     (let* ((prem (imp-form-to-premise formula))
	    (conc (imp-form-to-conclusion formula))
	    (p1? (formula-of-nulltypep? prem))
	    (n1? (formula-of-nulltypen? prem))
	    (p2? (formula-of-nulltypep? conc))
	    (n2? (formula-of-nulltypen? conc))
	    (real1-and-chal1-and-real2-and-chal2
	     (cond
	      ((and p1? n1? p2? n2?)                         ;Case 1
	       (list 'eps 'eps 'eps 'eps)) 
	      ((and p1? n1? p2? (not n2?))                   ;Case 2
	       (list 'eps 'eps 'eps chal)) 
	      ((and p1? n1? (not p2?) n2?)                   ;Case 3
	       (list 'eps 'eps real 'eps)) 
	      ((and p1? n1? (not p2?) (not n2?))             ;Case 4
	       (list 'eps 'eps real chal)) 
	      ((and p1? (not n1?) p2? n2?)                   ;Case 5	       
	       (list 'eps real 'eps 'eps)) 
	      ((and p1? (not n1?) p2? (not n2?))             ;Case 6
	       (list 'eps (make-term-in-app-form real chal) 'eps chal)) 
	      ((and p1? (not n1?) (not p2?) n2?)             ;Case 7
	       (list 'eps (make-term-in-rcomp-form real)
		     (make-term-in-lcomp-form real) 'eps)) 
	      ((and p1? (not n1?) (not p2?) (not n2?))       ;Case 8
	       (list 'eps (mk-term-in-app-form real 'right chal)
		     (make-term-in-lcomp-form real) chal))
	      ((and (not p1?) n1? p2? n2?)                   ;Case 9
	       (list chal 'eps 'eps 'eps))
	      ((and (not p1?) n1? p2? (not n2?))             ;Case 10
	       (list (make-term-in-lcomp-form chal) 'eps
		     'eps (make-term-in-rcomp-form chal))) 
	      ((and (not p1?) n1? (not p2?) n2?)             ;Case 11
	       (list chal 'eps (make-term-in-app-form real chal) 'eps)) 
	      ((and (not p1?) n1? (not p2?) (not n2?))       ;Case 12
	       (list (make-term-in-lcomp-form chal) 'eps
		     (make-term-in-app-form
		      real (make-term-in-lcomp-form chal))
		     (make-term-in-rcomp-form chal)))
	      ((and (not p1?) (not n1?) p2? n2?)             ;Case 13     
	       (list chal (make-term-in-app-form real chal) 'eps 'eps)) 
	      ((and (not p1?) (not n1?) p2? (not n2?))       ;Case 14
	       (list (make-term-in-lcomp-form chal)
		     (mk-term-in-app-form
		      real
		      (make-term-in-lcomp-form chal)
		      (make-term-in-rcomp-form chal))
		     'eps (make-term-in-rcomp-form chal)))
	      ((and (not p1?) (not n1?) (not p2?) n2?)       ;Case 15
	       (list chal (mk-term-in-app-form real 'right chal)
		     (mk-term-in-app-form real 'left chal) 'eps))
	      ((and (not p1?) (not n1?) (not p2?) (not n2?)) ;Case 16
	       (list (make-term-in-lcomp-form chal)
		     (mk-term-in-app-form
		      real 'right
		      (make-term-in-lcomp-form chal)
		      (make-term-in-rcomp-form chal))
		     (mk-term-in-app-form
		      real 'left (make-term-in-lcomp-form chal))
		     (make-term-in-rcomp-form chal)))))
	    (real1 (car real1-and-chal1-and-real2-and-chal2))
	    (chal1 (cadr real1-and-chal1-and-real2-and-chal2))
	    (real2 (caddr real1-and-chal1-and-real2-and-chal2))
	    (chal2 (cadddr real1-and-chal1-and-real2-and-chal2)))
       (make-imp (real-and-chal-and-formula-to-d-formula-aux
		  real1 chal1 prem pvar-to-var)
		 (real-and-chal-and-formula-to-d-formula-aux
		  real2 chal2 conc pvar-to-var))))
    ((and)
     (let* ((left (and-form-to-left formula))
	    (right (and-form-to-right formula))
	    (p1? (formula-of-nulltypep? left))
	    (n1? (formula-of-nulltypen? left))
	    (p2? (formula-of-nulltypep? right))
	    (n2? (formula-of-nulltypen? right))
	    (real1-and-chal1-and-real2-and-chal2
	     (cond
	      ((and p1? n1? p2? n2?)                         ;Case 1
	       (list 'eps 'eps 'eps 'eps)) 
	      ((and p1? n1? p2? (not n2?))                   ;Case 2
	       (list 'eps 'eps 'eps chal)) 
	      ((and p1? n1? (not p2?) n2?)                   ;Case 3
	       (list 'eps 'eps real 'eps)) 
	      ((and p1? n1? (not p2?) (not n2?))             ;Case 4
	       (list 'eps 'eps real chal)) 
	      ((and p1? (not n1?) p2? n2?)                   ;Case 5	       
	       (list 'eps real 'eps 'eps)) 
	      ((and p1? (not n1?) p2? (not n2?))             ;Case 6
	       (list 'eps (make-term-in-lcomp-form chal)
		     'eps (make-term-in-rcomp-form chal)))
	      ((and p1? (not n1?) (not p2?) n2?)             ;Case 7
	       (list 'eps chal real 'eps))
	      ((and p1? (not n1?) (not p2?) (not n2?))       ;Case 8
	       (list 'eps (make-term-in-lcomp-form chal)
		     real (make-term-in-rcomp-form chal)))
	      ((and (not p1?) n1? p2? n2?)                   ;Case 9
	       (list real 'eps 'eps 'eps))
	      ((and (not p1?) n1? p2? (not n2?))             ;Case 10
	       (list real 'eps 'eps chal)) 
	      ((and (not p1?) n1? (not p2?) n2?)             ;Case 11
	       (list (make-term-in-lcomp-form real) 'eps
		     (make-term-in-rcomp-form real) 'eps))
	      ((and (not p1?) n1? (not p2?) (not n2?))       ;Case 12
	       (list (make-term-in-lcomp-form real) 'eps
		     (make-term-in-rcomp-form real) chal))
	      ((and (not p1?) (not n1?) p2? n2?)             ;Case 13
	       (list real chal 'eps 'eps)) 
	      ((and (not p1?) (not n1?) p2? (not n2?))       ;Case 14
	       (list real (make-term-in-lcomp-form chal)
		     'eps (make-term-in-rcomp-form chal)))
	      ((and (not p1?) (not n1?) (not p2?) n2?)       ;Case 15
	       (list (make-term-in-lcomp-form real) chal
		     (make-term-in-rcomp-form real) 'eps))
	      ((and (not p1?) (not n1?) (not p2?) (not n2?)) ;Case 16
	       (list (make-term-in-lcomp-form real)
		     (make-term-in-lcomp-form chal)
		     (make-term-in-rcomp-form real)
		     (make-term-in-rcomp-form chal)))))
	    (real1 (car real1-and-chal1-and-real2-and-chal2))
	    (chal1 (cadr real1-and-chal1-and-real2-and-chal2))
	    (real2 (caddr real1-and-chal1-and-real2-and-chal2))
	    (chal2 (cadddr real1-and-chal1-and-real2-and-chal2)))
       (make-and (real-and-chal-and-formula-to-d-formula-aux
		  real1 chal1 left pvar-to-var)
		 (real-and-chal-and-formula-to-d-formula-aux
		  real2 chal2 right pvar-to-var))))
    ((all)
     (let* ((var (all-form-to-var formula))
	    (kernel (all-form-to-kernel formula))
	    (p? (formula-of-nulltypep? kernel))
	    (n? (formula-of-nulltypen? kernel))
	    (new-kernel-and-real-and-chal
	     (cond
	      ((and p? n?)                         ;Case 1
	       (list (formula-subst kernel var chal)
		     'eps 'eps)) 
	      ((and p? (not n?))                   ;Case 5	       
	       (list (formula-subst kernel var (make-term-in-lcomp-form chal))
		     'eps (make-term-in-rcomp-form chal)))
	      ((and (not p?) n?)                   ;Case 9
	       (list (formula-subst kernel var chal)
		     (make-term-in-app-form real chal) 'eps))
	      ((and (not p?) (not n?))             ;Case 13	       
	       (list (formula-subst kernel var (make-term-in-lcomp-form chal))
		     (make-term-in-app-form
		      real (make-term-in-lcomp-form chal))
		     (make-term-in-rcomp-form chal)))))
	    (new-kernel (car new-kernel-and-real-and-chal))
	    (new-real (cadr new-kernel-and-real-and-chal))
	    (new-chal (caddr new-kernel-and-real-and-chal)))
       (real-and-chal-and-formula-to-d-formula-aux
	new-real new-chal new-kernel pvar-to-var)))
    ((ex)
     (let* ((var (ex-form-to-var formula))
	    (kernel (ex-form-to-kernel formula))
	    (p? (formula-of-nulltypep? kernel))
	    (new-kernel-and-real-and-chal
	     (if
	      p?
	      (list (formula-subst kernel var real) 'eps chal)
	      (list (formula-subst kernel var (make-term-in-lcomp-form real))
		    (make-term-in-rcomp-form real)
		    chal)))
	    (new-kernel (car new-kernel-and-real-and-chal))
	    (new-real (cadr new-kernel-and-real-and-chal))
	    (new-chal (caddr new-kernel-and-real-and-chal)))
       (real-and-chal-and-formula-to-d-formula-aux
	new-real new-chal new-kernel pvar-to-var)))
    ((allnc)
     (let ((var (allnc-form-to-var formula))
	   (kernel (allnc-form-to-kernel formula)))
       (make-all var (real-and-chal-and-formula-to-d-formula-aux
		      real chal kernel pvar-to-var))))
    ((exnc)
     (let ((var (exnc-form-to-var formula))
	   (kernel (exnc-form-to-kernel formula)))
       (make-ex var (real-and-chal-and-formula-to-d-formula-aux
		     real chal kernel pvar-to-var))))
    ((exca excl)
     (real-and-chal-and-formula-to-d-formula-aux
      real chal (unfold-formula formula) pvar-to-var))
    (else (myerror "real-and-chal-and-formula-to-d-formula-aux"
		   "formula expected"
		   formula))))

; We assign to a proof M a term [M]^+ (real) and an alist associating
; terms to avars: u_i mapsto [M]^-_i (chals).  All these terms may
; contain the x_u_i's free, and in addition the [M]^-_i may contain y
; free.  Here the x_u_i's are given by a local variable
; avar-of-typep-to-var, and y is given by a local variable
; formula-of-typen-to-var.  x_u_i has typep of the assumed formula,
; and y has typen of the goal formula.  Moreover, we need pvar-to-var
; to build terms from formulas when contracting.

(define (make-avar-of-typep-to-var)
					;returns a procedure assigning to
					;assumption variables new object vars
					;of the corresponding etdp-type.  
					;Remembers the assignment done so far.
  (let ((avar-assoc-list '()))
    (lambda (avar)
      (let ((info (assoc-wrt avar=? avar avar-assoc-list)))
	(if info
	    (cadr info)
	    (let* ((formula (avar-to-formula avar))
		   (type (formula-to-etdp-type formula))
		   (new-var (type-to-new-var type)))
	      (begin (set! avar-assoc-list
			   (cons (list avar new-var) avar-assoc-list))
		     new-var)))))))

(define (make-formula-of-typen-to-var)
  (let ((formula-assoc-list '()))
    (lambda (formula)
      (let ((info (assoc-wrt classical-formula=? formula formula-assoc-list)))
	(if info
	    (cadr info)
	    (let* ((typen (formula-to-etdn-type formula))
		   (new-var (type-to-new-var typen)))
	      (begin (set! formula-assoc-list
			   (cons (list formula new-var) formula-assoc-list))
		     new-var)))))))

(define (proof-without-d-real-or-chals? proof)
  (let* ((formula (proof-to-formula proof))
	 (context (proof-to-context proof))
	 (avars (context-to-avars context))
	 (avar-formulas (map avar-to-formula avars)))
    (and (formula-of-nulltypep? formula)
	 (apply and-op (map formula-of-nulltypen? avar-formulas)))))

(define (proof-to-extracted-d-term proof)
  (let* ((d-terms (proof-to-extracted-d-terms proof))
	 (real (car d-terms))
	 (rest (cdr d-terms)))
    (if (pair? rest)
	(apply myerror (append (list "proof-to-extracted-d-term"
				     "proof contains free assumptions")
			       (map car rest))))
    real))

(define (proof-to-extracted-d-terms proof)
  (let ((avar-of-typep-to-var (make-avar-of-typep-to-var))
	(formula-of-typen-to-var (make-formula-of-typen-to-var))
	(pvar-to-var (make-pvar-to-var)))
    (proof-to-extracted-d-terms-aux
     proof avar-of-typep-to-var formula-of-typen-to-var pvar-to-var)))

(define (proof-to-extracted-d-terms-aux
	 proof avar-of-typep-to-var formula-of-typen-to-var pvar-to-var)
  (if
   (proof-without-d-real-or-chals? proof)
   (cons 'eps (map (lambda (avar) (list avar 'eps))
		   (context-to-avars (proof-to-context proof))))
   (case (tag proof)
     ((proof-in-avar-form)
      (let* ((avar (proof-in-avar-form-to-avar proof))
	     (formula (avar-to-formula avar))
	     (types (formula-to-etd-types formula))
	     (typep (car types))
	     (typen (cadr types))
	     (p? (nulltype? typep))
	     (n? (nulltype? typen)))
	(list (if (not p?)
		  (make-term-in-var-form (avar-of-typep-to-var avar))
		  'eps)
	      (list avar (if (not n?)
			     (make-term-in-var-form
			      (formula-of-typen-to-var formula))
			     'eps)))))
     ((proof-in-aconst-form)
      (let* ((aconst (proof-in-aconst-form-to-aconst proof))
	     (name (aconst-to-name aconst))
	     (p? (formula-of-nulltypep? (aconst-to-formula aconst))))
	(if
	 p? 'eps
	 (case (aconst-to-kind aconst)
	   ((axiom)
	    (cond ((string=? "Ind" name)
		   (myerror "not implemented" "Ind"))
		  ((string=? "Cases" name)
		   (myerror "not implemented" "Cases"))
		  ((string=? "Intro" name)
		   (myerror "not implemented" "Intro"))
		  ((string=? "Elim" name)
		   (myerror "not implemented" "Elim"))
		  ((string=? "Ex-Intro" name)
		   (list (ex-formula-to-ex-intro-extracted-d-term
			  (car (aconst-to-repro-formulas aconst)))))
		  ((string=? "Ex-Elim" name)
		   (myerror "not implemented" "Ex-Elim"))
		  ((string=? "Exnc-Intro" name)
		   (myerror "not yet implemented" "Exnc-Intro"))
		  ((string=? "Exnc-Elim" name)
		   (myerror "not yet implemented" "Exnc-Elim"))
		  (else (myerror "proof-to-extracted-d-terms-aux"
				 "unexpected axiom" name))))
	   ((theorem)
	    (let ((info (assoc name INITIAL-THEOREMS)))
	      (if info
		  (let* ((formula (unfold-formula (aconst-to-formula aconst)))
			 (type (formula-to-et-type formula))
			 (arg-type (if (arrow-form? type)
				       (arrow-form-to-arg-type type)
				       (myerror
					"proof-to-extracted-d-terms-aux"
					"arrow type expected"
					type)))
			 (var (type-to-new-var arg-type)))
		    (list (make-term-in-abst-form
			   var (make-term-in-var-form var))))
		  (list (make-term-in-const-form
			 (theorem-or-global-assumption-to-d-pconst aconst))))))
	   ((global-assumption)
	    (let ((info (assoc name GLOBAL-ASSUMPTIONS)))
	      (if
	       info
	       (cond
		((string=? "Stab-Log" name)
		 (let* ((formula (unfold-formula (proof-to-formula proof)))
			(kernel (allnc-form-to-final-kernel formula))
			(concl (imp-form-to-conclusion kernel)))
		   (case (tag concl)
		     ((atom predicate ex exnc)
		      (make-term-in-const-form
		       (theorem-or-global-assumption-to-d-pconst aconst)))
		     ((imp and all allnc) ;recursive call
		      (if ;atr-case, i.e. bot -> atrX^ in tpinst
		       (formula=? atr-x-formula
				  (imp-form-to-conclusion
				   (imp-form-to-premise kernel)))
		       (let* ((orig-concl
			       (formula-subst
				concl atr-x-pvar (make-cterm falsity-log)))
			      (stab-log-proof
			       (proof-of-stab-log-at orig-concl))
			      (subst-stab-log-proof
			       (proof-subst
				stab-log-proof falsity-log-pvar atr-x-cterm)))
			 (proof-to-extracted-d-terms-aux
			  subst-stab-log-proof avar-of-typep-to-var))
		       (proof-to-extracted-d-terms-aux
			(proof-of-stab-log-at concl) avar-of-typep-to-var)))
		     (else (myerror
			    "proof-to-extracted-d-terms-aux" "formula expected"
			    (formula-to-string concl))))))
		((string=? "Efq-Log" name)
		 (let* ((formula (unfold-formula (proof-to-formula proof)))
			(kernel (allnc-form-to-final-kernel formula))
			(concl (imp-form-to-conclusion kernel)))
		   (case (tag concl)
		     ((atom predicate ex exnc)
		      (let* ((type (formula-to-et-type concl))
			     (inhab (type-to-canonical-inhabitant type)))
			(comment "Efq-Log realized by canonical inhabitant "
				 (term-to-string inhab))
			inhab))
		     ((imp and all allnc) ;recursive call
		      (if ;atr-case, i.e. bot -> atrX^ in tpinst
		       (formula=? atr-x-formula (imp-form-to-premise kernel))
		       (let* ((orig-concl
			       (formula-subst
				concl atr-x-pvar (make-cterm falsity-log)))
			      (efq-log-proof (proof-of-efq-log-at orig-concl))
			      (subst-efq-log-proof
			       (proof-subst
				efq-log-proof falsity-log-pvar atr-x-cterm)))
			 (proof-to-extracted-d-terms-aux
			  subst-efq-log-proof avar-of-typep-to-var))
		       (proof-to-extracted-d-terms-aux
			(proof-of-efq-log-at concl) avar-of-typep-to-var)))
		     (else (myerror
			    "proof-to-extracted-d-terms-aux" "formula expected"
			    (formula-to-string concl))))))
		((string=? "Efq" name)
		 (let* ((formula (proof-to-formula proof))
			(etype (formula-to-et-type formula)))
		   (type-to-canonical-inhabitant etype)))
		((or (and (<= (string-length "Eq-Compat-Rev")
			      (string-length name))
			  (string=?
			   (substring name 0 (string-length "Eq-Compat-Rev"))
			   "Eq-Compat-Rev"))
		     (and (<= (string-length "Compat-Rev")
			      (string-length name))
			  (string=?
			   (substring name 0 (string-length "Compat-Rev"))
			   "Compat-Rev"))
		     (and (<= (string-length "Compat")
			      (string-length name))
			  (string=?
			   (substring name 0 (string-length "Compat"))
			   "Compat")))
		 (let* ((formula (unfold-formula (aconst-to-formula aconst)))
			(type (formula-to-et-type formula))
			(arg-type (if (arrow-form? type)
				      (arrow-form-to-arg-type type)
				      (myerror "proof-to-extracted-d-terms-aux"
					       "arrow type expected"
					       type)))
			(var (type-to-new-var arg-type)))
		   (make-term-in-abst-form var (make-term-in-var-form var))))
		(else
		 (make-term-in-const-form
		  (theorem-or-global-assumption-to-d-pconst aconst))))
	       (myerror "proof-to-extracted-d-terms-aux"
			"global assumption expected"
			name))))
	   (else (myerror "proof-to-extracted-d-terms-aux"
			  "unknown kind of aconst"
			  (aconst-to-kind aconst)))))))
     ((proof-in-imp-intro-form)
      (let* ((avar (proof-in-imp-intro-form-to-avar proof))
	     (kernel (proof-in-imp-intro-form-to-kernel proof))
	     (prev (proof-to-extracted-d-terms-aux
		    kernel
		    avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	     (avars-and-chals (cdr prev))
	     (rest-avars-and-chals
	      (list-transform-positive avars-and-chals
		(lambda (p) (not (avar=? (car p) avar)))))
	     (info (assoc-wrt avar=? avar avars-and-chals))
	     (formula (proof-to-formula proof))
	     (prem (imp-form-to-premise formula))
	     (conc (imp-form-to-conclusion formula))
	     (types1 (formula-to-etd-types prem))
	     (types2 (formula-to-etd-types conc))
	     (typep1 (car types1))
	     (typen1 (cadr types1))
	     (typep2 (car types2))
	     (typen2 (cadr types2))
	     (p1? (nulltype? typep1))
	     (n1? (nulltype? typen1))
	     (p2? (nulltype? typep2))
	     (n2? (nulltype? typen2)))
	(cond
	 ((and p1? n1? p2? n2?)                         ;Case 1
	  (cons 'eps rest-avars-and-chals))
	 ((and p1? n1? p2? (not n2?))                   ;Case 2
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (kernel-real (car prev)) ;t
		 (real kernel-real)
					;substitute y for z:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) kernel-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and p1? n1? (not p2?) n2?)                   ;Case 3
	  (let* ((kernel-real (car prev)) ;t
		 (real kernel-real))
	    (cons real rest-avars-and-chals)))
	 ((and p1? n1? (not p2?) (not n2?))             ;Case 4
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (kernel-real (car prev)) ;t
		 (real kernel-real)
					;substitute y for z:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) kernel-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and p1? (not n1?) p2? n2?)                   ;Case 5	       
	  (let* ((arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1)))) ;r
	    (cons arg-chal rest-avars-and-chals)))
	 ((and p1? (not n1?) p2? (not n2?))             ;Case 6
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (mk-term-in-abst-form kernel-var arg-chal))
					;substitute y for z:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) kernel-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and p1? (not n1?) (not p2?) n2?)             ;Case 7
	  (let* ((kernel-real (car prev)) ;t
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (make-term-in-pair-form kernel-real arg-chal)))
	    (cons real rest-avars-and-chals)))
	 ((and p1? (not n1?) (not p2?) (not n2?))       ;Case 8
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (kernel-real (car prev)) ;t
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (make-term-in-pair-form
			kernel-real
			(mk-term-in-abst-form kernel-var arg-chal)))
					;substitute y for z:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) kernel-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) n1? p2? n2?)                   ;Case 9
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
					;substitute y for x:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) arg-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons 'eps rest-avars-and-subst-chals)))
	 ((and (not p1?) n1? p2? (not n2?))             ;Case 10
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-var (formula-of-typen-to-var conc)) ;z
					;substitute y0,y1 for x,z:
		 (rest-avars-and-subst-chals
		  (map
		   (lambda (p)
		     (list
		      (car p)
		      (term-or-eps-substitute
		       (cadr p)
		       (list (list arg-var
				   (make-term-in-lcomp-form chal-varterm))
			     (list kernel-var
				   (make-term-in-rcomp-form chal-varterm))))))
		   rest-avars-and-chals)))
	    (cons 'eps rest-avars-and-subst-chals)))
	 ((and (not p1?) n1? (not p2?) n2?)             ;Case 11
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-real (car prev)) ;t
		 (real (make-term-in-abst-form arg-var kernel-real))
					;substitute y for x:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) arg-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) n1? (not p2?) (not n2?))       ;Case 12
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (kernel-real (car prev)) ;t
		 (real (make-term-in-abst-form arg-var kernel-real))
					;substitute y0,y1 for x,z:
		 (rest-avars-and-subst-chals
		  (map
		   (lambda (p)
		     (list
		      (car p)
		      (term-or-eps-substitute
		       (cadr p)
		       (list (list arg-var
				   (make-term-in-lcomp-form chal-varterm))
			     (list kernel-var
				   (make-term-in-rcomp-form chal-varterm))))))
		   rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) (not n1?) p2? n2?)             ;Case 13     
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (mk-term-in-abst-form arg-var arg-chal))
					;substitute y for x:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) arg-var chal-varterm)))
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) (not n1?) p2? (not n2?))       ;Case 14
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (mk-term-in-abst-form arg-var kernel-var arg-chal))
					;substitute y0,y1 for x,z:
		 (rest-avars-and-subst-chals
		  (map
		   (lambda (p)
		     (list
		      (car p)
		      (term-or-eps-substitute
		       (cadr p)
		       (list (list arg-var
				   (make-term-in-lcomp-form chal-varterm))
			     (list kernel-var
				   (make-term-in-rcomp-form chal-varterm))))))
		   rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) (not n1?) (not p2?) n2?)       ;Case 15
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-real (car prev)) ;t
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (make-term-in-pair-form
			(make-term-in-abst-form arg-var kernel-real)
			(mk-term-in-abst-form arg-var arg-chal)))
					;substitute y for x:
		 (rest-avars-and-subst-chals
		  (map (lambda (p)
			 (list (car p)
			       (term-or-eps-subst
				(cadr p) arg-var chal-varterm)))
		       
		       rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 ((and (not p1?) (not n1?) (not p2?) (not n2?)) ;Case 16
	  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
		 (chal-varterm (make-term-in-var-form chal-var))
		 (arg-var (avar-of-typep-to-var avar)) ;x
		 (kernel-var (formula-of-typen-to-var conc)) ;z
		 (kernel-real (car prev)) ;t
		 (arg-chal (if info (cadr info)
			       (type-to-canonical-inhabitant typen1))) ;r
		 (real (make-term-in-pair-form
			(make-term-in-abst-form arg-var kernel-real)
			(mk-term-in-abst-form arg-var kernel-var arg-chal)))
					;substitute y0,y1 for x,z:
		 (rest-avars-and-subst-chals
		  (map
		   (lambda (p)
		     (list
		      (car p)
		      (term-or-eps-substitute
		       (cadr p)
		       (list (list arg-var
				   (make-term-in-lcomp-form chal-varterm))
			     (list kernel-var
				   (make-term-in-rcomp-form chal-varterm))))))
		   rest-avars-and-chals)))
	    (cons real rest-avars-and-subst-chals)))
	 (else (myerror "this cannot happen")))))
     ((proof-in-imp-elim-form)
      (cond
       ((proof-in-ind-rule-form? proof)
	(let* ((final-op (proof-to-final-allnc-elim-op
			  (proof-to-final-imp-elim-op proof)))
	       (aconst (proof-in-aconst-form-to-aconst final-op))
	       (steps (proof-to-imp-elim-args proof))
	       (prevs (map (lambda (step)
			     (proof-to-extracted-d-terms-aux
			      step avar-of-typep-to-var formula-of-typen-to-var
			      pvar-to-var))
			   steps))
	       (step-reals (map car prevs))
	       (avars-with-duplicates (map car (apply append (map cdr prevs))))
	       (avars (remove-duplicates-wrt avar=? avars-with-duplicates))
	       (all-formulas (aconst-to-repro-formulas aconst))
	       (rec-const (apply all-formulas-to-etd-rec-const all-formulas))
	       (step-flas (map proof-to-formula steps))
	       (uninst-fla (aconst-to-uninst-formula
			    (apply all-formulas-to-ind-aconst all-formulas)))
	       (uninst-step-flas (imp-form-to-premises uninst-fla))
	       (varss (map (lambda (step-fla uninst-step-fla)
			     (if (all-form? uninst-step-fla)
				 (all-form-to-vars step-fla)
				 '()))
			   step-flas uninst-step-flas))
	       (xs ;(...,x,...)
		(map (lambda (fla) (if (formula-of-nulltypen? fla) 'eps
				       (formula-of-typen-to-var fla)))
		     step-flas))
	       (all-formula (proof-to-formula proof))
	       (chal-var (formula-of-typen-to-var all-formula)) ;y
	       (kernel (all-form-to-kernel all-formula))
	       (p? (formula-of-nulltypep? kernel))
	       (n? (formula-of-nulltypen? kernel))
	       (z (if n? 'eps (formula-of-typen-to-var kernel))))
	  (if (> (length all-formulas) 1)
	      (myerror "Not implemented for simultaneous induction"))
	  (cond
	   ((and (not p?) (not n?))
	    (let* ((step-reals0 ;(...,lambda n tn0,...)
		    (map (lambda (vars t)
			   (apply
			    mk-term-in-abst-form
			    (append
			     vars (list (apply
					 mk-term-in-app-form
					 (append
					  (list t)
					  (map make-term-in-var-form vars)
					  (list 'left)))))))
			 varss step-reals))
		   (real ;tilde{t}
		    (apply mk-term-in-app-form
			   (cons (make-term-in-const-form rec-const)
				 step-reals0)))
		   (recargs-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x t chal)
			     (if
			      (null? vars) ;base case
			      (make-term-in-abst-form z chal)
			      (let* ((pd-var ;p
				      (type-to-new-var
				       (make-arrow
					(formula-to-etdn-type kernel)
					(formula-to-etdn-type
					 (avar-to-formula avar)))))
				     (pd-real ;tilde{t}n
				      (apply
				       mk-term-in-app-form
				       (cons real (map make-term-in-var-form
						       vars))))
				     (chal-tuple ;<n, tilde{t}n, z>
				      (apply
				       mk-term-in-pair-form
				       (append (map make-term-in-var-form vars)
					       (list pd-real
						     (make-term-in-var-form
						      z)))))
				     (subst-chal ;s = r_i[x:=<n, tilde{t}n, z>]
				      (term-subst chal x chal-tuple))
				     (step-real1 ;tn1
				      (apply mk-term-in-app-form
					     (append
					      (list t)
					      (map make-term-in-var-form vars)
					      (list 'right))))
				     (pd-chal ;tn1(tilde{t}n)z
				      (mk-term-in-app-form
				       step-real1 pd-real
				       (make-term-in-var-form z)))
				     (if-term (contract
					       avar
					       avar-of-typep-to-var
					       formula-of-typen-to-var
					       pvar-to-var
					       subst-chal
					       (make-term-in-app-form
						(make-term-in-var-form pd-var)
						pd-chal))))
				(apply mk-term-in-abst-form
				       (append
					vars (list pd-var z if-term))))))
			   varss xs step-reals chals))))
		     avars))
		   (rec-consts
		    (map (lambda (avar)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (car (arrow-types-to-rec-consts
				  (mk-arrow
				   (var-to-type (all-form-to-var all-formula))
				   (formula-to-etdn-type kernel)
				   (formula-to-etdn-type
				    (avar-to-formula avar)))))))
			 avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar rec-const recargs)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (apply mk-term-in-app-form
				   (cons (make-term-in-const-form rec-const)
					 recargs))))
			 avars rec-consts recargs-list)))
	      (cons real
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-lcomp-form
				  (make-term-in-var-form chal-var))
				 (make-term-in-rcomp-form
				  (make-term-in-var-form chal-var))))))
			 avars chals))))
	   ((and (not p?) n?)
	    (let* ((real ;tilde{t}
		    (apply mk-term-in-app-form
			   (cons (make-term-in-const-form rec-const)
				 step-reals)))
		   (recargs-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x t chal)
			     (if
			      (null? vars) ;base case
			      chal
			      (let* ((pd-var ;p
				      (type-to-new-var
				       (formula-to-etdn-type
					(avar-to-formula avar))))
				     (pd-real ;tilde{t}n
				      (apply
				       mk-term-in-app-form
				       (cons real (map make-term-in-var-form
						       vars))))
				     (chal-tuple ;<n, tilde{t}n>
				      (apply
				       mk-term-in-pair-form
				       (append (map make-term-in-var-form vars)
					       (list pd-real))))
				     (subst-chal ;s = r_i[x:=<n, tilde{t}n>]
				      (term-subst chal x chal-tuple))
				     (if-term (contract
					       avar
					       avar-of-typep-to-var
					       formula-of-typen-to-var
					       pvar-to-var
					       subst-chal
					       (make-term-in-var-form
						pd-var))))
				(apply mk-term-in-abst-form
				       (append
					vars (list pd-var if-term))))))
			   varss xs step-reals chals))))
		     avars))
		   (rec-consts
		    (map (lambda (avar)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (car (arrow-types-to-rec-consts
				  (mk-arrow
				   (var-to-type (all-form-to-var all-formula))
				   (formula-to-etdn-type
				    (avar-to-formula avar)))))))
			 avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar rec-const recargs)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (apply mk-term-in-app-form
				   (cons (make-term-in-const-form rec-const)
					 recargs))))
			 avars rec-consts recargs-list)))
	      (cons real
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(make-term-in-app-form
				 chal
				 (make-term-in-var-form chal-var)))))
			 avars chals))))
	   ((and p? (not n?))
	    (let* ((recargs-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x t chal)
			     (if
			      (null? vars) ;base case
			      (make-term-in-abst-form z chal)
			      (let* ((pd-var ;p
				      (type-to-new-var
				       (make-arrow
					(formula-to-etdn-type kernel)
					(formula-to-etdn-type
					 (avar-to-formula avar)))))
				     (chal-tuple ;<n,z>
				      (apply
				       mk-term-in-pair-form
				       (append (map make-term-in-var-form vars)
					       (list (make-term-in-var-form
						      z)))))
				     (subst-chal ;s = r_i[x:=<n,z>]
				      (term-subst chal x chal-tuple))
				     (pd-chal ;tnz
				      (apply mk-term-in-app-form
					     (append
					      (list t)
					      (map make-term-in-var-form vars)
					      (list (make-term-in-var-form
						     z)))))
				     (if-term (contract
					       avar
					       avar-of-typep-to-var
					       formula-of-typen-to-var
					       pvar-to-var
					       subst-chal
					       (make-term-in-app-form
						(make-term-in-var-form pd-var)
						pd-chal))))
				(apply mk-term-in-abst-form
				       (append
					vars (list pd-var z if-term))))))
			   varss xs step-reals chals))))
		     avars))
		   (rec-consts
		    (map (lambda (avar)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (car (arrow-types-to-rec-consts
				  (mk-arrow
				   (var-to-type (all-form-to-var all-formula))
				   (formula-to-etdn-type kernel)
				   (formula-to-etdn-type
				    (avar-to-formula avar)))))))
			 avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar rec-const recargs)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (apply mk-term-in-app-form
				   (cons (make-term-in-const-form rec-const)
					 recargs))))
			 avars rec-consts recargs-list)))
	      (cons 'eps
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-lcomp-form
				  (make-term-in-var-form chal-var))
				 (make-term-in-rcomp-form
				  (make-term-in-var-form chal-var))))))
			 avars chals))))
	   ((and p? n?)
	    (let* ((recargs-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x chal)
			     (if
			      (null? vars) ;base case
			      chal
			      (let* ((pd-var ;p
				      (type-to-new-var
				       (formula-to-etdn-type
					(avar-to-formula avar))))
				     (chal-tuple ;<n>
				      (apply
				       mk-term-in-pair-form
				       (map make-term-in-var-form vars)))
				     (subst-chal ;s = r_i[x:=<n>]
				      (term-subst chal x chal-tuple))
				     (if-term (contract
					       avar
					       avar-of-typep-to-var
					       formula-of-typen-to-var
					       pvar-to-var
					       subst-chal
					       (make-term-in-var-form
						pd-var))))
				(apply mk-term-in-abst-form
				       (append
					vars (list pd-var if-term))))))
			   varss xs chals))))
		     avars))
		   (rec-consts
		    (map (lambda (avar)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (car (arrow-types-to-rec-consts
				  (mk-arrow
				   (var-to-type (all-form-to-var all-formula))
				   (formula-to-etdn-type
				    (avar-to-formula avar)))))))
			 avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar rec-const recargs)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (apply mk-term-in-app-form
				   (cons (make-term-in-const-form rec-const)
					 recargs))))
			 avars rec-consts recargs-list)))
	      (cons 'eps
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-var-form chal-var)))))
			 avars chals)))))))
       ((proof-in-cases-rule-form? proof)
	(let* ((final-op (proof-to-final-allnc-elim-op
			  (proof-to-final-imp-elim-op proof)))
	       (aconst (proof-in-aconst-form-to-aconst final-op))
	       (alts (proof-to-imp-elim-args proof))
	       (prevs (map (lambda (alt)
			     (proof-to-extracted-d-terms-aux
			      alt avar-of-typep-to-var formula-of-typen-to-var
			      pvar-to-var))
			   alts))
	       (alt-reals (map car prevs))
	       (avars-with-duplicates (map car (apply append (map cdr prevs))))
	       (avars (remove-duplicates-wrt avar=? avars-with-duplicates))
	       (all-formulas (aconst-to-repro-formulas aconst))
; 	       (if-term (cases-aconst-to-etd-if-term aconst))
	       (alt-flas (map proof-to-formula alts))
	       (uninst-fla (aconst-to-uninst-formula
			    (apply all-formulas-to-ind-aconst all-formulas)))
	       (uninst-alt-flas (imp-form-to-premises uninst-fla))
	       (varss (map (lambda (alt-fla uninst-alt-fla)
			     (if (all-form? uninst-alt-fla)
				 (all-form-to-vars alt-fla)
				 '()))
			   alt-flas uninst-alt-flas))
	       (xs ;(...,x,...)
		(map (lambda (fla) (if (formula-of-nulltypen? fla) 'eps
				       (formula-of-typen-to-var fla)))
		     alt-flas))
	       (all-formula (proof-to-formula proof))
	       (chal-var (formula-of-typen-to-var all-formula)) ;y
	       (kernel (all-form-to-kernel all-formula))
	       (p? (formula-of-nulltypep? kernel))
	       (n? (formula-of-nulltypen? kernel))
	       (z (if n? 'eps (formula-of-typen-to-var kernel))))
	  (if (> (length all-formulas) 1)
	      (myerror "Not implemented for simultaneous cases"))
	  (cond
	   ((and (not p?) (not n?))
	    (let* ((real ;tilde{t}
		    (all-formula-and-alts-to-etd-if-term
		     all-formula alt-reals))
		   (alts-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x chal)
			     (if
			      (null? vars) ;base case
			      (make-term-in-abst-form z chal)
			      (let* ((chal-tuple ;<n,z>
				      (apply
				       mk-term-in-pair-form
				       (append (map make-term-in-var-form vars)
					       (list (make-term-in-var-form
						      z)))))
				     (subst-chal ;s = r_i[x:=<n,z>]
				      (term-subst chal x chal-tuple)))
				(apply mk-term-in-abst-form
				       (append
					vars (list z subst-chal))))))
			   varss xs chals))))
		     avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar alts)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (all-formula-and-alts-to-etd-if-term
			     all-formula alts)))
			 avars alts-list)))
	      (cons real
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-lcomp-form
				  (make-term-in-var-form chal-var))
				 (make-term-in-rcomp-form
				  (make-term-in-var-form chal-var))))))
			 avars chals))))
	   ((and (not p?) n?)
	    (let* ((real ;tilde{t}
		    (all-formula-and-alts-to-etd-if-term
		     all-formula alt-reals))
		   (alts-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x chal)
			     (if
			      (null? vars) ;base case
			      chal
			      (let* ((chal-tuple ;<n>
				      (apply
				       mk-term-in-pair-form
				       (map make-term-in-var-form vars)))
				     (subst-chal ;s = r_i[x:=<n>]
				      (term-subst chal x chal-tuple)))
				(apply mk-term-in-abst-form
				       (append vars (list subst-chal))))))
			   varss xs chals))))
		     avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar alts)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (all-formula-and-alts-to-etd-if-term
			     all-formula alts)))
			 avars alts-list)))
	      (cons real
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(make-term-in-app-form
				 chal
				 (make-term-in-var-form chal-var)))))
			 avars chals))))
	   ((and p? (not n?))
	    (let* ((alts-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x chal)
			     (if
			      (null? vars) ;base case
			      (make-term-in-abst-form z chal)
			      (let* ((chal-tuple ;<n,z>
				      (apply
				       mk-term-in-pair-form
				       (append (map make-term-in-var-form vars)
					       (list (make-term-in-var-form
						      z)))))
				     (subst-chal ;s = r_i[x:=<n,z>]
				      (term-subst chal x chal-tuple)))
				(apply mk-term-in-abst-form
				       (append
					vars (list z subst-chal))))))
			   varss xs chals))))
		     avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar alts)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (all-formula-and-alts-to-etd-if-term
			     all-formula alts)))
			 avars alts-list)))
	      (cons 'eps
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-lcomp-form
				  (make-term-in-var-form chal-var))
				 (make-term-in-rcomp-form
				  (make-term-in-var-form chal-var))))))
			 avars chals))))
	   ((and p? n?)
	    (let* ((alts-list
		    (map
		     (lambda (avar)
		       (if
			(formula-of-nulltypen? (avar-to-formula avar))
			'eps
			(let ((chals
			       (map (lambda (prev)
				      (let* ((avar-chal-alist (cdr prev))
					     (info (assoc-wrt avar=? avar
							      avar-chal-alist))
					     (typen (formula-to-etdn-type
						     (avar-to-formula avar))))
					(cond
					 ((nulltype? typen) 'eps)
					 (info (cadr info))
					 (else (type-to-canonical-inhabitant
						typen)))))
				    prevs)))
			  (map
			   (lambda (vars x chal)
			     (if
			      (null? vars) ;base case
			      chal
			      (let* ((chal-tuple ;<n>
				      (apply
				       mk-term-in-pair-form
				       (map make-term-in-var-form vars)))
				     (subst-chal ;s = r_i[x:=<n>]
				      (term-subst chal x chal-tuple)))
				(apply mk-term-in-abst-form
				       (append
					vars (list subst-chal))))))
			   varss xs chals))))
		     avars))
		   (chals ;(...,\tilde{r}_i,...)
		    (map (lambda (avar alts)
			   (if
			    (formula-of-nulltypen? (avar-to-formula avar))
			    'eps
			    (all-formula-and-alts-to-etd-if-term
			     all-formula alts)))
			 avars alts-list)))
	      (cons 'eps
		    (map (lambda (avar chal)
			   (list
			    avar
			    (if (formula-of-nulltypen? (avar-to-formula avar))
				'eps
				(mk-term-in-app-form
				 chal
				 (make-term-in-var-form chal-var)))))
			 avars chals)))))))
       ((proof-in-ex-elim-rule-form? proof)
	(let* ((main (proof-in-imp-elim-form-to-arg
		      (proof-in-imp-elim-form-to-op proof)))
	       (side (proof-in-imp-elim-form-to-arg proof))
	       (side-prev
		(proof-to-extracted-d-terms-aux
		 side
		 avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	       (main-prev
		(proof-to-extracted-d-terms-aux
		 main
		 avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	       (side-real (car side-prev)) ;t
	       (side-avars-and-chals (cdr side-prev))
	       (main-real (car main-prev)) ;s
	       (main-avars-and-chals (cdr main-prev))
	       (side-avars (map car side-avars-and-chals))
	       (main-avars (map car main-avars-and-chals))
	       (shared-avars (intersection-wrt avar=? side-avars main-avars))
	       (left-avars (set-minus-wrt avar=? side-avars shared-avars))
	       (right-avars (set-minus-wrt avar=? main-avars shared-avars))
	       (main-fla (proof-to-formula main)) ;ex x A(x)
	       (side-fla (proof-to-formula side)) ;all x(A(x) -> B)
	       (conc (imp-form-to-conclusion (all-form-to-kernel side-fla))) ;B
	       (types1 (formula-to-etd-types (ex-form-to-kernel main-fla)))
	       (types2 (formula-to-etd-types conc))
	       (typep1 (car types1))
	       (typen1 (cadr types1))
	       (typep2 (car types2))
	       (typen2 (cadr types2))
	       (p1? (nulltype? typep1))
	       (n1? (nulltype? typen1))
	       (p2? (nulltype? typep2))
	       (n2? (nulltype? typen2))
	       (real-etc
		(cond
		 ((and p1? n1? p2? n2?)                         ;Case 1
		  (list 'eps side-avars-and-chals main-avars-and-chals))
		 ((and p1? n1? p2? (not n2?))                   ;Case 2
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
					;substitute (s,y) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form
					 main-real chal-varterm))))
			       side-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and p1? n1? (not p2?) n2?)                   ;Case 3
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (real (make-term-in-app-form side-real main-real)) ;ts
					;substitute s for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var main-real)))
			       side-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and p1? n1? (not p2?) (not n2?))             ;Case 4
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real (make-term-in-app-form side-real main-real)) ;ts
					;substitute (s,y) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form
					 main-real chal-varterm))))
			       side-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and p1? (not n1?) p2? n2?)                   ;Case 5	       
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
					;substitute s for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var main-real)))
			       side-avars-and-chals))
					;substitute ts for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(make-term-in-app-form
					 side-real main-real))))
			       main-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and p1? (not n1?) p2? (not n2?))             ;Case 6
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
					;substitute (s,y) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form
					 main-real chal-varterm))))
			       side-avars-and-chals))
					;substitute t(s0)(s1) for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) main-var
						(mk-term-in-app-form
						 side-real s0 s1))))
			       main-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and p1? (not n1?) (not p2?) n2?)             ;Case 7
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (real (mk-term-in-app-form
				side-real main-real 'left)) ;ts0
					;substitute s for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var main-real)))
			       side-avars-and-chals))
					;substitute ts1 for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real main-var 'right))))
			       main-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and p1? (not n1?) (not p2?) (not n2?))       ;Case 8
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real (mk-term-in-app-form side-real 'left)) ;t0
					;substitute (s,y) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form
					 main-real chal-varterm))))
			       side-avars-and-chals))
					;substitute ts1y for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real main-real 'right
					 chal-varterm))))
			       main-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and (not p1?) n1? p2? n2?)                   ;Case 9
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
					;substitute s for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var main-real)))
			       side-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and (not p1?) n1? p2? (not n2?))             ;Case 10
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
					;substitute (s0,(s1,y)) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) side-var
						(make-term-in-pair-form
						 s0 (make-term-in-pair-form
						     s1 chal-varterm)))))
			       side-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and (not p1?) n1? (not p2?) n2?)             ;Case 11
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
			 (real
			  (mk-term-in-app-form side-real s0 s1)) ;t(s0)(s1)
					;substitute s for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var main-real)))
			       side-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and (not p1?) n1? (not p2?) (not n2?))       ;Case 12
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
			 (real
			  (mk-term-in-app-form side-real s0 s1)) ;t(s0)(s1)
					;substitute (s0,(s1,y)) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form
					 s0 (make-term-in-pair-form
					     s1 chal-varterm)))))
			       side-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals main-avars-and-chals)))
		 ((and (not p1?) (not n1?) p2? n2?)             ;Case 13     
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
					;substitute (s0,s1) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form s0 s1))))
			       side-avars-and-chals))
					;substitute t(s0)(s1) for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real s0 s1))))
			       main-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) p2? (not n2?))       ;Case 14
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
					;substitute (s0,(s1,y)) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) side-var
						(make-term-in-pair-form
						 s0 (make-term-in-pair-form
						     s1 chal-varterm)))))
			       side-avars-and-chals))
					;substitute t(s0)(s1)y for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real s0 s1 chal-varterm))))
			       main-avars-and-chals)))
		    (list 'eps
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) (not p2?) n2?)       ;Case 15
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
			 (real (mk-term-in-app-form
				side-real s0 'left s1)) ;t(s0)0(s1)
					;substitute (s0,s1) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) side-var
					(make-term-in-pair-form s0 s1))))
			       side-avars-and-chals))
					;substitute t(s0)1(s1) for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real s0 'right s1))))
			       main-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) (not p2?) (not n2?)) ;Case 16
		  (let* ((side-var (formula-of-typen-to-var side-fla)) ;x
			 (main-var (formula-of-typen-to-var main-fla)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (s0 (make-term-in-lcomp-form main-real))
			 (s1 (make-term-in-rcomp-form main-real))
			 (real (mk-term-in-app-form
				side-real s0 'left s1)) ;t(s0)0(s1)
					;substitute (s0,(s1,y)) for x in side
			 (side-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) side-var
						(make-term-in-pair-form
						 s0 (make-term-in-pair-form
						     s1 chal-varterm)))))
			       side-avars-and-chals))
					;substitute t(s0)1(s1)y for z in main
			 (main-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) main-var
					(mk-term-in-app-form
					 side-real s0 'right s1
					 chal-varterm))))
			       main-avars-and-chals)))
		    (list real
			  side-avars-and-subst-chals
			  main-avars-and-subst-chals)))
		 (else (myerror "this cannot happen"))))
	       (real (car real-etc))
	       (side-avars-and-subst-chals (cadr real-etc))
	       (main-avars-and-subst-chals (caddr real-etc))
					;How to get from u:C to |C|^x_w,
					;and then to r_C?
					;x via avar-of-typep-to-var from u.
					;w via formula-of-typen-to-var from C.
					;|C|^x_w via
					;real-and-chal-and-formula-to-d-formula
					;r_C via qf-to-term.
					;Here we need to abstract w.
	       (u-and-p-and-q-to-u-and-r
		(lambda (u p q)
		  (let ((fla (avar-to-formula u)))
		    (if (formula-of-nulltypen? fla)
			(list u 'eps)
			(list u (contract u avar-of-typep-to-var
					  formula-of-typen-to-var
					  pvar-to-var p q))))))
	       (avars-and-subst-chals ;all (ui,p'i), (uj,q'j), (uk,r_k)
		(map
		 (lambda (avar)
		   (cond
		    ((member-wrt avar=? avar left-avars)
		     (list
		      avar
		      (cadr (assoc-wrt
			     avar=? avar side-avars-and-subst-chals))))
		    ((member-wrt avar=? avar right-avars)
		     (list
		      avar
		      (cadr (assoc-wrt
			     avar=? avar main-avars-and-subst-chals))))
		    (else ;shared-avar
		     (u-and-p-and-q-to-u-and-r
		      avar
		      (cadr (assoc-wrt
			     avar=? avar side-avars-and-subst-chals))
		      (cadr (assoc-wrt
			     avar=? avar main-avars-and-subst-chals))))))
		 (context-to-avars (proof-to-context proof)))))
	  (cons real avars-and-subst-chals)))
       (else ;imp-elim form, not ind-, cases- or ex-elim-rule-form
	(let* ((op (proof-in-imp-elim-form-to-op proof))
	       (arg (proof-in-imp-elim-form-to-arg proof))
	       (op-prev
		(proof-to-extracted-d-terms-aux
		 op avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	       (arg-prev
		(proof-to-extracted-d-terms-aux
		 arg avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	       (op-real (car op-prev)) ;t
	       (op-avars-and-chals (cdr op-prev))
	       (arg-real (car arg-prev)) ;s
	       (arg-avars-and-chals (cdr arg-prev))
	       (op-avars (map car op-avars-and-chals))
	       (arg-avars (map car arg-avars-and-chals))
	       (shared-avars (intersection-wrt avar=? op-avars arg-avars))
	       (left-avars (set-minus-wrt avar=? op-avars shared-avars))
	       (right-avars (set-minus-wrt avar=? arg-avars shared-avars))
	       (impl (proof-to-formula op)) ;A -> B
	       (prem (imp-form-to-premise impl))
	       (conc (imp-form-to-conclusion impl))
	       (types1 (formula-to-etd-types prem))
	       (types2 (formula-to-etd-types conc))
	       (typep1 (car types1))
	       (typen1 (cadr types1))
	       (typep2 (car types2))
	       (typen2 (cadr types2))
	       (p1? (nulltype? typep1))
	       (n1? (nulltype? typen1))
	       (p2? (nulltype? typep2))
	       (n2? (nulltype? typen2))
	       (real-etc
		(cond
		 ((and p1? n1? p2? n2?)                         ;Case 1
		  (list 'eps op-avars-and-chals arg-avars-and-chals))
		 ((and p1? n1? p2? (not n2?))                   ;Case 2
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
					;substitute y for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var chal-varterm)))
			       op-avars-and-chals)))
		    (list 'eps op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and p1? n1? (not p2?) n2?)                   ;Case 3
		  (list op-real op-avars-and-chals arg-avars-and-chals))
		 ((and p1? n1? (not p2?) (not n2?))             ;Case 4
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real op-real) ;t
					;substitute y for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var chal-varterm)))
			       op-avars-and-chals)))
		    (list real op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and p1? (not n1?) p2? n2?)                   ;Case 5	       
		  (let* ((arg-var (formula-of-typen-to-var prem)) ;z
					;substitute t for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst (cadr p) arg-var
							  op-real)))
			       arg-avars-and-chals)))
		    (list 'eps op-avars-and-chals arg-avars-and-subst-chals)))
		 ((and p1? (not n1?) p2? (not n2?))             ;Case 6
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
					;substitute y for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var chal-varterm)))
			       op-avars-and-chals))
					;substitute ty for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) arg-var
						(mk-term-in-app-form
						 op-real chal-varterm))))
			       arg-avars-and-chals)))
		    (list 'eps
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 ((and p1? (not n1?) (not p2?) n2?)             ;Case 7
		  (let* ((arg-var (formula-of-typen-to-var prem)) ;z
			 (real (mk-term-in-app-form op-real 'left)) ;t0
					;substitute t1 for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst (cadr p) arg-var
							  (mk-term-in-app-form
							   op-real 'right))))
			       arg-avars-and-chals)))
		    (list real op-avars-and-chals arg-avars-and-subst-chals)))
		 ((and p1? (not n1?) (not p2?) (not n2?))       ;Case 8
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real (mk-term-in-app-form op-real 'left)) ;t0
					;substitute y for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var chal-varterm)))
			       op-avars-and-chals))
					;substitute t1y for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst (cadr p) arg-var
							  (mk-term-in-app-form
							   op-real 'right
							   chal-varterm))))
			       arg-avars-and-chals)))
		    (list real
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 ((and (not p1?) n1? p2? n2?)                   ;Case 9
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
					;substitute s for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var arg-real)))
			       op-avars-and-chals)))
		    (list 'eps op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and (not p1?) n1? p2? (not n2?))             ;Case 10
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
					;substitute (s,y) for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) op-var
						(make-term-in-pair-form
						 arg-real chal-varterm))))
			       op-avars-and-chals)))
		    (list 'eps op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and (not p1?) n1? (not p2?) n2?)             ;Case 11
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (real (mk-term-in-app-form op-real arg-real)) ;ts
					;substitute s for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var arg-real)))
			       op-avars-and-chals)))
		    (list real op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and (not p1?) n1? (not p2?) (not n2?))       ;Case 12
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real (mk-term-in-app-form op-real arg-real)) ;ts
					;substitute (s,y) for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var
					(make-term-in-pair-form
					 arg-real chal-varterm))))
			       op-avars-and-chals)))
		    (list real op-avars-and-subst-chals arg-avars-and-chals)))
		 ((and (not p1?) (not n1?) p2? n2?)             ;Case 13     
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
					;substitute s for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var arg-real)))
			       op-avars-and-chals))
					;substitute ts for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst (cadr p) arg-var
							  (mk-term-in-app-form
							   op-real arg-real))))
			       arg-avars-and-chals)))
		    (list 'eps
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) p2? (not n2?))       ;Case 14
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
					;substitute (s,y) for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) op-var
						(make-term-in-pair-form
						 arg-real chal-varterm))))
			       op-avars-and-chals))
					;substitute tsy for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst (cadr p) arg-var
							  (mk-term-in-app-form
							   op-real arg-real
							   chal-varterm))))
			       arg-avars-and-chals)))
		    (list 'eps
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) (not p2?) n2?)       ;Case 15
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
			 (real (mk-term-in-app-form
				op-real 'left arg-real)) ;t0s
					;substitute s for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) op-var arg-real)))
			       op-avars-and-chals))
					;substitute t1s for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) arg-var
					(mk-term-in-app-form
					 op-real 'right arg-real))))
			       arg-avars-and-chals)))
		    (list real
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 ((and (not p1?) (not n1?) (not p2?) (not n2?)) ;Case 16
		  (let* ((op-var (formula-of-typen-to-var impl)) ;x
			 (arg-var (formula-of-typen-to-var prem)) ;z
			 (chal-var (formula-of-typen-to-var conc)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (real (mk-term-in-app-form
				op-real 'left arg-real)) ;t0s
					;substitute (s,y) for x in op
			 (op-avars-and-subst-chals ;(ui,p'i) and (uk,p'k)
			  (map (lambda (p)
				 (list (car p) (term-or-eps-subst
						(cadr p) op-var
						(make-term-in-pair-form
						 arg-real chal-varterm))))
			       op-avars-and-chals))
					;substitute t1sy for z in arg
			 (arg-avars-and-subst-chals ;(uj,q'j) and (uk,q'k)
			  (map (lambda (p)
				 (list (car p)
				       (term-or-eps-subst
					(cadr p) arg-var
					(mk-term-in-app-form
					 op-real 'right arg-real
					 chal-varterm))))
			       arg-avars-and-chals)))
		    (list real
			  op-avars-and-subst-chals
			  arg-avars-and-subst-chals)))
		 (else (myerror "this cannot happen"))))
	       (real (car real-etc))
	       (op-avars-and-subst-chals (cadr real-etc))
	       (arg-avars-and-subst-chals (caddr real-etc))
					;How to get from u:C to |C|^x_w,
					;and then to r_C?
					;x via avar-of-typep-to-var from u.
					;w via formula-of-typen-to-var from C.
					;|C|^x_w via
					;real-and-chal-and-formula-to-d-formula
					;r_C via qf-to-term.
					;Here we need to abstract w.
	       (u-and-p-and-q-to-u-and-r
		(lambda (u p q)
		  (let ((fla (avar-to-formula u)))
		    (if (formula-of-nulltypen? fla)
			(list u 'eps)
			(list u (contract u avar-of-typep-to-var
					  formula-of-typen-to-var
					  pvar-to-var p q))))))
	       (avars-and-subst-chals ;all (ui,p'i), (uj,q'j), (uk,r_k)
		(map
		 (lambda (avar)
		   (cond
		    ((member-wrt avar=? avar left-avars)
		     (list
		      avar
		      (cadr (assoc-wrt avar=? avar op-avars-and-subst-chals))))
		    ((member-wrt avar=? avar right-avars)
		     (list
		      avar
		      (cadr (assoc-wrt
			     avar=? avar arg-avars-and-subst-chals))))
		    (else ;shared-avar
		     (u-and-p-and-q-to-u-and-r
		      avar
		      (cadr (assoc-wrt
			     avar=? avar op-avars-and-subst-chals))
		      (cadr (assoc-wrt
			     avar=? avar arg-avars-and-subst-chals))))))
		 (context-to-avars (proof-to-context proof)))))
	  (cons real avars-and-subst-chals)))))
     ((proof-in-all-intro-form)
      (let* ((var (proof-in-all-intro-form-to-var proof)) ;x
	     (kernel (proof-in-all-intro-form-to-kernel proof))
	     (prev (proof-to-extracted-d-terms-aux
		    kernel
		    avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	     (kernel-real (car prev)) ;t
	     (avars-and-chals (cdr prev))
	     (kernel-formula (proof-to-formula kernel))
	     (types (formula-to-etd-types kernel-formula))
	     (typep (car types))
	     (typen (cadr types))
	     (p? (nulltype? typep))
	     (n? (nulltype? typen))
	     (real (if p? 'eps (make-term-in-abst-form var kernel-real)))
	     (chal-var (formula-of-typen-to-var (proof-to-formula proof))) ;y
	     (chal-varterm (make-term-in-var-form chal-var))
	     (avars-and-subst-chals
	      (if n?
					;substitute y for x
		  (map (lambda (p)
			 (list (car p) (term-or-eps-subst
					(cadr p) var chal-varterm)))
		       avars-and-chals)
					;substitute y0,y1 for x,z
		  (let* ((kernel-var
			  (formula-of-typen-to-var
			   (proof-to-formula kernel)))) ;z
		    (map (lambda (p)
			   (list (car p)
				 (term-or-eps-substitute
				  (cadr p)
				  (list (list var (make-term-in-lcomp-form
						   chal-varterm))
					(list kernel-var
					      (make-term-in-rcomp-form
					       chal-varterm))))))
			 avars-and-chals)))))
	(cons real avars-and-subst-chals)))
     ((proof-in-all-elim-form)
      (let* ((op (proof-in-all-elim-form-to-op proof))
	     (arg (proof-in-all-elim-form-to-arg proof)) ;s
	     (op-prev
	      (proof-to-extracted-d-terms-aux
	       op avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	     (op-real (car op-prev)) ;t
	     (op-var (formula-of-typen-to-var (proof-to-formula op))) ;z
	     (avars-and-chals (cdr op-prev))
	     (formula (proof-to-formula proof)) ;A(s)
	     (types (formula-to-etd-types formula))
	     (typep (car types))
	     (typen (cadr types))
	     (p? (nulltype? typep))
	     (n? (nulltype? typen))
	     (real (if p? 'eps (mk-term-in-app-form op-real arg))) ;ts
	     (avars-and-subst-chals
	      (map (lambda (p)
		     (list (car p)
			   (term-or-eps-subst
			    (cadr p) op-var
			    (if n?
					;substitute s for z
				arg
					;else substitute s,y for z
				(let* ((chal-var
					(formula-of-typen-to-var formula)) ;y
				       (chal-varterm
					(make-term-in-var-form chal-var)))
				  (make-term-in-pair-form
				   arg chal-varterm))))))
		   avars-and-chals)))
	(cons real avars-and-subst-chals)))
     ((proof-in-allnc-intro-form)
      (let* ((var (proof-in-all-intro-form-to-var proof)) ;x
	     (kernel (proof-in-all-intro-form-to-kernel proof))
	     (prev (proof-to-extracted-d-terms-aux
		    kernel
		    avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	     (kernel-real (car prev)) ;t
	     (avars-and-chals (cdr prev))
	     (kernel-formula (proof-to-formula kernel))
	     (types (formula-to-etd-types kernel-formula))
	     (typen (cadr types))
	     (n? (nulltype? typen))
	     (real kernel-real)
	     (avars-and-subst-chals
	      (if n? avars-and-chals
					;substitute y for z
		  (let* ((chal-var (formula-of-typen-to-var
				    (proof-to-formula proof))) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (kernel-var (formula-of-typen-to-var
				      (proof-to-formula kernel)))) ;z
		    (map (lambda (p)
			   (list (car p)
				 (term-or-eps-subst
				  (cadr p) kernel-var chal-varterm)))
			 avars-and-chals)))))
	(cons real avars-and-subst-chals)))
     ((proof-in-allnc-elim-form)
      (let* ((op (proof-in-all-elim-form-to-op proof))
	     (arg (proof-in-all-elim-form-to-arg proof)) ;s
	     (op-prev
	      (proof-to-extracted-d-terms-aux
	       op avar-of-typep-to-var formula-of-typen-to-var pvar-to-var))
	     (op-real (car op-prev)) ;t
	     (avars-and-chals (cdr op-prev))
	     (formula (proof-to-formula proof)) ;A(s)
	     (types (formula-to-etd-types formula))
	     (typen (cadr types))
	     (n? (nulltype? typen))
	     (real op-real) ;t
	     (avars-and-subst-chals
	      (if n? avars-and-chals
					;else substitute y for z
		  (let* ((chal-var (formula-of-typen-to-var formula)) ;y
			 (chal-varterm (make-term-in-var-form chal-var))
			 (op-var (formula-of-typen-to-var
				  (proof-to-formula op)))) ;z
		    (map (lambda (p)
			   (list (car p)
				 (term-or-eps-subst
				  (cadr p) op-var chal-varterm)))
			 avars-and-chals)))))
	(cons real avars-and-subst-chals)))
     (else (myerror "unexpected proof with tag" (tag proof))))))

(define (all-formulas-to-etd-rec-const . all-formulas)
  (let* ((uninst-imp-formulas-and-tpinst
	  (apply all-formulas-to-uninst-imp-formulas-and-tpinst all-formulas))
	 (uninst-imp-formulas (car uninst-imp-formulas-and-tpinst))
	 (tpinst (cadr uninst-imp-formulas-and-tpinst))
	 (tsubst (list-transform-positive tpinst
		   (lambda (x) (tvar-form? (car x)))))
	 (pinst (list-transform-positive tpinst
		  (lambda (x) (pvar-form? (car x)))))
	 (relevant-pinst (list-transform-positive pinst
			   (lambda (x)
			     (not (formula-of-nulltypep?
				   (cterm-to-formula (cadr x)))))))
	 (pvars (map car relevant-pinst))
	 (cterms (map cadr relevant-pinst))
	 (et-types (map (lambda (cterm)
			  (formula-to-etdp-type (cterm-to-formula cterm)))
			cterms))
	 (new-tvars (map PVAR-TO-TVAR pvars))
	 (new-tsubst (make-substitution new-tvars et-types))
	 (uninst-recop-types (map formula-to-et-type
				  uninst-imp-formulas))
	 (vars (map all-form-to-var all-formulas))
	 (types (map var-to-type vars))
	 (alg-names
	  (map (lambda (type)
		 (if (alg-form? type)
		     (alg-form-to-name type)
		     (myerror "all-formulas-to-et-rec-const" "alg expected"
			      (type-to-string type))))
	       types))
	 (alg-names-with-uninst-recop-types
	  (map (lambda (x y) (list x y)) alg-names uninst-recop-types))
	 (simalg-names (alg-name-to-simalg-names (car alg-names)))
	 (sorted-alg-names (list-transform-positive simalg-names
			     (lambda (x) (member x alg-names))))
	 (typed-constr-names
	  (apply append
		 (map alg-name-to-typed-constr-names sorted-alg-names)))
	 (constr-names (map typed-constr-name-to-name typed-constr-names))
	 (alg-name (car alg-names))
	 (uninst-recop-type
	  (cadr (assoc alg-name alg-names-with-uninst-recop-types)))
	 (inst-recop-type (type-substitute uninst-recop-type
					   (append tsubst new-tsubst)))
	 (arrow-types (map formula-to-et-type all-formulas)))
    (apply alg-name-etc-to-rec-const
	   (append (list alg-name uninst-recop-type (append tsubst new-tsubst)
			 inst-recop-type 0 constr-names
			 alg-names-with-uninst-recop-types)
		   arrow-types))))

(define (all-formula-and-alts-to-etd-if-term all-formula alts)
  (let* ((var (all-form-to-var all-formula))
	 (test-type (var-to-type var))
	 (test-var (type-to-new-var test-type)))
    (make-term-in-abst-form
     test-var (make-term-in-if-form
	       (make-term-in-var-form test-var) alts))))

(define (term-or-eps-substitute term tosubst)
  (if (eq? 'eps term)
      'eps
      (term-substitute term tosubst)))

(define (term-or-eps-subst term arg val)
  (if (eq? 'eps term)
      'eps
      (term-subst term arg val)))

; For an avar u with a formula C with negative content tau^-(C) \ne
; eps and terms p, q and qs of type tau^-(C) we generate an if-term of
; type tau^-(C) used for contraction.

(define (contract u avar-of-typep-to-var formula-of-typen-to-var pvar-to-var
		  p q . qs)
  (let* ((fla (avar-to-formula u))
	 (eps-or-x (if (formula-of-nulltypep? fla)
		       'eps
		       (make-term-in-var-form (avar-of-typep-to-var u))))
	 (w (formula-of-typen-to-var fla))
	 (d-fla (real-and-chal-and-formula-to-d-formula-aux
		 eps-or-x (make-term-in-var-form w) fla pvar-to-var))
	 (boolean-term
	  (if (quant-free?  d-fla)
	      (qf-to-term d-fla)
	      (myerror "contract" "quantifier-free formula expected" d-fla)))
	 (abst-boolean-term (make-term-in-abst-form w boolean-term))
	 (cId-const (pconst-name-to-pconst "cId"))
	 (cId-term (make-term-in-const-form
		    (let* ((tvars (const-to-tvars cId-const))
			   (subst (make-substitution
				   tvars (list (make-arrow (var-to-type w)
							   (var-to-type w))))))
		      (const-substitute cId-const subst #f)))))
    (letrec
	((contract-aux
	  (lambda (p q . qs)
	    (let ((prev (if (null? qs) q
			    (apply contract-aux (cons q qs)))))
	      (if (or (term-is-inappropriate-for-let? p)
		      (term-is-inappropriate-for-let? (nt p)))
		  (make-term-in-if-form
		   (make-term-in-app-form abst-boolean-term p)
		   (list prev p))
		  (mk-term-in-app-form ;let via cId
		   cId-term
		   (make-term-in-abst-form
		    w (make-term-in-if-form
		       (make-term-in-app-form
			abst-boolean-term
			(make-term-in-var-form w))
		       (list prev (make-term-in-var-form w))))
		   p))))))
      (apply contract-aux (cons p (cons q qs))))))

(define (term-is-inappropriate-for-let? term)
  (or (term-in-var-form? term)
      (term-in-const-form? term)
      (is-numeric-term? term)
      (and (term-in-pair-form? term)
	   (term-is-inappropriate-for-let?
	    (term-in-pair-form-to-left term))
	   (term-is-inappropriate-for-let?
	    (term-in-pair-form-to-right term)))))

(define (ex-formula-to-ex-intro-extracted-d-term ex-formula)
  (let* ((var (ex-form-to-var ex-formula))
         (kernel (ex-form-to-kernel ex-formula))
	 (kernel-types (formula-to-etd-types kernel))
	 (kernel-typep (car kernel-types))
	 (kernel-typen (cadr kernel-types))
	 (p? (nulltype? kernel-typep))
	 (n? (nulltype? kernel-typen)))
    (cond
     ((and p? n?)
      (make-term-in-abst-form var (make-term-in-var-form var)))
     ((and p? (not n?))
      (let ((chal-var (type-to-new-var kernel-typen)))
	(make-term-in-abst-form
	 var (make-term-in-pair-form
	      (make-term-in-var-form var)
	      (make-term-in-abst-form
	       chal-var (make-term-in-var-form chal-var))))))
     ((and (not p?) n?)
      (let ((real-var (type-to-new-var kernel-typep)))
	(mk-term-in-abst-form
	 var real-var
	 (make-term-in-pair-form
	  (make-term-in-var-form var)
	  (make-term-in-var-form real-var)))))
     ((and (not p?) (not n?))
      (let ((real-var (type-to-new-var kernel-typep))
	    (chal-var (type-to-new-var kernel-typen)))
	(make-term-in-abst-form
	 var (make-term-in-pair-form
	      (make-term-in-abst-form
	       real-var (make-term-in-pair-form
			 (make-term-in-var-form var)
			 (make-term-in-var-form real-var)))
	      (mk-term-in-abst-form
	       var chal-var (make-term-in-var-form chal-var)))))))))

(define (theorem-or-global-assumption-to-d-pconst thm-or-ga)
  (let* ((thm-or-ga-name (aconst-to-name thm-or-ga))
	 (d-pconst-name
	  (theorem-or-global-assumption-name-to-d-pconst-name thm-or-ga-name))
	 (d-pconst (pconst-name-to-pconst d-pconst-name))
	 (tpinst (aconst-to-tpinst thm-or-ga))
	 (tsubst (list-transform-positive tpinst
		   (lambda (x) (tvar-form? (car x)))))
	 (pinst (list-transform-positive tpinst
		  (lambda (x) (pvar-form? (car x)))))
	 (new-tsubst
	  (do ((l pinst (cdr l))
	       (res '() (let* ((pvar (caar l))
			       (cterm (cadar l))
			       (formula (cterm-to-formula cterm))
			       (types (formula-to-etd-types formula))
			       (typep (car types))
			       (typen (cadr types))
			       (p? (nulltype? typep))
			       (n? (nulltype? typen)))
			  (cond
			   ((and p? n?) res)
			   ((and p? (not n?))
			    (cons (list (PVAR-TO-TVARP pvar) typep) res))
			   ((and (not p?) n?)
			    (cons (list (PVAR-TO-TVARN pvar) typen) res))
			   ((and (not p?) (not n?))
			    (cons (list (PVAR-TO-TVARN pvar) typen)
				  (cons (list (PVAR-TO-TVARP pvar) typep)
					res)))))))
	      ((null? l) (reverse res)))))
    (const-substitute d-pconst
		      (compose-t-substitutions tsubst new-tsubst) #f)))

(define (theorem-or-global-assumption-name-to-d-pconst-name string)
  (string-append "d"
		 (list->string (remove-numerals (string->list string)))))

