; $Id: bar.scm,v 1.5 2006/12/12 16:02:22 schimans Exp $

; bar.tac  This file contains the definition of the inductive predicate Bar 
; and examples for the use of the introduction and elimination axioms.
; We prove 
; - Bar [] implies that every infinite sequence has a good initial segment.
; - Bar ws*[].
; We will make use of these two Lemmas in higman-finte.scm
; Therefore, we prove the statements an alphabet consisting of natural numbers.

; 1. Definitions

(libload "nat2.scm")
(libload "tsil.scm")

; tisl.scm contains the type of reverse lists with the constructors: Lin 
; and Snoc. (Snoc ws w) is displayed as ws::w.
; The length of a list is denoted by Lh.

(define boole (py "boole"))
(define nat (py "nat"))
(define word (py "tsil nat"))
(define seq (py "tsil (tsil nat)"))

(rv "n" "k" "m")
(av "a" "b" "c" "i" "j" "k" "m" "n" (py "nat"))
(av "w" "u" "v" "x" "y" "z" "as" "bs" word)
(av "ws" "vs" "xs" "ys" "zs" seq)

(av "f" (make-arrow nat word))

(add-program-constant "Init" (mk-arrow (mk-arrow nat word) nat seq) 1)
(add-computation-rule (pt "Init f 0") (pt "(Lin (tsil nat))"))
(add-computation-rule (pt "Init f (Succ n)") (pt "(Init f n)::(f(n))"))

; Emb, L, Good are inductive definitions without computational content
; In the main text of the thesis, L vs v is Good(vs,v)

(add-ids (list (list "Emb" (make-arity word word)))
	 '("Emb (Lin nat) (Lin nat)" )
	 '("allnc v,w,a. Emb v w -> Emb v (w::a)")
         '("allnc v,w,a. Emb v w -> Emb (v::a) (w::a)"))

(add-ids (list (list "L" (make-arity seq word)))
	 '("allnc vs,v,w. Emb v w -> L (vs::v) w")
	 '("allnc vs,v,w. L vs w  -> L (vs::v) w"))

(add-ids (list (list "Good" (make-arity seq)))
	 '("allnc ws,w. L ws w -> Good (ws::w)")
	 '("allnc ws,w. Good ws -> Good (ws::w)"))

; Bar is an inductive predicate with computatinal content.
; The `type' of Bar is tree with the constructors Leaf and Branch. 

(add-ids (list (list "Bar" (make-arity seq) "tree"))
	 '("allnc ws. Good ws -> Bar ws" "Leaf")
	 '("allnc ws. (all w  Bar (ws::w)) -> Bar ws" "Branch"))


; 2. The interactive proof

(set-goal (pf "allnc ws. Bar ws -> 
                         all f,n. Init f n = ws -> ex m. Good (Init f m)"))
(assume "vs")

; Ind(Bar).
(elim)

; 1. Good ws
(assume "ws" "Good ws"  "f" "n" "Init f n=ws")
(ex-intro (pt "n"))
(simp "Init f n=ws")
(use "Good ws")

; 2. all w Bar(ws::w) 
(assume "ws" "all w Bar(ws::w)" "ih" "f" "n" "Init f n=ws")
(use-with "ih" (pt "f  n ")(pt "f") (pt "n+1") "?")

;Init f(n+1)=(ws::f n)
(ng)
(use "Init f n=ws")
(save "Bar-thm")


; 3. The extracted program 

(av "ga" (py "tsil nat=>tree"))
(av "gb" (py "tsil nat=>(nat=>tsil nat)=>nat=>nat"))

(term-to-expr (nt (proof-to-extracted-term (current-proof))))

; ==> 

; ((|(Rec tree=>(nat=>tsil nat)=>nat=>nat)|
;    (lambda (f3) (lambda (n4) n4)))
;  (lambda (ga3)
;    (lambda (gb4)
;      (lambda (f5)
;        (lambda (n6) (((gb4 (f5 n6)) f5) (|Succ| n6)))))))


; 4. We give an second example to demonstrate the use of the introduction axioms.

; Bar (ws*[])

(set-goal (pf "all w. Emb (Lin nat) w"))
(ind)
(intro 0)
(assume "w" "a" 1)
(intro 1)
(use 1)
(save "Emb-lemma")

(set-goal (pf "allnc ws Bar (ws::(Lin nat))"))
(assume "ws")
(intro 1)
(assume "w")
(intro 0)       
(intro 0)       
(intro 0)      
(use "Emb-lemma")
(save "Lemma0")
(save "Prop1")
                     
(term-to-expr (proof-to-extracted-term (current-proof)))

; ==> (|Branch| (lambda (w) |Leaf|))

; A final comment: we could have reformulated our first statement:

;    allnc ws. Bar ws -> all f. Initial f ws -> ex m. Good (Init f m)"))

; where  Initial f [] = True
;        Initial f (ws*w) = [if (f (Lh ws)=w)(Initial f ws) False]

; However, this would lead to problems concerning the CV-variables.
; since in case `Good ws',  we have to set m = Lh ws, but
; ws is a CV variable which must not be used in the interactive proof.

; In general, having a proof of Bar ws does not imply that we have given
; the object ws.
