/* CRIS ELF support for BFD.
   Copyright 2000, 2001, 2004 Free Software Foundation, Inc.
   Contributed by Axis Communications AB, Lund, Sweden.
   Written by Hans-Peter Nilsson.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street - Fifth Floor, Boston, MA 02110-1301, USA.  */

#ifndef _ELF_CRIS_H
#define _ELF_CRIS_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_cris_reloc_type)
  RELOC_NUMBER (R_CRIS_NONE,		0)
  RELOC_NUMBER (R_CRIS_8,		1)
  RELOC_NUMBER (R_CRIS_16,		2)
  RELOC_NUMBER (R_CRIS_32,		3)

  /* The "PC" position is the location right after the relocation.  */
  RELOC_NUMBER (R_CRIS_8_PCREL,		4)
  RELOC_NUMBER (R_CRIS_16_PCREL,	5)
  RELOC_NUMBER (R_CRIS_32_PCREL,	6)

  RELOC_NUMBER (R_CRIS_GNU_VTINHERIT,	7)
  RELOC_NUMBER (R_CRIS_GNU_VTENTRY,	8)

  /* Copy contents at dynlinking.  Generated by the linker.
     The BFD equivalent is BFD_RELOC_CRIS_COPY.  */
  RELOC_NUMBER (R_CRIS_COPY, 9)

  /* Create GOT entry.  Generated by the linker.
     The BFD equivalent is BFD_RELOC_CRIS_GLOB_DAT.  */
  RELOC_NUMBER (R_CRIS_GLOB_DAT, 10)

  /* Create PLT entry.  Generated by the linker.
     The BFD equivalent is BFD_RELOC_CRIS_JUMP_SLOT.  */
  RELOC_NUMBER (R_CRIS_JUMP_SLOT, 11)

  /* Adjust by program base.  Generated by the linker.
     The BFD equivalent is BFD_RELOC_CRIS_RELATIVE.  */
  RELOC_NUMBER (R_CRIS_RELATIVE, 12)

  /* A 16-bit offset to entry in GOT and request to create GOT entry for
     that symbol.
     The BFD equivalent is BFD_RELOC_CRIS_16_GOT.  */
  RELOC_NUMBER (R_CRIS_16_GOT, 13)

  /* A 32-bit offset to entry in GOT and request to create GOT entry for
     that symbol.
     The BFD equivalent is BFD_RELOC_CRIS_32_GOT.  */
  RELOC_NUMBER (R_CRIS_32_GOT, 14)

  /* A 16-bit offset to entry in PLT part of GOT and request to create PLT
     entry for that symbol.
     The BFD equivalent is BFD_RELOC_CRIS_16_GOTPLT.  */
  RELOC_NUMBER (R_CRIS_16_GOTPLT, 15)

  /* A 32-bit offset to entry in PLT part of GOT and request to create PLT
     entry for that symbol.
     The BFD equivalent is BFD_RELOC_CRIS_32_GOTPLT.  */
  RELOC_NUMBER (R_CRIS_32_GOTPLT, 16)

  /* A 32-bit offset from GOT to (local) symbol: no GOT entry should be
     necessary.
     The BFD equivalent is BFD_RELOC_CRIS_32_GOTREL.  */
  RELOC_NUMBER (R_CRIS_32_GOTREL, 17)

  /* A 32-bit offset from GOT to entry for this symbol in PLT and request
     to create PLT entry for symbol.
     The BFD equivalent is BFD_RELOC_CRIS_32_GOTREL.  */
  RELOC_NUMBER (R_CRIS_32_PLT_GOTREL, 18)

  /* A 32-bit offset from location after this relocation (addend specifies
     offset) to entry for this symbol in PLT and request to create PLT
     entry for symbol.
     The BFD equivalent is BFD_RELOC_CRIS_32_PLT_PCREL.  */
  RELOC_NUMBER (R_CRIS_32_PLT_PCREL, 19)

  /* No other relocs must be visible outside the assembler.  */

END_RELOC_NUMBERS (R_CRIS_max)

/* User symbols in this file have a leading underscore.  */
#define EF_CRIS_UNDERSCORE		0x00000001

/* This is a mask for different incompatible machine variants.  */
#define EF_CRIS_VARIANT_MASK		0x0000000e

/* Variant 0; may contain v0..10 object.  */
#define EF_CRIS_VARIANT_ANY_V0_V10	0x00000000

/* Variant 1; contains v32 object.  */
#define EF_CRIS_VARIANT_V32		0x00000002

/* Variant 2; contains object compatible with v32 and v10.  */
#define EF_CRIS_VARIANT_COMMON_V10_V32	0x00000004

#endif /* _ELF_CRIS_H */
