message("UNIX non APPLE environment")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug -DBUILD_USER_MANUAL=1 ../development")

set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)
set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES /usr/include)

# This is used throughout all the build system files
set(TARGET minexpert2)

# Now that we know what is the TARGET (in the toolchain files above,
# we can compute the lowercase TARGET (used for string replacements in 
# configure files and also for the resource compilation with windres.exe.
string(TOLOWER ${TARGET} TARGET_LOWERCASE)
message("TARGET_LOWERCASE: ${TARGET_LOWERCASE}")


# No more used as now this code belongs to the PappsoMSppWidget library.
#set(CustomPwiz_FOUND 1)
#set(CustomPwiz_INCLUDE_DIRS "/home/rusconi/devel/custompwiz/development/src")
#set(CustomPwiz_LIBRARY "/home/rusconi/devel/custompwiz/build-area/src/libcustompwiz.so.3.0.0")
#if(NOT TARGET CustomPwiz::CustomPwiz)
#add_library(CustomPwiz::CustomPwiz UNKNOWN IMPORTED)
#set_target_properties(CustomPwiz::CustomPwiz PROPERTIES
#IMPORTED_LOCATION             "${CustomPwiz_LIBRARY}"
#INTERFACE_INCLUDE_DIRECTORIES "${CustomPwiz_INCLUDE_DIRS}")
#endif()


find_package(QCustomPlot REQUIRED)
# Per instructions of the lib author:
# https://www.qcustomplot.com/index.php/tutorials/settingup
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")
if(NOT TARGET QCustomPlot::QCustomPlot)
  add_library(QCustomPlot::QCustomPlot UNKNOWN IMPORTED)
  set_target_properties(QCustomPlot::QCustomPlot PROPERTIES
    IMPORTED_LOCATION             "${QCustomPlot_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlot_INCLUDE_DIR}"
    INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY	)
endif()


#set(IsoSpec++_DIR /usr/lib/x86_64-linux-gnu/cmake/isospec)
find_package(IsoSpec++ REQUIRED)


# On UNIX, the libpappsomspp and libpappsomspp-widget libs
# need to be installed and they ship the PappsoMSppConfig.cmake
# config file.

find_package(PappsoMSpp COMPONENTS Core Widget REQUIRED)

if(PappsoMSpp_FOUND)

  message(STATUS "PappsoMSpp was found at: ${PappsoMSpp_LIBRARY}")
  message(STATUS "Include dir for PappsoMSpp is at: ${PappsoMSpp_INCLUDE_DIRS}")

endif()

## Install directories
if(NOT CMAKE_INSTALL_PREFIX)
  set(CMAKE_INSTALL_PREFIX /usr)
endif()
set(BIN_DIR ${CMAKE_INSTALL_PREFIX}/bin)
set(DOC_DIR ${CMAKE_INSTALL_PREFIX}/share/doc/${TARGET})


# The appstream, desktop and icon files
install(FILES org.msxpertsuite.${TARGET}.desktop
  DESTINATION ${CMAKE_INSTALL_PREFIX}/share/applications)

install(FILES org.msxpertsuite.${TARGET}.appdata.xml
  DESTINATION ${CMAKE_INSTALL_PREFIX}/share/metainfo)

install(FILES images/icons/16x16/${TARGET}.png
  DESTINATION
  ${CMAKE_INSTALL_PREFIX}/share/icons/hicolor/16x16/apps)

install(FILES images/icons/32x32/${TARGET}.png
  DESTINATION
  ${CMAKE_INSTALL_PREFIX}/share/icons/hicolor/32x32/apps)

install(FILES images/icons/48x48/${TARGET}.png
  DESTINATION
  ${CMAKE_INSTALL_PREFIX}/share/icons/hicolor/48x48/apps)

install(FILES images/icons/64x64/${TARGET}.png
  DESTINATION
  ${CMAKE_INSTALL_PREFIX}/share/icons/hicolor/64x64/apps)


## Platform-dependent compiler flags:
include(CheckCXXCompilerFlag)

if (WITH_FPIC)
  add_definitions(-fPIC)
endif()

