#############################################################################
# mined text editor compilation options (make include file for cc options)


#############################################################################
# compilation source options

# code checking
# gcc only: checking for function signatures
PROTOFLAGS=

# suppress prototype stuff for the sake of compilers and/or include files 
# that cannot handle it; keep that as a gcc-only feature for source checking
CCFLAGS	= -DNOPROTO


#############################################################################
# compilation mode options (optimisation and debug)

# Optimization flag/level:
OPT	= -O

# Debugging option
DEBUG	= 


#############################################################################
# compilation setup

# Collection of compilation parameters:
CFLAGS	= $(SYSFLAGS) $(CCFLAGS) $(OPT) $(DEBUG)


#############################################################################
# link options

LINKOPTS=$(LDOPTS)
# for newer ncursesw?
#LDL=-ldl	# if libdl library exists:
LDL=` echo "/usr/lib ${LDFLAGS} " | sed -e "s, -L, ,g" -e "s,\([^ ][^ ]*\),ls -1 \1/libdl.*;,g" | sh | sed -e "s,.*/libdl\..*,-ldl," -e 1q `


#############################################################################
# dynamic make targets
# this version for non-GNU make

# used for linking; the dependency is resolved by a generated makefile
CHARMAPS=charmaps/*.o

# this dependency is ensured by a dynamically generated makefile
KEYMAPS=

# explicit make targets for dynamically .generating and invoking makefiles
MAKEMAPS=mkcharmaps mkkeymaps


#############################################################################
# end
