/*======================================================================*\
	Check function valid_cjk with all mapping entries
	of all CJK character code mapping tables.
\*======================================================================*/

#include "charmaps.c"

int width_data_version;
int nonbmp_width_data = 0;
int combining_data_version = 3;

FLAG mapped_text = 0;
FLAG utf8_text = 0;
FLAG cjk_text = 0;
FLAG pc_term = 0;


/**
   Return # character codes marked non-valid.
 */
unsigned long
check (char tag)
{
	unsigned int i = 0;
	unsigned long cjkchar;
	unsigned long ok = 0;
	unsigned long non = 0;

	(void) set_char_encoding (tag);

	struct cjk_table_entry * cjk_table_poi = cjk_table;
	while (i ++ < cjk_table_len) {
#ifdef split_map_entries
		cjkchar = decode_cjk (cjk_table_poi);
#else
		cjkchar = cjk_table_poi->cjk;
#endif
		if (valid_cjk (cjkchar, NIL_PTR)) {
			ok ++;
		} else {
			printf ("%c %04X\n", cjk_encoding, cjkchar);
			non ++;
		}
		cjk_table_poi ++;
	}
	printf ("%c: valid %d, not valid %d\n", cjk_encoding, ok, non);
	return non;
}

int
main ()
{
	unsigned long non = 0;
	non += check ('B');
	non += check ('G');
	non += check ('C');
	non += check ('J');
	non += check ('S');
	non += check ('K');
	non += check ('H');

	return non > 0;
}


/*======================================================================*\
	end
\*======================================================================*/
