# Minder

<p align="center">
  <a href="https://appcenter.elementary.io/com.github.phase1geo.minder"><img src="https://appcenter.elementary.io/badge.svg" alt="Get it on AppCenter" /></a>
</p>

![<center><b>Main Window - Light Theme</b></center>](https://raw.githubusercontent.com/phase1geo/Minder/master/data/screenshots/screenshot-current-properties.png "Mind-mapping application for Elementary OS")

## Overview

Use the power of mind-mapping to make your ideas come to life.

- Quickly create visual mind-maps using the keyboard and automatic layout.
- Choose from many tree layout choices.
- Support for Markdown formatting.
- Add notes, tasks and images to your nodes.
- Add node-to-node connections with optional text and notes.
- Stylize nodes, links and connections to add more meaning and improve readability.
- Add stickers and node groups to call out and visibly organize information.
- Quick search of node and connection titles and notes, including filtering options.
- Zoom in or enable focus mode to focus on certain ideas or zoom out to see the bigger picture.
- Enter focus mode to better view and understand portions of the map.
- Unlimited undo/redo of any change.
- Automatically saves in the background.
- Colorized node branches.
- Open multiple mindmaps with the use of tabs.
- Built-in and customizable theming.
- Gorgeous animations.
- Import from OPML, FreeMind, Freeplane, PlainText (formatted), Outliner, Portable Minder and XMind formats.
- Export to CSV, FreeMind, Freeplane, JPEG, BMP, SVG, Markdown, Mermaid, OPML, Org-Mode, Outliner, PDF, PNG, Portable Minder, PlainText, XMind and yEd formats.
- Printer support.

## Installation

You will need the following dependencies to build Minder:

* ninja-build
* python3-pip
* python3-setuptools
* meson
* valac (any 0.48.x version -- any later version will result in segfaults -- earlier versions have issues with libarchive)
* debhelper
* libcairo2-dev
* libgranite-dev
* libgtk-3-dev
* libxml2-dev
* libgee-0.8-dev
* libarchive-dev
* libgtksourceview-4-dev
* libmarkdown2-dev
* libhandy-1-dev
* libjson-glib-dev

To install, run `sudo ./app install` and then run the application from your application launcher or from
the command-line with `./app run`.

## Distribution packages

Arch Linux users can find Minder in the official `community` repo:

`$ sudo pacman -S minder`

Minder is packaged in Void Linux, install it with `xbps-install`:

`$ sudo xbps-install Minder`

For Fedora users, install the RPM package with:

`$ sudo dnf install minder`

Debian/Ubuntu package is also available:

`$ sudo apt install minder`

## Documentation

Minder documentation can be found [here](https://github.com/phase1geo/Minder/wiki/Table-of-Contents).

<p align="center">
  <a href="https://appcenter.elementary.io/com.github.phase1geo.minder"><img src="https://appcenter.elementary.io/badge.svg" alt="Get it on AppCenter" /></a>
</p>
