package com.milaboratory.primitivio;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.milaboratory.primitivio.annotations.Serializable;
import com.milaboratory.util.GlobalObjectMappers;

/**
 * By implementing this interface, one can customise object mapper that will be used for serialization in classes with
 * activated {@link Serializable#asJson()} option.
 */
public interface ObjectMapperProvider {
    ObjectMapper getObjectMapper();

    final class Default implements ObjectMapperProvider {
        @Override
        public ObjectMapper getObjectMapper() {
            return GlobalObjectMappers.getOneLine();
        }
    }
}
