/*
 * Copyright (c) 2022 MiLaboratories Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.milaboratory.core.motif;

import com.milaboratory.util.BitArray;

import java.io.Serializable;

final class BitapData implements Serializable {
    final int size;
    final long[] patternMask;
    final long[] reversePatternMask;

    BitapData(int size, long[] patternMask, long[] reversePatternMask) {
        if (patternMask.length != reversePatternMask.length)
            throw new IllegalArgumentException();

        this.size = size;
        this.patternMask = patternMask;
        this.reversePatternMask = reversePatternMask;
    }

    BitapData toSecondary(BitArray exactMask) {
        if (exactMask.size() != size)
            throw new IllegalArgumentException();

        long[] newPatternMask = patternMask.clone();
        long[] newReversePatternMask = reversePatternMask.clone();

        for (int j = 0; j < size; ++j)
            if (!exactMask.get(j))
                for (int i = 0; i < patternMask.length; ++i) {
                    newPatternMask[i] &= ~(1L << j);
                    newReversePatternMask[i] &= ~(1L << (size - j - 1));
                }
        return new BitapData(size, newPatternMask, newReversePatternMask);
    }
}
