/*  MikMod example player
	(c) 1999 Miodrag Vallat and others - see file AUTHORS for
	complete list.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
 
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

/*==============================================================================

  $Id: mutilities.c,v 1.1.1.1 2003/09/19 13:16:01 raph Exp $

  Some utility functions

==============================================================================*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if !defined(__OS2__) && !defined(__EMX__)
#include <pwd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>

#include <mikmod.h>

#include "player.h"
#include "mutilities.h"

/* allocate memory for a formated string and do a sprintf */
char *str_sprintf2(char *fmt,char *arg1,char *arg2)
{
	char *msg=malloc(strlen(fmt)+strlen(arg1)+strlen(arg2)+1);

	if (msg) sprintf(msg,fmt,arg1,arg2);
	return msg;
}

/* allocate memory for a formated string and do a sprintf */
char *str_sprintf(char *fmt,char *arg)
{
	return str_sprintf2(fmt,arg,"");
}

BOOL file_exist(char *file)
{
	struct stat sb;

	return (stat(file,&sb)==-1)?0:1;
}

/* determines if a given path is absolute or relative */
BOOL path_relative(char *path)
{
	if (!path) return 1;
	
#if defined(__OS2__)||defined(__EMX__)
	if (*path && (path[1]==':')) return 0;
#endif

	return (*path!=PATH_SEP);
}

/* allocate and return a name for a temporary file */
char *get_tmp_name(void)
{
#if defined(__OS2__) && defined(__WATCOMC__)
	return str_sprintf2("%s" PATH_SEP_STR "%s",getenv("TEMP"),"!MikMod.tmp");
#else
	CHAR *tmp_file;

	if (!(tmp_file=tempnam(NULL,".mod")))
		if (!(tmp_file=tempnam(getenv("HOME"),".mod")))
			return NULL;
	return tmp_file;
#endif
}

/* allocate and return a filename including the path for a config file
   'name': filename without the path */
char* get_cfg_name(char *name)
{
	char *home=getenv("HOME");
	if (!home) {
#if defined(__OS2__)||defined(__EMX__)
		home="C:";
#else
		struct passwd *pw=getpwuid(getuid());

		if (pw)
			home=pw->pw_dir;
		else
			return NULL;
#endif
	}
	return str_sprintf2("%s" PATH_SEP_STR "%s",home,name);
}

/* ex:set ts=4: */
