#
# This is minimal MicroPython variant of run-tests script, which uses
# .exp files as generated by run-tests --write-exp. It is useful to run
# testsuite on systems which have neither CPython3 nor unix shell.
# This script is intended to be run by the same interpreter executable
# which is to be tested, so should use minimal language functionality.
#
import usys as sys
import uos as os


tests = ["basics", "micropython", "float", "import", "io", " misc", "unicode", "extmod", "unix"]

if sys.platform == "win32":
    MICROPYTHON = "micropython.exe"
else:
    MICROPYTHON = "micropython"


def should_skip(test):
    if test.startswith("native"):
        return True
    if test.startswith("viper"):
        return True


test_count = 0
passed_count = 0
skip_count = 0

for suite in tests:
    # print("Running in: %s" % suite)
    if sys.platform == "win32":
        # dir /b prints only contained filenames, one on a line
        # http://www.microsoft.com/resources/documentation/windows/xp/all/proddocs/en-us/dir.mspx
        r = os.system("dir /b %s/*.py >tests.lst" % suite)
    else:
        r = os.system("ls %s/*.py | xargs -n1 basename >tests.lst" % suite)
    assert r == 0

    with open("tests.lst") as f:
        testcases = f.readlines()
        testcases = [l[:-1] for l in testcases]
    assert testcases, "No tests found in dir '%s', which is implausible" % suite
    # print(testcases)
    for t in testcases:
        if t == "native_check.py":
            continue

        qtest = "%s/%s" % (suite, t)

        if should_skip(t):
            print("skip " + qtest)
            skip_count += 1
            continue

        exp = None
        try:
            f = open(qtest + ".exp")
            exp = f.read()
            f.close()
        except OSError:
            pass

        if exp is not None:
            # print("run " + qtest)
            r = os.system(MICROPYTHON + " %s >.tst.out" % qtest)
            if r == 0:
                f = open(".tst.out")
                out = f.read()
                f.close()
            else:
                out = "CRASH"

            if out == "SKIP\n":
                print("skip " + qtest)
                skip_count += 1
            else:
                if out == exp:
                    print("pass " + qtest)
                    passed_count += 1
                else:
                    print("FAIL " + qtest)

                test_count += 1
        else:
            skip_count += 1

print("%s tests performed" % test_count)
print("%s tests passed" % passed_count)
if test_count != passed_count:
    print("%s tests failed" % (test_count - passed_count))
if skip_count:
    print("%s tests skipped" % skip_count)
