// This file is generated from VSCode model tests by the testgen tool.
// DO NOT EDIT THIS FILE BY HAND; your changes will be overwritten!

package buffer

import "testing"

func TestAuto1(t *testing.T) {
	check(
		t,
		[]string{
			"ioe",
			"",
			"yjct",
			"",
			"",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{1, 0},
				text: []string{
					"b",
					"r",
					"fq",
				},
			},
			operation{
				start: Loc{3, 0},
				end:   Loc{0, 1},
				text: []string{
					"",
					"",
				},
			},
		},
		[]string{
			"ib",
			"r",
			"fqoe",
			"",
			"yjct",
			"",
			"",
		},
	)
}

func TestAuto2(t *testing.T) {
	check(
		t,
		[]string{
			"f",
			"littnhskrq",
			"utxvsizqnk",
			"lslqz",
			"jxn",
			"gmm",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
					"o",
				},
			},
			operation{
				start: Loc{3, 1},
				end:   Loc{3, 1},
				text: []string{
					"zaq",
					"avb",
				},
			},
			operation{
				start: Loc{4, 1},
				end:   Loc{1, 5},
				text: []string{
					"jlr",
					"zl",
					"j",
				},
			},
		},
		[]string{
			"f",
			"o",
			"litzaq",
			"avbtjlr",
			"zl",
			"jmm",
		},
	)
}

func TestAuto3(t *testing.T) {
	check(
		t,
		[]string{
			"ofw",
			"qsxmziuvzw",
			"rp",
			"qsnymek",
			"elth",
			"wmgzbwudxz",
			"iwsdkndh",
			"bujlbwb",
			"asuouxfv",
			"xuccnb",
		},
		[]operation{
			operation{
				start: Loc{2, 3},
				end:   Loc{2, 3},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"ofw",
			"qsxmziuvzw",
			"rp",
			"qsnymek",
			"elth",
			"wmgzbwudxz",
			"iwsdkndh",
			"bujlbwb",
			"asuouxfv",
			"xuccnb",
		},
	)
}

func TestAuto4(t *testing.T) {
	check(
		t,
		[]string{
			"fefymj",
			"qum",
			"vmiwxxaiqq",
			"dz",
			"lnqdgorosf",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{4, 0},
				text: []string{
					"hp",
				},
			},
			operation{
				start: Loc{6, 0},
				end:   Loc{0, 1},
				text: []string{
					"kcg",
					"",
					"mpx",
				},
			},
			operation{
				start: Loc{1, 1},
				end:   Loc{1, 1},
				text: []string{
					"",
					"aw",
					"",
				},
			},
			operation{
				start: Loc{1, 1},
				end:   Loc{1, 1},
				text: []string{
					"vqr",
					"mo",
				},
			},
			operation{
				start: Loc{1, 3},
				end:   Loc{2, 4},
				text: []string{
					"xyc",
				},
			},
		},
		[]string{
			"fehpmjkcg",
			"",
			"mpxq",
			"aw",
			"vqr",
			"moum",
			"vmiwxxaiqq",
			"dxycqdgorosf",
		},
	)
}

func TestBug19872UndoIsFunky(t *testing.T) {
	check(
		t,
		[]string{
			"something",
			" A",
			"",
			" B",
			"something else",
		},
		[]operation{
			operation{
				start: Loc{0, 1},
				end:   Loc{1, 1},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{0, 2},
				end:   Loc{1, 3},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"something",
			"A",
			"B",
			"something else",
		},
	)
}

func TestBug19872UndoIsFunky_2(t *testing.T) {
	check(
		t,
		[]string{
			"something",
			"A",
			"B",
			"something else",
		},
		[]operation{
			operation{
				start: Loc{0, 1},
				end:   Loc{0, 1},
				text: []string{
					" ",
				},
			},
			operation{
				start: Loc{0, 2},
				end:   Loc{0, 2},
				text: []string{
					"",
					" ",
				},
			},
		},
		[]string{
			"something",
			" A",
			"",
			" B",
			"something else",
		},
	)
}

func TestInsertEmptyText(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestLastOpIsNoOp(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{0, 3},
				end:   Loc{0, 3},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"y First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertTextWithoutNewline1(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"foo ",
				},
			},
		},
		[]string{
			"foo My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertTextWithoutNewline2(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					" foo",
				},
			},
		},
		[]string{
			"My foo First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertOneNewline(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{3, 0},
				end:   Loc{3, 0},
				text: []string{
					"",
					"",
				},
			},
		},
		[]string{
			"My ",
			"First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertTextWithOneNewline(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					" new line",
					"No longer",
				},
			},
		},
		[]string{
			"My new line",
			"No longer First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertTextWithTwoNewlines(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					" new line",
					"One more line in the middle",
					"No longer",
				},
			},
		},
		[]string{
			"My new line",
			"One more line in the middle",
			"No longer First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertTextWithManyNewlines(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					"",
					"",
					"",
					"",
					"",
				},
			},
		},
		[]string{
			"My",
			"",
			"",
			"",
			" First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestInsertMultipleNewlines(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					"",
					"",
					"",
					"",
					"",
				},
			},
			operation{
				start: Loc{14, 2},
				end:   Loc{14, 2},
				text: []string{
					"a",
					"b",
				},
			},
		},
		[]string{
			"My",
			"",
			"",
			"",
			" First Line",
			"\t\tMy Second Line",
			"    Third Linea",
			"b",
			"",
			"1",
		},
	)
}

func TestDeleteEmptyText(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteTextFromOneLine(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"y First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteTextFromOneLine2(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{2, 0},
				text: []string{
					"a",
				},
			},
		},
		[]string{
			"a First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteAllTextFromALine(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{13, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteTextFromTwoLines(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{3, 0},
				end:   Loc{5, 1},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"My Second Line",
			"    Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteTextFromManyLines(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{3, 0},
				end:   Loc{4, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"My Third Line",
			"",
			"1",
		},
	)
}

func TestDeleteEverything(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"1",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 4},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"",
		},
	)
}

func TestTwoUnrelatedEdits(t *testing.T) {
	check(
		t,
		[]string{
			"My First Line",
			"\t\tMy Second Line",
			"    Third Line",
			"",
			"123",
		},
		[]operation{
			operation{
				start: Loc{0, 1},
				end:   Loc{2, 1},
				text: []string{
					"\t",
				},
			},
			operation{
				start: Loc{0, 2},
				end:   Loc{4, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"My First Line",
			"\tMy Second Line",
			"Third Line",
			"",
			"123",
		},
	)
}

func TestTwoEditsOnOneLine(t *testing.T) {
	check(
		t,
		[]string{
			"\t\tfirst\t    ",
			"\t\tsecond line",
			"\tthird line",
			"fourth line",
			"\t\t<!@#fifth#@!>\t\t",
		},
		[]operation{
			operation{
				start: Loc{2, 4},
				end:   Loc{6, 4},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{11, 4},
				end:   Loc{15, 4},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"\t\tfirst\t    ",
			"\t\tsecond line",
			"\tthird line",
			"fourth line",
			"\t\tfifth\t\t",
		},
	)
}

func TestManyEdits(t *testing.T) {
	check(
		t,
		[]string{
			"{\"x\" : 1}",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{1, 0},
				text: []string{
					"\n  ",
				},
			},
			operation{
				start: Loc{4, 0},
				end:   Loc{5, 0},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{8, 0},
				end:   Loc{8, 0},
				text: []string{
					"\n",
				},
			},
		},
		[]string{
			"{",
			"  \"x\": 1",
			"}",
		},
	)
}

func TestManyEditsReversed(t *testing.T) {
	check(
		t,
		[]string{
			"{",
			"  \"x\": 1",
			"}",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{2, 1},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{5, 1},
				end:   Loc{5, 1},
				text: []string{
					" ",
				},
			},
			operation{
				start: Loc{8, 1},
				end:   Loc{0, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"{\"x\" : 1}",
		},
	)
}

func TestReplacingNewlines1(t *testing.T) {
	check(
		t,
		[]string{
			"{",
			"\"a\": true,",
			"",
			"\"b\": true",
			"}",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{0, 1},
				text: []string{
					"",
					"\t",
				},
			},
			operation{
				start: Loc{10, 1},
				end:   Loc{0, 3},
				text: []string{
					"",
					"\t",
				},
			},
		},
		[]string{
			"{",
			"\t\"a\": true,",
			"\t\"b\": true",
			"}",
		},
	)
}

func TestReplacingNewlines2(t *testing.T) {
	check(
		t,
		[]string{
			"some text",
			"some more text",
			"now comes an empty line",
			"",
			"after empty line",
			"and the last line",
		},
		[]operation{
			operation{
				start: Loc{4, 0},
				end:   Loc{0, 2},
				text: []string{
					" text",
					"some more text",
					"some more text",
				},
			},
			operation{
				start: Loc{1, 2},
				end:   Loc{0, 3},
				text: []string{
					"o more lines",
					"asd",
					"asd",
					"asd",
				},
			},
			operation{
				start: Loc{0, 4},
				end:   Loc{5, 4},
				text: []string{
					"zzzzzzzz",
				},
			},
			operation{
				start: Loc{10, 4},
				end:   Loc{15, 5},
				text: []string{
					"1",
					"2",
					"3",
					"4",
				},
			},
		},
		[]string{
			"some text",
			"some more text",
			"some more textno more lines",
			"asd",
			"asd",
			"asd",
			"zzzzzzzz empt1",
			"2",
			"3",
			"4ne",
		},
	)
}

func TestAdvanced1(t *testing.T) {
	check(
		t,
		[]string{
			" {       \"d\": [",
			"             null",
			"        ] /*comment*/",
			"        ,\"e\": /*comment*/ [null] }",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{2, 0},
				end:   Loc{9, 0},
				text: []string{
					"",
					"  ",
				},
			},
			operation{
				start: Loc{15, 0},
				end:   Loc{13, 1},
				text: []string{
					"",
					"    ",
				},
			},
			operation{
				start: Loc{17, 1},
				end:   Loc{8, 2},
				text: []string{
					"",
					"  ",
				},
			},
			operation{
				start: Loc{21, 2},
				end:   Loc{8, 3},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{9, 3},
				end:   Loc{9, 3},
				text: []string{
					"",
					"  ",
				},
			},
			operation{
				start: Loc{27, 3},
				end:   Loc{27, 3},
				text: []string{
					"",
					"    ",
				},
			},
			operation{
				start: Loc{31, 3},
				end:   Loc{31, 3},
				text: []string{
					"",
					"  ",
				},
			},
			operation{
				start: Loc{32, 3},
				end:   Loc{33, 3},
				text: []string{
					"",
					"",
				},
			},
		},
		[]string{
			"{",
			"  \"d\": [",
			"    null",
			"  ] /*comment*/,",
			"  \"e\": /*comment*/ [",
			"    null",
			"  ]",
			"}",
		},
	)
}

func TestAdvancedSimplified(t *testing.T) {
	check(
		t,
		[]string{
			"   abc",
			" ,def",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{3, 0},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{6, 0},
				end:   Loc{1, 1},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{2, 1},
				end:   Loc{2, 1},
				text: []string{
					"",
					"",
				},
			},
		},
		[]string{
			"abc,",
			"def",
		},
	)
}

func TestIssue144(t *testing.T) {
	check(
		t,
		[]string{
			"package caddy",
			"",
			"func main() {",
			"\tfmt.Println(\"Hello World! :)\")",
			"}",
			"",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 5},
				text: []string{
					"package caddy",
					"",
					"import \"fmt\"",
					"",
					"func main() {",
					"\tfmt.Println(\"Hello World! :)\")",
					"}",
					"",
				},
			},
		},
		[]string{
			"package caddy",
			"",
			"import \"fmt\"",
			"",
			"func main() {",
			"\tfmt.Println(\"Hello World! :)\")",
			"}",
			"",
		},
	)
}

func TestIssue2586ReplacingSelectedEndOfLineWithNewlineLocksUpTheDocument(t *testing.T) {
	check(
		t,
		[]string{
			"something",
			"interesting",
		},
		[]operation{
			operation{
				start: Loc{9, 0},
				end:   Loc{0, 1},
				text: []string{
					"",
					"",
				},
			},
		},
		[]string{
			"something",
			"interesting",
		},
	)
}

func TestIssue3980(t *testing.T) {
	check(
		t,
		[]string{
			"class A {",
			"    someProperty = false;",
			"    someMethod() {",
			"    this.someMethod();",
			"    }",
			"}",
		},
		[]operation{
			operation{
				start: Loc{7, 0},
				end:   Loc{8, 0},
				text: []string{
					"",
					"",
				},
			},
			operation{
				start: Loc{16, 2},
				end:   Loc{17, 2},
				text: []string{
					"",
					"",
				},
			},
			operation{
				start: Loc{17, 2},
				end:   Loc{17, 2},
				text: []string{
					"    ",
				},
			},
			operation{
				start: Loc{4, 3},
				end:   Loc{4, 3},
				text: []string{
					"    ",
				},
			},
		},
		[]string{
			"class A",
			"{",
			"    someProperty = false;",
			"    someMethod()",
			"    {",
			"        this.someMethod();",
			"    }",
			"}",
		},
	)
}

func TestTouchingEditsTwoInsertsAtTheSamePosition(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"a",
				},
			},
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"b",
				},
			},
		},
		[]string{
			"abhello world",
		},
	)
}

func TestTouchingEditsInsertAndReplaceTouching(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"b",
				},
			},
			operation{
				start: Loc{0, 0},
				end:   Loc{2, 0},
				text: []string{
					"ab",
				},
			},
		},
		[]string{
			"babllo world",
		},
	)
}

func TestTouchingEditsTwoTouchingReplaces(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"H",
				},
			},
			operation{
				start: Loc{1, 0},
				end:   Loc{2, 0},
				text: []string{
					"E",
				},
			},
		},
		[]string{
			"HEllo world",
		},
	)
}

func TestTouchingEditsTwoTouchingDeletes(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
				},
			},
			operation{
				start: Loc{1, 0},
				end:   Loc{2, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"llo world",
		},
	)
}

func TestTouchingEditsInsertAndReplace(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"H",
				},
			},
			operation{
				start: Loc{0, 0},
				end:   Loc{2, 0},
				text: []string{
					"e",
				},
			},
		},
		[]string{
			"Hello world",
		},
	)
}

func TestTouchingEditsReplaceAndInsert(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{2, 0},
				text: []string{
					"H",
				},
			},
			operation{
				start: Loc{2, 0},
				end:   Loc{2, 0},
				text: []string{
					"e",
				},
			},
		},
		[]string{
			"Hello world",
		},
	)
}

func TestSingleDelete1(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{1, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"ello world",
		},
	)
}

func TestSingleDelete2(t *testing.T) {
	check(
		t,
		[]string{
			"helloworld",
		},
		[]operation{
			operation{
				start: Loc{2, 0},
				end:   Loc{7, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"herld",
		},
	)
}

func TestSingleDelete3(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{5, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			" world",
		},
	)
}

func TestSingleDelete4(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{6, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"hworld",
		},
	)
}

func TestSingleDelete5(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{11, 0},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"",
		},
	)
}

func TestMultiDelete6(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
			"hello world",
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{5, 0},
				end:   Loc{5, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"hello world",
		},
	)
}

func TestMultiDelete7(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
			"hello world",
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{11, 0},
				end:   Loc{11, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"hello world",
		},
	)
}

func TestMultiDelete8(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
			"hello world",
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"hello world",
		},
	)
}

func TestMultiDelete9(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
			"hello world",
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{11, 0},
				end:   Loc{0, 2},
				text: []string{
					"",
				},
			},
		},
		[]string{
			"hello worldhello world",
		},
	)
}

func TestSingleInsert1(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"xx",
				},
			},
		},
		[]string{
			"xxhello world",
		},
	)
}

func TestSingleInsert2(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{1, 0},
				end:   Loc{1, 0},
				text: []string{
					"xx",
				},
			},
		},
		[]string{
			"hxxello world",
		},
	)
}

func TestSingleInsert3(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{5, 0},
				end:   Loc{5, 0},
				text: []string{
					"xx",
				},
			},
		},
		[]string{
			"helloxx world",
		},
	)
}

func TestSingleInsert4(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{6, 0},
				end:   Loc{6, 0},
				text: []string{
					"xx",
				},
			},
		},
		[]string{
			"hello xxworld",
		},
	)
}

func TestSingleInsert5(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{11, 0},
				end:   Loc{11, 0},
				text: []string{
					"xx",
				},
			},
		},
		[]string{
			"hello worldxx",
		},
	)
}

func TestMultiInsert6(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{0, 0},
				end:   Loc{0, 0},
				text: []string{
					"\n",
				},
			},
		},
		[]string{
			"",
			"hello world",
		},
	)
}

func TestMultiInsert7(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{11, 0},
				end:   Loc{11, 0},
				text: []string{
					"\n",
				},
			},
		},
		[]string{
			"hello world",
			"",
		},
	)
}

func TestMultiInsert8(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{6, 0},
				end:   Loc{6, 0},
				text: []string{
					"\n",
				},
			},
		},
		[]string{
			"hello ",
			"world",
		},
	)
}

func TestMultiInsert9(t *testing.T) {
	check(
		t,
		[]string{
			"hello world",
			"hello world",
		},
		[]operation{
			operation{
				start: Loc{6, 0},
				end:   Loc{6, 0},
				text: []string{
					"xx\nyy",
				},
			},
		},
		[]string{
			"hello xx",
			"yyworld",
			"hello world",
		},
	)
}

func BenchmarkBuffer(b *testing.B) {
	for i := 0; i < b.N; i++ {
		TestAuto1(nil)
		TestAuto2(nil)
		TestAuto3(nil)
		TestAuto4(nil)
		TestBug19872UndoIsFunky(nil)
		TestBug19872UndoIsFunky_2(nil)
		TestInsertEmptyText(nil)
		TestLastOpIsNoOp(nil)
		TestInsertTextWithoutNewline1(nil)
		TestInsertTextWithoutNewline2(nil)
		TestInsertOneNewline(nil)
		TestInsertTextWithOneNewline(nil)
		TestInsertTextWithTwoNewlines(nil)
		TestInsertTextWithManyNewlines(nil)
		TestInsertMultipleNewlines(nil)
		TestDeleteEmptyText(nil)
		TestDeleteTextFromOneLine(nil)
		TestDeleteTextFromOneLine2(nil)
		TestDeleteAllTextFromALine(nil)
		TestDeleteTextFromTwoLines(nil)
		TestDeleteTextFromManyLines(nil)
		TestDeleteEverything(nil)
		TestTwoUnrelatedEdits(nil)
		TestTwoEditsOnOneLine(nil)
		TestManyEdits(nil)
		TestManyEditsReversed(nil)
		TestReplacingNewlines1(nil)
		TestReplacingNewlines2(nil)
		TestAdvanced1(nil)
		TestAdvancedSimplified(nil)
		TestIssue144(nil)
		TestIssue2586ReplacingSelectedEndOfLineWithNewlineLocksUpTheDocument(nil)
		TestIssue3980(nil)
		TestTouchingEditsTwoInsertsAtTheSamePosition(nil)
		TestTouchingEditsInsertAndReplaceTouching(nil)
		TestTouchingEditsTwoTouchingReplaces(nil)
		TestTouchingEditsTwoTouchingDeletes(nil)
		TestTouchingEditsInsertAndReplace(nil)
		TestTouchingEditsReplaceAndInsert(nil)
		TestSingleDelete1(nil)
		TestSingleDelete2(nil)
		TestSingleDelete3(nil)
		TestSingleDelete4(nil)
		TestSingleDelete5(nil)
		TestMultiDelete6(nil)
		TestMultiDelete7(nil)
		TestMultiDelete8(nil)
		TestMultiDelete9(nil)
		TestSingleInsert1(nil)
		TestSingleInsert2(nil)
		TestSingleInsert3(nil)
		TestSingleInsert4(nil)
		TestSingleInsert5(nil)
		TestMultiInsert6(nil)
		TestMultiInsert7(nil)
		TestMultiInsert8(nil)
		TestMultiInsert9(nil)
	}
}
