/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include <QFileSystemModel>
#include <QFileIconProvider>
#include <QFileDialog>
#include <QFileInfo>
#include <QModelIndex>
#include <QSortFilterProxyModel>
#include <QString>


class MvQPixmapCache;

class MvQFileIconProvider : public QFileIconProvider
{
public:
    MvQFileIconProvider();
    QIcon icon(const QFileInfo&) const;

private:
    QString path_;
    MvQPixmapCache* pixCache_;
    QString mvHome_;
};


class MvQFileDialogFilterModel : public QSortFilterProxyModel
{
public:
    MvQFileDialogFilterModel(QObject* parent = 0);
    bool filterAcceptsRow(int, const QModelIndex&) const;
    bool lessThan(const QModelIndex&, const QModelIndex&) const;
};

class MvQFileDialog : public QFileDialog
{
public:
    MvQFileDialog(QString, QString, QWidget* parent = 0);
};
