/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// -*-C++-*-
// Header file for Hovmoeller application


#pragma once

#include "Metview.h"
#include "MvDate.h"

const double HMISSING_VALUE = 1.0E22;

#define HOV_STEPSIZE 6  // number of characters to represent parameter STEP

// Holds info about the values for one entry in
// the matrix (e.g. values for one time or level)
class IndexesInfo
{
public:
    double* Values() { return values_; }
    double Index() { return index_; }

private:
    friend class ParamInfo;

    IndexesInfo(double index) :
        values_(0),
        index_(index) {}

    double* values_;
    double index_;
};

typedef std::map<std::string, IndexesInfo*> IndexesMap;
typedef IndexesMap::iterator IndexIterator;
typedef IndexesMap::reverse_iterator ReverseIndexIterator;

// Info about a parameter at one level and expver
// Contains  a IndexesMap with info about the times (date+time+step)
class ParamInfo
{
public:
    ParamInfo();
    ParamInfo(int, double, double, std::string, std::string, std::string, std::string);

    ~ParamInfo();

    MvDate& Date() { return date_; }
    int Parameter() { return param_; }
    std::string ParamName() { return paramName_; }
    std::string ParamLongName() { return paramLongName_; }
    std::string Units() { return units_; }

    double Level() { return level_; }
    std::string LevelTitle();

    std::string ExpVer() { return expver_; }
    std::string ExpVerTitle();
    void ExpVer(const char* xx) { expver_ = xx; }

    void FillIndex(double*, const std::string&, int);
    IndexesMap& Indexes() { return indexes_; }

    void AddIndex(std::string& index);
    int NrIndexes() { return indexes_.size(); }

    friend int operator<(const ParamInfo& p1, const ParamInfo& p2)
    {
        return (p1.param_ < p2.param_ || p1.date_ < p2.date_ || p1.level_ < p2.level_);
    }

private:
    int param_;
    double level_;
    MvDate date_;
    std::string expver_;
    std::string paramName_;
    std::string paramLongName_;
    std::string units_;
    IndexesMap indexes_;
};

typedef std::map<std::string, ParamInfo*> ParamMap;
typedef ParamMap::iterator ParamIterator;
typedef std::pair<ParamIterator, bool> ParamInsertPair;
typedef std::pair<const std::string, ParamInfo*> ParamPair;
