/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#pragma once

#include "Hovmoeller.h"
#include "HovToolkit.h"

class HovHeightToolkit : public HovToolkit
{
public:
    // Common functions
    bool GenerateData(MvRequest&);
    std::string GetTitle(ParamInfo*);
    const char* GetSecondCoordName() { return "vertical"; }
    bool SecondAuxiliaryCoord() { return false; }
    const char* ApplicationType() { return "VERTICAL_HOVM"; }
    bool NcWriteSecondCoord();
    void NcWriteGlobalAttributesApp();

    // Functions to handle list of levels
    void InitializeLevelList() { coord1_.clear(); }
    void UpdateLevelList(MvField&, double);

    // Calculate diagram values
    bool ComputeValues(MvField&, int);

    // Compute coordinates
    bool ComputeSecondCoord();

    // Create access keys
    void GenerateKey(std::string&, MvRequest&);

    // Initialize variables
    bool GetInputInfo(MvRequest&);  //from user interface
    bool GetInputInfo(MvNetCDF*);   //from the netCDF file

    // Check if parameters between two requests are consistent
    bool consistencyCheck(MvRequest&, MvRequest&);

private:
    // Create View request
    MvRequest CreateViewRequest();

    int vertAxisType_;  // Flag to indicate the type of the Vertical axis
};

//---------------------------------------------------------------------

class HeightHovmoeller : public HovHeightToolkit, public Hovmoeller
{
public:
    HeightHovmoeller() :
        Hovmoeller("VERTICAL_HOVM") {}
    HeightHovmoeller(const char* kw) :
        Hovmoeller(kw) {}

    ~HeightHovmoeller() = default;

    // Entry point
    void serve(MvRequest&, MvRequest&);
};

static SimpleObjectMaker<HovHeightToolkit, HovToolkit> height("VERTICAL_HOVM");

//---------------------------------------------------------------------

class HeightHovmoellerM3 : public HeightHovmoeller
{
public:
    HeightHovmoellerM3() :
        HeightHovmoeller("HEIGHT_HOV") {}
    ~HeightHovmoellerM3() = default;

    // Entry point
    void serve(MvRequest&, MvRequest&);
};
