/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQProcModel_H
#define MvQProcModel_H

#include <QAbstractItemModel>
#include <QColor>
#include <QSortFilterProxyModel>

#include "MvProcNode.h"

class MvQPixmapCache;


class MvQProcFilterModel : public QSortFilterProxyModel
{
public:
    MvQProcFilterModel(QObject* parent = 0);
    bool lessThan(const QModelIndex& left,
                  const QModelIndex& right) const;
};

class MvQProcModel : public QAbstractItemModel, public MvProcNodeObserver
{
public:
    MvQProcModel(QObject* parent = 0);

    int columnCount(const QModelIndex& parent = QModelIndex()) const;
    int rowCount(const QModelIndex& parent = QModelIndex()) const;

    QVariant data(const QModelIndex&, int role = Qt::DisplayRole) const;
    QVariant headerData(int, Qt::Orientation, int role = Qt::DisplayRole) const;

    QModelIndex index(int, int, const QModelIndex& parent = QModelIndex()) const;
    QModelIndex parent(const QModelIndex&) const;

    void dataIsAboutToChange();
    void changeData(MvProcNode*);
    void updateData();
    MvProcNode* itemForIndex(const QModelIndex&) const;
    MvQPixmapCache* pixmapCache() { return pm_; }

    //Observer method
    void infoChanged(MvProcNode*);

protected:
    QModelIndex indexForItem(MvProcNode*, int);

    MvProcNode* rootItem_;
    QColor cpuYellow_;
    QColor cpuOrange_;
    QColor cpuRed_;
    QColor textGrey_;

    MvQPixmapCache* pm_;
};

#endif
