/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Path_H
#define Path_H

#include <sys/types.h>
#include <time.h>

#include <string>
using std::string;

#include "inc_iostream.h"
#include "inc_stl.h"

#include "Metview.h"

class MvRequest;

class Path {
public:

// -- Exceptions
	// None

// -- Contructors

	Path(const string&);

// -- Destructor

	~Path(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	const string& str() const;

	string relativePath(const Path&) const;
	Path add(const string&) const;

	Path   directory() const;
	string name() const;
	Path   dot() const;

	void rename(const Path&) const;
	void copy(const Path&) const;
	bool copyData(const Path&) const;
	void touch() const;
	void remove() const;
	void mkdir() const;
	void symlink(const Path&) const;
	std::string symlinkTarget() const;

	set<string> files() const;
    set<string> directories() const;

	bool exists() const;
	bool locked() const;
	
	string loadText() const;
	void   saveText(const string&) const;

	MvRequest loadRequest() const;
	void saveRequest(const MvRequest&) const;

	time_t lastModified() const;
	off_t sizeInBytes() const;

	void makeWritableByUser() const;
	string permissions() const;
	string owner() const;
    string group() const;
    void nameAndSuffix(string& namePart,string& suffixPart) const;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

// -- Members
	// None

// -- Methods

	string path_;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	friend ostream& operator<<(ostream& s,const Path& p)
		{ p.print(s); return s; }

};

inline void destroy(Path**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(Path);
//#endif

#endif
