/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvMessageMetaData_H
#define MvMessageMetaData_H

#include <string>
#include <vector>

#ifdef METVIEW
//For off_t
#include "mars.h"
#else
#include <sys/types.h>
#endif

using namespace std;

class MvKeyProfile;
class MvMessageMetaDataObserver; 

class MvMessageMetaData 
{
public: 
    MvMessageMetaData() : messageNum_(0), totalMessageNum_(0),
                          firstScan_(true), filterEnabled_(false) {}
    virtual ~MvMessageMetaData() {}

    const string& fileName() const {return fileName_;}
	virtual void setFileName(string)=0;	  	
	int  messageNum() {return messageNum_;}
	int  totalMessageNum() {return totalMessageNum_;}	
	virtual int getEstimatedMessageNum()=0;
	virtual void loadKeyProfile(MvKeyProfile *)=0;
    void registerObserver(MvMessageMetaDataObserver* obs);
	virtual bool useMessageSizeForProgressIndicator() {return false;}
	bool isFilterEnabled(){ return filterEnabled_;}
    virtual void setFilter(vector<off_t>,vector<int>){}
	int unfilteredMessageCnt(int cntStartFromZero)
		 {return (filterEnabled_)?(filterCnt_[cntStartFromZero]):cntStartFromZero+1;}

protected:			
    typedef void (MvMessageMetaDataObserver::*IntMethod)(int);
    typedef void (MvMessageMetaDataObserver::*VoidMethod)();
    void broadcast(IntMethod,int);
    void broadcast(VoidMethod);

    virtual void clear() {fileName_.clear(); messageNum_=0; totalMessageNum_=0; firstScan_=true;
                  filterEnabled_=false,
                  filterOffset_.clear(); filterLen_.clear(); filterCnt_.clear();}

    string fileName_;
	int messageNum_;
	int totalMessageNum_;
	bool firstScan_;
	bool filterEnabled_;
	vector<off_t> filterOffset_;
	vector<int> filterLen_;
	vector<int> filterCnt_;

    std::vector<MvMessageMetaDataObserver*> observers_;

};


class MvMessageMetaDataObserver 
{

public:
    MvMessageMetaDataObserver() {}
    virtual ~MvMessageMetaDataObserver() {}
    
    virtual void messageScanStepChanged(int) {}
    virtual void locationScanStepChanged(int) {}
    virtual void messageFilterStarted() {}
    virtual void messageFilterFinished() {}

};

#endif
