/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQKeyModel_H
#define MvQKeyModel_H

#include <QAbstractItemModel>
#include <QMimeData>
#include <QPixmap>
#include <QStringList>

class MvQPixmapCache;

class MvKeyProfile;
class MvKey;

class MvQKeyModel : public QAbstractItemModel
{
	Q_OBJECT

public:
	enum DisplayMode {ProfileContentsMode,AllKeysMode,ShortNameMode};

    MvQKeyModel(DisplayMode mode,QObject* parent);
    MvQKeyModel(MvKeyProfile*,DisplayMode mode,QObject* parent);

   	virtual int columnCount (const QModelIndex& parent = QModelIndex() ) const;
   	virtual int rowCount (const QModelIndex& parent = QModelIndex() ) const;

   	virtual QVariant data (const QModelIndex& , int role = Qt::DisplayRole ) const;
   	virtual bool setData( const QModelIndex &, const QVariant &, int role = Qt::EditRole ); 
	virtual QVariant headerData(int,Qt::Orientation,int role = Qt::DisplayRole ) const;
 
   	QModelIndex index (int, int, const QModelIndex& parent = QModelIndex() ) const;
   	QModelIndex parent (const QModelIndex & ) const;

	void profileIsAboutToChange();
	MvKeyProfile* profile() {return profile_;}
	void setKeyProfile(MvKeyProfile*);
	void moveUp(const QModelIndex& index);
	void moveDown(const QModelIndex& index);

	Qt::ItemFlags flags ( const QModelIndex &) const;

	Qt::DropActions supportedDropActions() const;
	QStringList mimeTypes() const;
	QMimeData* mimeData(const QModelIndexList &) const;
	bool dropMimeData(const QMimeData *data,
     			Qt::DropAction action, int row, int column, 
			const QModelIndex &parent);

	void setEditable(bool b) {editable_=b;}
	bool editable() {return editable_;}
	
	void setPixmapCache(MvQPixmapCache* p) {pixmaps_=p;}


protected:
	virtual QString label(MvKey*,const int,const int,int) const;
	void moveRow(int,int);

	MvKeyProfile  *profile_;
	DisplayMode mode_;
	bool editable_;
	MvQPixmapCache *pixmaps_;;
};

#endif
