/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ServiceEditor_H
#define ServiceEditor_H

#include "Editor.h"
#include "ReplyObserver.h"

class ServiceEditor;

class ServiceEditorObserver : public ReplyObserver 
{
public:

	ServiceEditorObserver (ServiceEditor &editor, string &path);
	virtual ~ServiceEditorObserver(); 

	virtual void start();

	// From ReplyObserver
	virtual void reply(const Request&, int);
	virtual void progress(const Request&);  
	virtual void message(const string&);

protected:
	 void print(ostream&) const; 

private:
	// No copy allowed
    	ServiceEditorObserver(const ServiceEditorObserver&);
	ServiceEditorObserver& operator=(const ServiceEditorObserver&);

    	ServiceEditor &editor_;
    	string         path_;
};


class ServiceEditor :public Editor 
{
public:
	ServiceEditor(const IconClass&,const string&);
	virtual ~ServiceEditor();
	void changed() {};
	void raiseIt() {};
	void merge(IconObject*) {};
	void replace(IconObject*) {};	

private:
	// No copy allowed
	ServiceEditor(const ServiceEditor&);
	ServiceEditor& operator=(const ServiceEditor&);

	void edit(void);
	void showIt() {}

    	ServiceEditorObserver *replyObserver_;

};

inline void destroy(ServiceEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(MacroEditor);
//#endif

#endif
