/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

//
// .NAME:
//  CartesianView
//
// .AUTHOR:
//  Fernando Ii, Sylvie Thepaut
//
// .SUMMARY:
//  Describes the CartesianView class
//
// .CLIENTS:
//  Page
//
// .RESPONSIBILITY:
//
// .COLLABORATORS:
//
// .ASCENDENT:
//  PlotModView, PlotModTable
//
// .DESCENDENT:
//
//
#ifndef CartesianView_H
#define CartesianView_H

#include "MvIconDataBase.h"
#include "PlotModView.h"

class CartesianView;

class CartesianView: public PlotModView
{
public:

    // Constructor
    CartesianView( Page&, const MvRequest&, const MvRequest&,
                   const string &haxisName = "HORIZONTAL_AXIS",
                   const string &vaxisName = "VERTICAL_AXIS",
                   const string &viewName  = "cartesianview"
                 );

    CartesianView(const CartesianView&);
    virtual PlotModView *Clone() const { return new CartesianView(*this); }

    // Destructor
    ~CartesianView();

    // Methods overriden from PlotModView class
    virtual string Name();

    // Replace the current axis ( axis are the background of this view )
    void ReplaceAxis ( MvRequest& );
   void ProcessAxis ( MvRequest& );

    // Decode the data Unit
    virtual void DecodeDataUnit ( MvIcon& );

    // Draw the background (axis )
    virtual void DrawBackground ( );

    // Draw the background (axis )
    virtual void DrawForeground ( ) { };

    virtual void Draw (SubPage*);

    // Describe the contents of the view
    virtual void DescribeYourself ( ObjectInfo& );

    void Drop ( PmContext& );

    void DescribeAxis ( ObjectInfo&, MvRequest&, const Cached& );

    MvIconList InsertDataRequest ( MvRequest& );

    virtual bool BackgroundFromData() const { return true; }  

    // Remove all visdefs when Page::EraseDraw is called. Segments
    // names does not correspond to visdefs in hierarchy
    virtual bool EraseAll() { return true; }

   int RetrieveBackground( MvRequest& );

protected:

    // Update X/Y axes type in the view
    void  UpdateAxisTypeView ( MvRequest& );

    string hAxisName_, vAxisName_, viewName_;

    const char* CheckDataRequest(MvIcon&,MvIconList&);

private:

   // Get list of background parameters according to the projection
   void GetBackgroundParameters ( vector<string>& );

   // No assignment
   CartesianView& operator=(const CartesianView&);

};
#endif
