/***************************** LICENSE START ***********************************

 Copyright 2016 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef uPlotBase_H
#define uPlotBase_H

#include <QComboBox>
#include <QModelIndex>
#include <QPointF>
#include <QSettings>

#include "MvQDragDrop.h"
#include "MvQMainWindow.h"
#include "MvQMenuItem.h"

#include "Presentable.h"

class MvRequest;

class QAction;
class QComboBox;
class QGraphicsRectItem;
class QGraphicsScene;
class QGraphicsView;
class QLabel;
class QSlider;

class ExportDialog;
class MgQPlotScene;
class MgQSceneItem;
class MvQDrop;
class MvQPlotView;
class MvQZoomStackWidget;

using namespace std;

class uPlotBase : public MvQMainWindow
{
    Q_OBJECT

public:
	uPlotBase(QWidget *parent = 0);
	virtual ~uPlotBase();

	void setPlot(float hor,float ver);
	void setPlotWidgetSize(float hor,float ver);
	void messageToLogWindow (const string&, int severity);
	
	MvQPlotView*  plotView() {return plotView_;}
	MgQPlotScene* plotScene() {return plotScene_;}
		
	virtual void newRequestForDriversBegin() =0;
	virtual void newRequestForDriversEnd()  =0;
	virtual void progressMessage(const string&) {};
		
	void processContentsRequest(MvRequest&);

   void setPresentable(Presentable& owner)
      { owner_ = &owner;}

	virtual MvRequest SuperPageRequest( ) { return MvRequest();}

    void tempDir(string& dir)
       { uPlotTempDir_ = dir; }
    static string& tempDir()
       { return uPlotTempDir_; }

#ifdef METVIEW_WEATHER_ROOM
   // Wheater room
   bool plotWeatherRoom( bool checkSync = false );
#endif

signals:
	void plotWindowUpdated();
	void plotScaleChanged();
	void sendDropRequest(MvRequest*);

public slots:
	virtual void processDrop(MvQIconDropItem*);
	void slotEnableAntialias(bool);
	void slotEnableOpenGL(bool);
	void slotZoomStackLevelChanged(QString,int);
	void slotPerformZoom(const string& sid,const string &def);
	void slotStepCacheStateChanged();	
	void slotLoadExportDialog();
	void slotLoadPrintDialog();
	void slotGenerateMacro();
   void slotLoadEcChartsDialog();
	void slotExpDialogInfo(MvRequest*);
	void slotShowAboutBox();
	void slotSizeChanged(int);
	void slotSizeDown();
	void slotSizeUp();	
	void slotBuildContextMenu(const QPoint&,const QPointF&);
	void slotResizeEvent(const QSize &);
	void slotProcessDropInView(const MvQDrop&,QPoint);	
	virtual void slotSetActiveScene(MgQSceneItem*)=0;

	// Weather room
	void slotLoadWeatherRoomDialog();
	void slotEnableWroomSync(bool);


protected:
	void SetupResources();

	virtual void setupViewActions();
	void setupZoomActions();
	void setupHelpActions();
	void setupContextMenuActions();

	void updateZoomActionState();	
	void updateResizeActionState();

	virtual bool setDropTarget(QPoint)=0;
	virtual bool setDropTargetInView(QPoint)=0;
	virtual int currentStep()=0;
	virtual int stepNum()=0;
	
	void setCustomSize(int);
	float currentSizeRatio();
	void changeSize(int,bool renderIt=true);
	int screenResolutionInDpi();
	
	virtual void loadStarted() {};
	virtual void loadFinished() {};

	virtual void writeSettings()=0;
    virtual void readSettings()=0;

    static Presentable* owner_;

    // Temporary directory name related to this session.
    // It can be used to store temporary files ,e.g. Layers icon editing.
    static string uPlotTempDir_;

	MvQMainWindow::MenuItemMap menuItems_;
		
	MvQPlotView* plotView_;
	MgQPlotScene* plotScene_;

	//Zoom
	MvQZoomStackWidget* zoomStackWidget_;
	QAction* actionZoomUp_;
	QAction* actionZoomDown_;

	//Context menu 
	QAction* actionContextSelectScene_;
	QAction* actionContextZoomUp_;
	QAction* actionContextZoomDown_;
	
	//Active scene
	MgQSceneItem* activeScene_;
	string prevActiveSceneId_;

	//Size
	enum SizeOptions {FitToWindow=-1,FitToWidth=-2,FitToHeight=-3};
	QAction* actionSizeDown_;
	QAction* actionSizeUp_;
	QComboBox* sizeCombo_;
	QList<int> predefSizeValues_;
	int sizeMinValue_;
	int sizeMaxValue_;
	int sizeValueStep_; 
	int customSizeItemIndex_;
	float oriPlotWidthInCm_;
	float oriPlotHeightInCm_;
	
   //Progress
   QLabel* statusMessageLabel_;

#ifdef METVIEW_WEATHER_ROOM
   // Weather room 
   void uploadWeatherRoom( const string& );
   void outputDeviceWeatherRoom( MvRequest& );
   bool syncWeatherRoom() { return wroomSync_; }

   bool wroomSync_;     // flag indicating if a plot should be sent to the video wall
   int wroomCell_;      // cell number
   string wroomWall_;   // wall id
   string wroomFormat_; // wall output graphics format
#endif
};

#endif
