/***************************** LICENSE START ***********************************

 Copyright 2017 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ShareTargets_H
#define ShareTargets_H

#include <string>
#include <vector>
#include "MvRequest.h"


/* The classes here define each 'share' target of uPlot */


/* The base class from which the 'real' share targets inherit */ 
class ShareTarget
{
public:
        ShareTarget(const std::string name);
        ~ShareTarget() {};

        virtual std::string &name() {return name_;}
        virtual void modifyPlotRequest(const MvRequest &in, MvRequest &out) {out = in;}
        virtual void upload(const std::vector<std::string> filenames) = 0;  // should throw MvException on error

private:
        std::string name_;
};


/* The registry of share targets */ 
class ShareTargets : public std::vector<ShareTarget *>
{
public:
    ShareTargets()  {};
    ~ShareTargets();

    static ShareTargets *instance();

private:
//    std::vector<ShareTarget *> targets_;
    static ShareTargets * instance_;
};


#endif
