/***************************** LICENSE START ***********************************

 Copyright 2017 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvException.h"
#include "ShareTargets.h"

/* --------------------------------------------
 * ShareTargets - the registry of share targets 
 * -------------------------------------------- */
ShareTargets *ShareTargets::instance_;
ShareTargets *ShareTargets::instance()
{
    if (!instance_)
    {
        instance_ = new ShareTargets();
    }
    return instance_;
}

ShareTargets::~ShareTargets()
{
    if (instance_)
    {
        delete instance_;
        instance_ = 0;
    }
}

/* ---------------------------------------------------------
 * ShareTarget - the base class of each type of share target 
 * --------------------------------------------------------- */

ShareTarget::ShareTarget(const std::string name) :
    name_(name)
{
    // register self to the list of available share targets
    cout << "Registering share target: " << name << std::endl;
    ShareTargets::instance()->push_back(this);
}



#ifdef SHARE_TO_GLOBE
/* ------------------------------------------------------
 * GlobeShareTarget - specific share target for the globe 
 * ------------------------------------------------------ */

class GlobeShareTarget : public ShareTarget
{
public:
    GlobeShareTarget();
    ~GlobeShareTarget() {};
    
    void modifyPlotRequest(const MvRequest &in, MvRequest &out);
    void upload(std::vector<std::string> filenames);
};


GlobeShareTarget::GlobeShareTarget() : ShareTarget("Weather Globe")
{
};


void GlobeShareTarget::modifyPlotRequest(const MvRequest &in, MvRequest &out)
{
    // XXX this is where we need to do things such as remove the coastlines, grid and title, and
    // resize the plot to fill the whole image
    out = in;
}

void GlobeShareTarget::upload(std::vector<std::string> filenames)
{
    throw MvException("upload not yet implemented for the Globe");
}
#endif //SHARE_TO_GLOBE

// create instances of the share targets we want to enable
#ifdef SHARE_TO_GLOBE
static GlobeShareTarget globeShareTarget;
#endif
