/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVMISCELANEOUS_H_
#define MVMISCELANEOUS_H_

#include <string>
#include <sstream>
#include <vector>

namespace metview {

void shellCommand(const std::string&, std::stringstream&, std::stringstream&);
bool createWorkDir(const std::string& prefix,std::string& tmpPath,std::string& errTxt);

bool checkGridFitToArea(const std::string& areaStr,const std::string& gridStr);
bool checkGrid(const std::vector<std::string>& areaStr,const std::vector<std::string>& gridStr,
               std::vector<std::string>& numXy,std::string& errStr);

double saturationMixingRatio(double t, double p);
double relativeHumidity(double t, double p,double q);
double relativeHumidityFromTd(double t, double td);
double specificHumidity(double t, double p,double r);
double specificHumidityFromTd(double t, double p,double td);
double saturationVapourPressure(double t);
double vapourPressure(double p,double q);
double vapourPPMV(double p,double q);
double ozonePPMV(double r);
double dewPointFromQ(double p, double t, double q, const std::string& formula);
double speed(double u, double v);
double direction(double u, double v);
void writeFileToLogWarn(const std::string& fileName,int maxLineNum=-1);
void writeFileToLogInfo(const std::string& fileName,int maxLineNum=-1);
void writeFileToLogErr(const std::string& fileName,int maxLineNum=-1);
void writeFileToLog(int,const std::string& fileName,int maxLineNum=-1);
std::string getLastLines(const std::string& fileName,int lastLineNum,std::string& error_msg);

inline std::string merge(const std::vector<std::string>& v,const std::string& sep)
{
    std::string res;
    for(size_t i=0; i < v.size(); i++)
    {
        if(i>0) res+=sep;
        res+=v[i];
    }
    return res;
}

template<typename TYPE>
inline std::string toString(const TYPE& in)
{
    std::ostringstream os;
	os  <<  in;
	return os.str();
}

template<typename TYPE>
inline TYPE fromString(const std::string& in)
{
    std::istringstream iss(in);
    TYPE v;
    iss >> v;
    return v;
}

} // namespace metview

#endif
