/*
 * © Copyright 1996-2012 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

#include "pproc.h"
#include "mars_client_config.h"


#include <iostream>

//----------------------------------------------------------------------------------------------------------------------


namespace marspp {

PProc::PProc() {
}

PProc::~PProc() {
}


PProcFactory& PProcFactory::instance() {
	static PProcFactory f;
	return f;
}

void PProcFactory::insert(const std::string& name, PProcBuilder* b) {
	m_[name] = b;
}

PProc* PProcFactory::build(const std::string& name) const {

	std::map<std::string, PProcBuilder*>::const_iterator f = m_.find(name);

	if(f != m_.end()) {

		if(f->second != NULL) return f->second->build();

		marslog(LOG_EROR, "Error in PProc factory trying to build backend %s", name.c_str());
		return 0;
	}
	else {
		return 0;
	}
}


PProcFactory::PProcFactory() {
}


} // namespace marspp


//----------------------------------------------------------------------------------------------------------------------

static marspp::PProc * pproc = NULL;

extern "C" {

err ppinit(const request *r, postproc *proc) {
    marslog(LOG_DBUG, "Forwarding ppinit()");
	return pproc->ppinit(r, proc);
}

err ppdone(void) {
	return pproc->ppdone();
}

err ppcount(int *in,int *out) {
	return pproc->ppcount(in, out);
}

err pparea(request *r) {
    return pproc->pparea(r);
}

fieldset* pp_fieldset(const char *file,request *filter) {
    return pproc->pp_fieldset(file, filter);
}

err ppstyle(const request *r) {
    return pproc->ppstyle(r);
}

err pprotation(const request *r) {
    return pproc->pprotation(r);
}

long ppestimate() {
    return pproc->ppestimate();
}

err makeuv(char *vo,char *d,long inlen,char *u,char *v,long *outlen) {
    return pproc->makeuv(vo, d, inlen, u, v, outlen);
}

int pproc_initialise(int argc, char** argv) {

    const char* pprocname = ::getenv("MARS_PPROC_BACKEND");

    // default pproc
    #if defined(HAVE_PPROC_EMOS)
    if(!pprocname) { pprocname = "EMOS"; }
    #elif defined(HAVE_PPROC_MIR)
    if(!pprocname) { pprocname = "MIR"; }
    #else
    if(!pprocname) { pprocname = "None"; }
    #endif

	pproc = marspp::PProcFactory::instance().build(pprocname);

    if(!pproc) {
        marslog(LOG_EROR,"Could not create PPROC backend %s", pprocname);
		return -1;
	}

    marslog(LOG_DBUG,"Created PPROC backend %s", pproc->name().c_str());

	return pproc->initialise(argc, argv);
}

} // extern "C"
