/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "PlotModInteractive.h"
#include "PlotModConst.h"

#include <QMessageBox>
#include <QString>

#include "uPlotBase.h"

PlotModInteractive::PlotModInteractive()
{
	isInteractive_   = true;
	isWindow_        = true;
	plotDestination_ = MVSCREEN;
	printerName_     = "";
	plotApplication_=0;
}

void
PlotModInteractive::UserMessage( const string& message )
{
	QString str = message.c_str();

	QMessageBox msgBox;
	msgBox.setText(str);
	msgBox.setStandardButtons(QMessageBox::Ok);
	msgBox.exec();
}

void
PlotModInteractive::progressMessage( const string& message )
{
	if(plotApplication_)
	  	plotApplication_->progressMessage(message);
}	


// print a message to the log window or the output; if 'priority', then 
// it will be visible without '-slog'
void PlotModInteractive::printMessage(const string& msg, bool /*priority*/)
{
    // XXX cannot seem to get the output to go to the proper message log
    cout << msg;
}


void
PlotModInteractive::SystemError ( const string & message, const string & /*title*/ )
{
	cout << "PlotMod::SystemError -> IT NEEDS TO IMPLEMENT THIS METHOD. " << message << endl;
#if 0
      string titleText ( "PlotMod System Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());
  
  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 
  send_message(PlotModApp::Instance().getService(),(request*)reqst);
#endif
}


#if 0
void
PlotMod::InternalError ( const string & message, const string & title )
{
     string titleText ( "PlotMod Internal Error" );
      if ( title.length() )
	titleText = titleText + ": " + title;
      InfoDialogManager::Instance().post( titleText.c_str(), message.c_str());

  MvRequest reqst("USER_MESSAGE");
  reqst("INFO") = message.c_str(); 

  send_message(PlotModApp::Instance().getService(),(request*)reqst);
}

#endif
