/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef LINEP_H
#define LINEP_H

#include <Xm/XmP.h>
#include <Xm/DrawingAP.h>

#ifdef __alpha
#define NO_STRING_TABLE_CVT
#endif

typedef struct _LineClassPart {
    int         ignore;
} LineClassPart;

typedef struct _LineClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
    XmDrawingAreaClassPart  drawing_area_class;
    LineClassPart     line_class;
} LineClassRec;

extern LineClassRec lineClassRec;

typedef struct {
	String *sizes;
} LinePart;


typedef struct _LineRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    XmDrawingAreaPart   drawing_area;
    LinePart            line;
}  LineRec;


#define XtLineNumChildren(w) (((LineWidget)w) -> composite.num_children)
#define XtLineChild(w,i)     (((LineWidget)w) -> composite.children[i])

#endif /* LINEP_H */



