/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef ExportDialog_H
#define ExportDialog_H

#include <QFileDialog>
#include <QPushButton>
#include <QGridLayout>
#include <QRadioButton>
#include <QLineEdit>

#include "MvQCheckBoxCombo.h"
#include "MvRequest.h"

using namespace std;


class ExportDialog : public QFileDialog
{
    Q_OBJECT

public:
    	ExportDialog(int, int, QWidget *parent = 0);
	~ExportDialog();

signals:	
	void sendExpDialogInfo(MvRequest*);

public slots:	
	void accept();
	void reject();
	void slotAdvancedButton(bool);
	void slotRangeFrameSelection(bool);

protected:
 	void setVisible(bool);

private:
	void getOutputFormatsReq ( string, QStringList&, MvRequest& );
	bool getFrameSelection ( MvRequest& );
	void buildFrameSelection( int, int, QGridLayout* );
	void errorMessage ( const char*, const char* = 0 );

	int current_;			// Current frame
	int total_;			// Total number of frames
	MvQCheckBoxCombo* comboBox_;	// List of output formats
	QPushButton* bAdvd_;		// Options button
	QLineEdit* leFs3_;		// Frame selection: line edit
	QRadioButton* cbFs1_;		// Frame selection: Current radio button
	QRadioButton* cbFs2_;		// Frame selection: All radio button
	QRadioButton* cbFs3_;		// Frame selection: Range radio button

//	MvQGui* ofGui_;			// Output formats user interface
};

#endif
