#ifndef MMatrix_H
#define MMatrix_H

#include <MMotifOnly.hpp>
#include <Matrix.h>

//
// Object for the Matrix widget, a constraint widget which
// places several chart in a matrix layout

class MMatrix : public MWidget
{
public:
	void init(MWidget* parent, const char *name, ...);
 
	void addScrollProc (int posit, ...);
	//	Add callbacks to the scroll bar
	//	Input:
	//		posit: position of the scroll bar, beginning
	//		with 0
	//		a list of:
	//			callback type
	//			callback function
	//			client data
	//		NULL to terminate the list

	void setScrollValues (int posit, int value,
			int scroll_size, int size,
			int increment, int page_increment); 
 	//	Set attributes of the scroll bar
	//	Input:
	//		posit: position of the scroll bar
	//		value: position of slider in scroll bar
	//		scroll_size: size of the scroll bar
	//		size: size of slider
	//		increment
	//		page increment
};

#endif
