/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef COLORSP_H
#define COLORSP_H

#include <Xm/XmP.h>
#include <Xm/PrimitiveP.h>

/* Colors class : no new fileds */

typedef struct _ColorsClassPart{
    int ignore;
} ColorsClassPart;

typedef struct _ColorsClassRec{
    CoreClassPart    core_class;
    XmPrimitiveClassPart  primitive_class;
    ColorsClassPart  colors_class;
} ColorsClassRec;

extern ColorsClassRec colorsClassRec;

typedef struct _ColorsPart {
	int             count;
	int             max;
	Pixel           *pixels;
	GC              *gc;
	XtCallbackList  activate;
	XmFontList      fontlist;
	char           *no_colours;
	GC              fontGC;
} ColorsPart;

typedef struct _ColorsRec {
    CorePart          core;
    XmPrimitivePart  primitive;
    ColorsPart        colors;
} ColorsRec;

#endif
