/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */

// File MarsRequestHandle.h
// Baudouin Raoult - (c) ECMWF Feb 12

#ifndef MarsRequestHandle_H
#define MarsRequestHandle_H

#include <memory>

#include "eckit/io/DataHandle.h"
#include "eckit/exception/Exceptions.h"

#include "metkit/mars/BaseProtocol.h"
#include "metkit/mars/MarsRequest.h"

namespace metkit {
namespace mars {

class MarsRequestHandle : public eckit::DataHandle {
public:

    class RetryTransfer : public eckit::Exception {
        virtual bool retryOnClient() const { return true; }
    public:
        RetryTransfer(const std::string& what):
            eckit::Exception(what) {}
    };

public:

    MarsRequestHandle(eckit::Stream&);

    MarsRequestHandle(const metkit::mars::MarsRequest& request,
                      const eckit::Configuration& database);

    MarsRequestHandle(const metkit::mars::MarsRequest& request,
                      metkit::mars::BaseProtocol* protocol);

    ~MarsRequestHandle();

    // -- Overridden methods (from Streamable)
    virtual std::string className() const { return "MarsRequestHandle"; }
    virtual const eckit::ReanimatorBase& reanimator() const;
    static  const eckit::ClassSpec& classSpec();

private: // members

    metkit::mars::MarsRequest request_;

    std::unique_ptr<BaseProtocol> protocol_;

    bool opened_;

private: // members

    void print(std::ostream&) const;
    void encode(eckit::Stream&) const;

    eckit::Length openForRead();
    void openForWrite(const eckit::Length&);
    void openForAppend(const eckit::Length&);
    long read(void*, long );
    long write(const void*, long);
    void close();
    bool canSeek() const;
};

}
}

#endif
