### R code from vignette source 'bms.Rnw'

###################################################
### code chunk number 1: bms.Rnw:16-17
###################################################
options(width=75)


###################################################
### code chunk number 2: bms.Rnw:64-65
###################################################
data(attitude)


###################################################
### code chunk number 3: bms.Rnw:68-69
###################################################
library(BMS)


###################################################
### code chunk number 4: bms.Rnw:72-73
###################################################
att = bms(attitude, mprior = "uniform", g="UIP", user.int=F)


###################################################
### code chunk number 5: bms.Rnw:79-80
###################################################
coef(att)


###################################################
### code chunk number 6: bms.Rnw:87-88
###################################################
coef(att, std.coefs=T, order.by.pip=F, include.constant=T) 


###################################################
### code chunk number 7: bms.Rnw:94-95
###################################################
summary(att) 


###################################################
### code chunk number 8: bms.Rnw:100-101
###################################################
topmodels.bma(att)[,1:3]


###################################################
### code chunk number 9: bms.Rnw:106-107
###################################################
image(att)


###################################################
### code chunk number 10: bms.Rnw:115-116
###################################################
sum(coef(att)[,1])


###################################################
### code chunk number 11: bms.Rnw:120-121
###################################################
plotModelsize(att)


###################################################
### code chunk number 12: bms.Rnw:132-133
###################################################
att_fixed = bms(attitude, mprior="fixed", mprior.size=2, user.int=T)


###################################################
### code chunk number 13: bms.Rnw:139-140
###################################################
att_pip = bms(attitude, mprior="pip", mprior.size=c(.01,.5,.5,.5,.5,.5), user.int=F)


###################################################
### code chunk number 14: bms.Rnw:146-147
###################################################
plotModelsize(att_fixed) 


###################################################
### code chunk number 15: bms.Rnw:153-155
###################################################
att_random = bms(attitude, mprior="random", mprior.size=3, user.int=F)
plotModelsize(att_random)


###################################################
### code chunk number 16: bms.Rnw:161-162 (eval = FALSE)
###################################################
## plotComp(Uniform=att, Fixed=att_fixed, PIP=att_pip, Random=att_random)


###################################################
### code chunk number 17: bms.Rnw:165-166
###################################################
plotComp(Uniform=att, Fixed=att_fixed, PIP=att_pip, Random=att_random, cex=2)


###################################################
### code chunk number 18: bms.Rnw:199-201
###################################################
data(datafls)
fls1 = bms(datafls, burn=50000, iter=100000, g="BRIC", mprior="uniform", nmodel=2000, mcmc="bd", user.int=F)


###################################################
### code chunk number 19: bms.Rnw:204-205
###################################################
summary(fls1)


###################################################
### code chunk number 20: bms.Rnw:209-210
###################################################
plotConv(fls1)


###################################################
### code chunk number 21: bms.Rnw:214-215
###################################################
plotConv(fls1[1:100])


###################################################
### code chunk number 22: bms.Rnw:223-224
###################################################
pmp.bma(fls1)[1:5,]


###################################################
### code chunk number 23: bms.Rnw:227-228
###################################################
colSums(pmp.bma(fls1))


###################################################
### code chunk number 24: bms.Rnw:231-232
###################################################
coef(fls1)[1:5,]


###################################################
### code chunk number 25: bms.Rnw:235-236
###################################################
coef(fls1,exact=TRUE)[1:5,]


###################################################
### code chunk number 26: bms.Rnw:247-249
###################################################
fls2= bms(datafls, burn=20000, iter=50000, g="BRIC", mprior="uniform", mcmc="rev.jump", start.value=0, user.int=F)
summary(fls2)


###################################################
### code chunk number 27: bms.Rnw:252-254
###################################################
fls_combi = c(fls1,fls2)
summary(fls_combi)


###################################################
### code chunk number 28: bms.Rnw:267-270
###################################################
fls_g5 = bms(datafls, burn=20000, iter=50000, g=5, mprior="uniform", user.int=F)
coef(fls_g5)[1:5,]
summary(fls_g5)


###################################################
### code chunk number 29: bms.Rnw:285-287
###################################################
fls_ebl = bms(datafls, burn=20000, iter=50000, g="EBL", mprior="uniform", nmodel=1000, user.int=F)
summary(fls_ebl)


###################################################
### code chunk number 30: bms.Rnw:290-291
###################################################
plot(fls_ebl)


###################################################
### code chunk number 31: bms.Rnw:298-300
###################################################
fls_hyper = bms(datafls, burn=20000, iter=50000, g="hyper=UIP", mprior="random", mprior.size=7, nmodel=1000, user.int=F)
summary(fls_hyper)


###################################################
### code chunk number 32: bms.Rnw:304-305
###################################################
gdensity(fls_hyper)


###################################################
### code chunk number 33: bms.Rnw:309-310
###################################################
image(fls_hyper)


###################################################
### code chunk number 34: bms.Rnw:318-319
###################################################
density(fls_combi,reg="Muslim")


###################################################
### code chunk number 35: bms.Rnw:323-324
###################################################
coef(fls_combi,exact=T,condi.coef=T)["Muslim",]


###################################################
### code chunk number 36: bms.Rnw:330-331
###################################################
dmuslim=density(fls_hyper,reg="Muslim",addons="Eebl")


###################################################
### code chunk number 37: bms.Rnw:337-338
###################################################
quantile(dmuslim, c(0.025, 0.975))


###################################################
### code chunk number 38: bms.Rnw:345-348
###################################################
fcstbma= bms(datafls[1:70,], mprior="uniform", burn=20000, iter=50000, user.int=FALSE)

pdens = pred.density(fcstbma, newdata=datafls[71:72,])


###################################################
### code chunk number 39: bms.Rnw:354-355
###################################################
plot(pdens, 2)


###################################################
### code chunk number 40: bms.Rnw:361-362
###################################################
quantile(pdens, c(0.05, 0.95))


###################################################
### code chunk number 41: bms.Rnw:368-369
###################################################
pdens$dyf(datafls[71:72,1])


###################################################
### code chunk number 42: bms.Rnw:373-374
###################################################
plot(pdens, "ZM", realized.y=datafls["ZM",1])


###################################################
### code chunk number 43: bms.Rnw:381-382
###################################################
lps.bma(pdens, datafls[71:72,1])


###################################################
### code chunk number 44: bms.Rnw:471-472
###################################################
data(attitude)


###################################################
### code chunk number 45: bms.Rnw:475-476
###################################################
att_full = zlm(attitude,g="UIP")


###################################################
### code chunk number 46: bms.Rnw:479-480
###################################################
summary(att_full)


###################################################
### code chunk number 47: bms.Rnw:484-486
###################################################
att_best = as.zlm(att,model=1)
summary(att_best)


###################################################
### code chunk number 48: bms.Rnw:491-493
###################################################
att_bestlm = lm(model.frame(as.zlm(att)))
summary(att_bestlm)


###################################################
### code chunk number 49: bms.Rnw:502-503
###################################################
att_learn = bms(attitude,mprior="uniform", fixed.reg=c("complaints", "learning") )


###################################################
### code chunk number 50: bms.Rnw:512-513
###################################################
fls_culture = bms(datafls,fixed.reg=c(1,8:16,24,26:41), mprior="random", mprior.size=28, mcmc="enumeration", user.int=F)


###################################################
### code chunk number 51: bms.Rnw:517-518
###################################################
coef(fls_culture)[28:41, ]


###################################################
### code chunk number 52: bms.Rnw:522-523
###################################################
plotModelsize(fls_culture, ksubset=27:41)


